/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    @LazyInit
    private transient @MonotonicNonNull Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    Converter(boolean bl2) {
        this.handleNullAutomatically = bl2;
    }

    @ForOverride
    protected abstract B doForward(A var1);

    @ForOverride
    protected abstract A doBackward(B var1);

    @CanIgnoreReturnValue
    public final @Nullable B convert(@Nullable A a2) {
        return this.correctedDoForward(a2);
    }

    @Nullable B correctedDoForward(@Nullable A a2) {
        if (this.handleNullAutomatically) {
            return a2 == null ? null : (B)Preconditions.checkNotNull(this.doForward(a2));
        }
        return this.doForward(a2);
    }

    @Nullable A correctedDoBackward(@Nullable B b2) {
        if (this.handleNullAutomatically) {
            return b2 == null ? null : (A)Preconditions.checkNotNull(this.doBackward(b2));
        }
        return this.doBackward(b2);
    }

    @CanIgnoreReturnValue
    public Iterable<B> convertAll(final Iterable<? extends A> iterable) {
        Preconditions.checkNotNull(iterable, "fromIterable");
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> fromIterator;
                    {
                        this.fromIterator = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fromIterator.hasNext();
                    }

                    @Override
                    public B next() {
                        return Converter.this.convert(this.fromIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.fromIterator.remove();
                    }
                };
            }
        };
    }

    @CanIgnoreReturnValue
    public Converter<B, A> reverse() {
        Converter<A, B> converter = this.reverse;
        return converter == null ? (this.reverse = new ReverseConverter(this)) : converter;
    }

    @Override
    public final <C> Converter<A, C> andThen(Converter<B, C> converter) {
        return this.doAndThen(converter);
    }

    <C> Converter<A, C> doAndThen(Converter<B, C> converter) {
        return new ConverterComposition(this, Preconditions.checkNotNull(converter));
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final @Nullable B apply(@Nullable A a2) {
        return this.convert(a2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return super.equals(object);
    }

    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
        return new FunctionBasedConverter(function, function2);
    }

    public static <T> Converter<T, T> identity() {
        return IdentityConverter.INSTANCE;
    }

    private static final class IdentityConverter<T>
    extends Converter<T, T>
    implements Serializable {
        static final IdentityConverter INSTANCE = new IdentityConverter();
        private static final long serialVersionUID = 0L;

        private IdentityConverter() {
        }

        @Override
        protected T doForward(T t2) {
            return t2;
        }

        @Override
        protected T doBackward(T t2) {
            return t2;
        }

        public IdentityConverter<T> reverse() {
            return this;
        }

        @Override
        <S> Converter<T, S> doAndThen(Converter<T, S> converter) {
            return Preconditions.checkNotNull(converter, "otherConverter");
        }

        public String toString() {
            return "Converter.identity()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class FunctionBasedConverter<A, B>
    extends Converter<A, B>
    implements Serializable {
        private final Function<? super A, ? extends B> forwardFunction;
        private final Function<? super B, ? extends A> backwardFunction;

        private FunctionBasedConverter(Function<? super A, ? extends B> function, Function<? super B, ? extends A> function2) {
            this.forwardFunction = Preconditions.checkNotNull(function);
            this.backwardFunction = Preconditions.checkNotNull(function2);
        }

        @Override
        protected B doForward(A a2) {
            return this.forwardFunction.apply(a2);
        }

        @Override
        protected A doBackward(B b2) {
            return this.backwardFunction.apply(b2);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof FunctionBasedConverter) {
                FunctionBasedConverter functionBasedConverter = (FunctionBasedConverter)object;
                return this.forwardFunction.equals(functionBasedConverter.forwardFunction) && this.backwardFunction.equals(functionBasedConverter.backwardFunction);
            }
            return false;
        }

        public int hashCode() {
            return this.forwardFunction.hashCode() * 31 + this.backwardFunction.hashCode();
        }

        public String toString() {
            return "Converter.from(" + this.forwardFunction + ", " + this.backwardFunction + ")";
        }
    }

    private static final class ConverterComposition<A, B, C>
    extends Converter<A, C>
    implements Serializable {
        final Converter<A, B> first;
        final Converter<B, C> second;
        private static final long serialVersionUID = 0L;

        ConverterComposition(Converter<A, B> converter, Converter<B, C> converter2) {
            this.first = converter;
            this.second = converter2;
        }

        @Override
        protected C doForward(A a2) {
            throw new AssertionError();
        }

        @Override
        protected A doBackward(C c2) {
            throw new AssertionError();
        }

        @Override
        @Nullable C correctedDoForward(@Nullable A a2) {
            return this.second.correctedDoForward(this.first.correctedDoForward(a2));
        }

        @Override
        @Nullable A correctedDoBackward(@Nullable C c2) {
            return this.first.correctedDoBackward(this.second.correctedDoBackward(c2));
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof ConverterComposition) {
                ConverterComposition converterComposition = (ConverterComposition)object;
                return this.first.equals(converterComposition.first) && this.second.equals(converterComposition.second);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }

        public String toString() {
            return this.first + ".andThen(" + this.second + ")";
        }
    }

    private static final class ReverseConverter<A, B>
    extends Converter<B, A>
    implements Serializable {
        final Converter<A, B> original;
        private static final long serialVersionUID = 0L;

        ReverseConverter(Converter<A, B> converter) {
            this.original = converter;
        }

        @Override
        protected A doForward(B b2) {
            throw new AssertionError();
        }

        @Override
        protected B doBackward(A a2) {
            throw new AssertionError();
        }

        @Override
        @Nullable A correctedDoForward(@Nullable B b2) {
            return this.original.correctedDoBackward(b2);
        }

        @Override
        @Nullable B correctedDoBackward(@Nullable A a2) {
            return this.original.correctedDoForward(a2);
        }

        @Override
        public Converter<A, B> reverse() {
            return this.original;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof ReverseConverter) {
                ReverseConverter reverseConverter = (ReverseConverter)object;
                return this.original.equals(reverseConverter.original);
            }
            return false;
        }

        public int hashCode() {
            return ~this.original.hashCode();
        }

        public String toString() {
            return this.original + ".reverse()";
        }
    }
}

