/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import java.util.BitSet;

@GwtCompatible(emulated=true)
public abstract class CharMatcher
implements Predicate<Character> {
    private static final int DISTINCT_CHARS = 65536;

    public static CharMatcher any() {
        return Any.INSTANCE;
    }

    public static CharMatcher none() {
        return None.INSTANCE;
    }

    public static CharMatcher whitespace() {
        return Whitespace.INSTANCE;
    }

    public static CharMatcher breakingWhitespace() {
        return BreakingWhitespace.INSTANCE;
    }

    public static CharMatcher ascii() {
        return Ascii.INSTANCE;
    }

    @Deprecated
    public static CharMatcher digit() {
        return Digit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaDigit() {
        return JavaDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetter() {
        return JavaLetter.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLetterOrDigit() {
        return JavaLetterOrDigit.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaUpperCase() {
        return JavaUpperCase.INSTANCE;
    }

    @Deprecated
    public static CharMatcher javaLowerCase() {
        return JavaLowerCase.INSTANCE;
    }

    public static CharMatcher javaIsoControl() {
        return JavaIsoControl.INSTANCE;
    }

    @Deprecated
    public static CharMatcher invisible() {
        return Invisible.INSTANCE;
    }

    @Deprecated
    public static CharMatcher singleWidth() {
        return SingleWidth.INSTANCE;
    }

    public static CharMatcher is(char c2) {
        return new Is(c2);
    }

    public static CharMatcher isNot(char c2) {
        return new IsNot(c2);
    }

    public static CharMatcher anyOf(CharSequence charSequence) {
        switch (charSequence.length()) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is(charSequence.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither(charSequence.charAt(0), charSequence.charAt(1));
            }
        }
        return new AnyOf(charSequence);
    }

    public static CharMatcher noneOf(CharSequence charSequence) {
        return CharMatcher.anyOf(charSequence).negate();
    }

    public static CharMatcher inRange(char c2, char c3) {
        return new InRange(c2, c3);
    }

    public static CharMatcher forPredicate(Predicate<? super Character> predicate) {
        return predicate instanceof CharMatcher ? (CharMatcher)predicate : new ForPredicate(predicate);
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new Negated(this);
    }

    public CharMatcher and(CharMatcher charMatcher) {
        return new And(this, charMatcher);
    }

    public CharMatcher or(CharMatcher charMatcher) {
        return new Or(this, charMatcher);
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    @GwtIncompatible
    CharMatcher precomputedInternal() {
        BitSet bitSet = new BitSet();
        this.setBits(bitSet);
        int n2 = bitSet.cardinality();
        if (n2 * 2 <= 65536) {
            return CharMatcher.precomputedPositive(n2, bitSet, this.toString());
        }
        bitSet.flip(0, 65536);
        int n3 = 65536 - n2;
        String string = ".negate()";
        final String string2 = this.toString();
        String string3 = string2.endsWith(string) ? string2.substring(0, string2.length() - string.length()) : string2 + string;
        return new NegatedFastMatcher(CharMatcher.precomputedPositive(n3, bitSet, string3)){

            @Override
            public String toString() {
                return string2;
            }
        };
    }

    @GwtIncompatible
    private static CharMatcher precomputedPositive(int n2, BitSet bitSet, String string) {
        switch (n2) {
            case 0: {
                return CharMatcher.none();
            }
            case 1: {
                return CharMatcher.is((char)bitSet.nextSetBit(0));
            }
            case 2: {
                char c2 = (char)bitSet.nextSetBit(0);
                char c3 = (char)bitSet.nextSetBit(c2 + '\u0001');
                return CharMatcher.isEither(c2, c3);
            }
        }
        return CharMatcher.isSmall(n2, bitSet.length()) ? SmallCharMatcher.from(bitSet, string) : new BitSetMatcher(bitSet, string);
    }

    @GwtIncompatible
    private static boolean isSmall(int n2, int n3) {
        return n2 <= 1023 && n3 > n2 * 4 * 16;
    }

    @GwtIncompatible
    void setBits(BitSet bitSet) {
        for (int i2 = 65535; i2 >= 0; --i2) {
            if (!this.matches((char)i2)) continue;
            bitSet.set(i2);
        }
    }

    public boolean matchesAnyOf(CharSequence charSequence) {
        return !this.matchesNoneOf(charSequence);
    }

    public boolean matchesAllOf(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence charSequence) {
        return this.indexIn(charSequence) == -1;
    }

    public int indexIn(CharSequence charSequence) {
        return this.indexIn(charSequence, 0);
    }

    public int indexIn(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        Preconditions.checkPositionIndex(n2, n3);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence charSequence) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (!this.matches(charSequence.charAt(i2))) continue;
            ++n2;
        }
        return n2;
    }

    public String removeFrom(CharSequence charSequence) {
        String string = charSequence.toString();
        int n2 = this.indexIn(string);
        if (n2 == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n3 = 1;
        block0: while (true) {
            ++n2;
            while (n2 != cArray.length) {
                if (!this.matches(cArray[n2])) {
                    cArray[n2 - n3] = cArray[n2];
                    ++n2;
                    continue;
                }
                ++n3;
                continue block0;
            }
            break;
        }
        return new String(cArray, 0, n2 - n3);
    }

    public String retainFrom(CharSequence charSequence) {
        return this.negate().removeFrom(charSequence);
    }

    public String replaceFrom(CharSequence charSequence, char c2) {
        String string = charSequence.toString();
        int n2 = this.indexIn(string);
        if (n2 == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[n2] = c2;
        for (int i2 = n2 + 1; i2 < cArray.length; ++i2) {
            if (!this.matches(cArray[i2])) continue;
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = charSequence2.length();
        if (n2 == 0) {
            return this.removeFrom(charSequence);
        }
        if (n2 == 1) {
            return this.replaceFrom(charSequence, charSequence2.charAt(0));
        }
        String string = charSequence.toString();
        int n3 = this.indexIn(string);
        if (n3 == -1) {
            return string;
        }
        int n4 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n4 * 3 / 2 + 16);
        int n5 = 0;
        do {
            stringBuilder.append(string, n5, n3);
            stringBuilder.append(charSequence2);
        } while ((n3 = this.indexIn(string, n5 = n3 + 1)) != -1);
        stringBuilder.append(string, n5, n4);
        return stringBuilder.toString();
    }

    public String trimFrom(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = charSequence.length();
        for (n3 = 0; n3 < n4 && this.matches(charSequence.charAt(n3)); ++n3) {
        }
        for (n2 = n4 - 1; n2 > n3 && this.matches(charSequence.charAt(n2)); --n2) {
        }
        return charSequence.subSequence(n3, n2 + 1).toString();
    }

    public String trimLeadingFrom(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(i2, n2).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (this.matches(charSequence.charAt(i2))) continue;
            return charSequence.subSequence(0, i2 + 1).toString();
        }
        return "";
    }

    public String collapseFrom(CharSequence charSequence, char c2) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (!this.matches(c3)) continue;
            if (!(c3 != c2 || i2 != n2 - 1 && this.matches(charSequence.charAt(i2 + 1)))) {
                ++i2;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(n2).append(charSequence, 0, i2).append(c2);
            return this.finishCollapseFrom(charSequence, i2 + 1, n2, c2, stringBuilder, true);
        }
        return charSequence.toString();
    }

    public String trimAndCollapseFrom(CharSequence charSequence, char c2) {
        int n2;
        int n3 = charSequence.length();
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n3 && this.matches(charSequence.charAt(n2)); ++n2) {
        }
        while (n4 > n2 && this.matches(charSequence.charAt(n4))) {
            --n4;
        }
        return n2 == 0 && n4 == n3 - 1 ? this.collapseFrom(charSequence, c2) : this.finishCollapseFrom(charSequence, n2, n4 + 1, c2, new StringBuilder(n4 + 1 - n2), false);
    }

    private String finishCollapseFrom(CharSequence charSequence, int n2, int n3, char c2, StringBuilder stringBuilder, boolean bl2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c3 = charSequence.charAt(i2);
            if (this.matches(c3)) {
                if (bl2) continue;
                stringBuilder.append(c2);
                bl2 = true;
                continue;
            }
            stringBuilder.append(c3);
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    @Override
    @Deprecated
    public boolean apply(Character c2) {
        return this.matches(c2.charValue());
    }

    public String toString() {
        return super.toString();
    }

    private static String showCharacter(char c2) {
        String string = "0123456789ABCDEF";
        char[] cArray = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i2 = 0; i2 < 4; ++i2) {
            cArray[5 - i2] = string.charAt(c2 & 0xF);
            c2 = (char)(c2 >> 4);
        }
        return String.copyValueOf(cArray);
    }

    private static IsEither isEither(char c2, char c3) {
        return new IsEither(c2, c3);
    }

    private static final class ForPredicate
    extends CharMatcher {
        private final Predicate<? super Character> predicate;

        ForPredicate(Predicate<? super Character> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean matches(char c2) {
            return this.predicate.apply(Character.valueOf(c2));
        }

        @Override
        public boolean apply(Character c2) {
            return this.predicate.apply(Preconditions.checkNotNull(c2));
        }

        @Override
        public String toString() {
            return "CharMatcher.forPredicate(" + this.predicate + ")";
        }
    }

    private static final class InRange
    extends FastMatcher {
        private final char startInclusive;
        private final char endInclusive;

        InRange(char c2, char c3) {
            Preconditions.checkArgument(c3 >= c2);
            this.startInclusive = c2;
            this.endInclusive = c3;
        }

        @Override
        public boolean matches(char c2) {
            return this.startInclusive <= c2 && c2 <= this.endInclusive;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            bitSet.set((int)this.startInclusive, this.endInclusive + '\u0001');
        }

        @Override
        public String toString() {
            return "CharMatcher.inRange('" + CharMatcher.showCharacter(this.startInclusive) + "', '" + CharMatcher.showCharacter(this.endInclusive) + "')";
        }
    }

    private static final class AnyOf
    extends CharMatcher {
        private final char[] chars;

        public AnyOf(CharSequence charSequence) {
            this.chars = charSequence.toString().toCharArray();
            Arrays.sort(this.chars);
        }

        @Override
        public boolean matches(char c2) {
            return Arrays.binarySearch(this.chars, c2) >= 0;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            for (char c2 : this.chars) {
                bitSet.set(c2);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("CharMatcher.anyOf(\"");
            for (char c2 : this.chars) {
                stringBuilder.append(CharMatcher.showCharacter(c2));
            }
            stringBuilder.append("\")");
            return stringBuilder.toString();
        }
    }

    private static final class IsEither
    extends FastMatcher {
        private final char match1;
        private final char match2;

        IsEither(char c2, char c3) {
            this.match1 = c2;
            this.match2 = c3;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.match1 || c2 == this.match2;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            bitSet.set(this.match1);
            bitSet.set(this.match2);
        }

        @Override
        public String toString() {
            return "CharMatcher.anyOf(\"" + CharMatcher.showCharacter(this.match1) + CharMatcher.showCharacter(this.match2) + "\")";
        }
    }

    private static final class IsNot
    extends FastMatcher {
        private final char match;

        IsNot(char c2) {
            this.match = c2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 != this.match;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return charMatcher.matches(this.match) ? super.and(charMatcher) : charMatcher;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return charMatcher.matches(this.match) ? IsNot.any() : this;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            bitSet.set(0, this.match);
            bitSet.set(this.match + '\u0001', 65536);
        }

        @Override
        public CharMatcher negate() {
            return IsNot.is(this.match);
        }

        @Override
        public String toString() {
            return "CharMatcher.isNot('" + CharMatcher.showCharacter(this.match) + "')";
        }
    }

    private static final class Is
    extends FastMatcher {
        private final char match;

        Is(char c2) {
            this.match = c2;
        }

        @Override
        public boolean matches(char c2) {
            return c2 == this.match;
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString().replace(this.match, c2);
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return charMatcher.matches(this.match) ? this : Is.none();
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return charMatcher.matches(this.match) ? charMatcher : super.or(charMatcher);
        }

        @Override
        public CharMatcher negate() {
            return Is.isNot(this.match);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            bitSet.set(this.match);
        }

        @Override
        public String toString() {
            return "CharMatcher.is('" + CharMatcher.showCharacter(this.match) + "')";
        }
    }

    private static final class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        Or(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.first = Preconditions.checkNotNull(charMatcher);
            this.second = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            this.first.setBits(bitSet);
            this.second.setBits(bitSet);
        }

        @Override
        public boolean matches(char c2) {
            return this.first.matches(c2) || this.second.matches(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.or(" + this.first + ", " + this.second + ")";
        }
    }

    private static final class And
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        And(CharMatcher charMatcher, CharMatcher charMatcher2) {
            this.first = Preconditions.checkNotNull(charMatcher);
            this.second = Preconditions.checkNotNull(charMatcher2);
        }

        @Override
        public boolean matches(char c2) {
            return this.first.matches(c2) && this.second.matches(c2);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            BitSet bitSet2 = new BitSet();
            this.first.setBits(bitSet2);
            BitSet bitSet3 = new BitSet();
            this.second.setBits(bitSet3);
            bitSet2.and(bitSet3);
            bitSet.or(bitSet2);
        }

        @Override
        public String toString() {
            return "CharMatcher.and(" + this.first + ", " + this.second + ")";
        }
    }

    private static class Negated
    extends CharMatcher {
        final CharMatcher original;

        Negated(CharMatcher charMatcher) {
            this.original = Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public boolean matches(char c2) {
            return !this.original.matches(c2);
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return this.original.matchesNoneOf(charSequence);
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return this.original.matchesAllOf(charSequence);
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length() - this.original.countIn(charSequence);
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            BitSet bitSet2 = new BitSet();
            this.original.setBits(bitSet2);
            bitSet2.flip(0, 65536);
            bitSet.or(bitSet2);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        public String toString() {
            return this.original + ".negate()";
        }
    }

    private static final class SingleWidth
    extends RangesMatcher {
        static final SingleWidth INSTANCE = new SingleWidth();

        private SingleWidth() {
            super("CharMatcher.singleWidth()", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        }
    }

    private static final class Invisible
    extends RangesMatcher {
        private static final String RANGE_STARTS = "\u0000\u007f\u00ad\u0600\u061c\u06dd\u070f\u08e2\u1680\u180e\u2000\u2028\u205f\u2066\u3000\ud800\ufeff\ufff9";
        private static final String RANGE_ENDS = " \u00a0\u00ad\u0605\u061c\u06dd\u070f\u08e2\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufffb";
        static final Invisible INSTANCE = new Invisible();

        private Invisible() {
            super("CharMatcher.invisible()", RANGE_STARTS.toCharArray(), RANGE_ENDS.toCharArray());
        }
    }

    private static final class JavaIsoControl
    extends NamedFastMatcher {
        static final JavaIsoControl INSTANCE = new JavaIsoControl();

        private JavaIsoControl() {
            super("CharMatcher.javaIsoControl()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f';
        }
    }

    private static final class JavaLowerCase
    extends CharMatcher {
        static final JavaLowerCase INSTANCE = new JavaLowerCase();

        private JavaLowerCase() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLowerCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLowerCase()";
        }
    }

    private static final class JavaUpperCase
    extends CharMatcher {
        static final JavaUpperCase INSTANCE = new JavaUpperCase();

        private JavaUpperCase() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isUpperCase(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaUpperCase()";
        }
    }

    private static final class JavaLetterOrDigit
    extends CharMatcher {
        static final JavaLetterOrDigit INSTANCE = new JavaLetterOrDigit();

        private JavaLetterOrDigit() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetterOrDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetterOrDigit()";
        }
    }

    private static final class JavaLetter
    extends CharMatcher {
        static final JavaLetter INSTANCE = new JavaLetter();

        private JavaLetter() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isLetter(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaLetter()";
        }
    }

    private static final class JavaDigit
    extends CharMatcher {
        static final JavaDigit INSTANCE = new JavaDigit();

        private JavaDigit() {
        }

        @Override
        public boolean matches(char c2) {
            return Character.isDigit(c2);
        }

        @Override
        public String toString() {
            return "CharMatcher.javaDigit()";
        }
    }

    private static final class Digit
    extends RangesMatcher {
        private static final String ZEROES = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uff10";
        static final Digit INSTANCE = new Digit();

        private static char[] zeroes() {
            return ZEROES.toCharArray();
        }

        private static char[] nines() {
            char[] cArray = new char[ZEROES.length()];
            for (int i2 = 0; i2 < ZEROES.length(); ++i2) {
                cArray[i2] = (char)(ZEROES.charAt(i2) + 9);
            }
            return cArray;
        }

        private Digit() {
            super("CharMatcher.digit()", Digit.zeroes(), Digit.nines());
        }
    }

    private static class RangesMatcher
    extends CharMatcher {
        private final String description;
        private final char[] rangeStarts;
        private final char[] rangeEnds;

        RangesMatcher(String string, char[] cArray, char[] cArray2) {
            this.description = string;
            this.rangeStarts = cArray;
            this.rangeEnds = cArray2;
            Preconditions.checkArgument(cArray.length == cArray2.length);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                Preconditions.checkArgument(cArray[i2] <= cArray2[i2]);
                if (i2 + 1 >= cArray.length) continue;
                Preconditions.checkArgument(cArray2[i2] < cArray[i2 + 1]);
            }
        }

        @Override
        public boolean matches(char c2) {
            int n2 = Arrays.binarySearch(this.rangeStarts, c2);
            if (n2 >= 0) {
                return true;
            }
            return (n2 = ~n2 - 1) >= 0 && c2 <= this.rangeEnds[n2];
        }

        @Override
        public String toString() {
            return this.description;
        }
    }

    private static final class Ascii
    extends NamedFastMatcher {
        static final Ascii INSTANCE = new Ascii();

        Ascii() {
            super("CharMatcher.ascii()");
        }

        @Override
        public boolean matches(char c2) {
            return c2 <= '\u007f';
        }
    }

    private static final class BreakingWhitespace
    extends CharMatcher {
        static final CharMatcher INSTANCE = new BreakingWhitespace();

        private BreakingWhitespace() {
        }

        @Override
        public boolean matches(char c2) {
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c2 >= '\u2000' && c2 <= '\u200a';
        }

        @Override
        public String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    @VisibleForTesting
    static final class Whitespace
    extends NamedFastMatcher {
        static final String TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
        static final int MULTIPLIER = 1682554634;
        static final int SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);
        static final Whitespace INSTANCE = new Whitespace();

        Whitespace() {
            super("CharMatcher.whitespace()");
        }

        @Override
        public boolean matches(char c2) {
            return TABLE.charAt(1682554634 * c2 >>> SHIFT) == c2;
        }

        @Override
        @GwtIncompatible
        void setBits(BitSet bitSet) {
            for (int i2 = 0; i2 < TABLE.length(); ++i2) {
                bitSet.set(TABLE.charAt(i2));
            }
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final None INSTANCE = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public boolean matches(char c2) {
            return false;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            int n3 = charSequence.length();
            Preconditions.checkPositionIndex(n2, n3);
            return -1;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return -1;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            return charSequence.length() == 0;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            Preconditions.checkNotNull(charSequence2);
            return charSequence.toString();
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.toString();
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimLeadingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public String trimTrailingFrom(CharSequence charSequence) {
            return charSequence.toString();
        }

        @Override
        public int countIn(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return 0;
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public CharMatcher negate() {
            return None.any();
        }
    }

    private static final class Any
    extends NamedFastMatcher {
        static final Any INSTANCE = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public boolean matches(char c2) {
            return true;
        }

        @Override
        public int indexIn(CharSequence charSequence) {
            return charSequence.length() == 0 ? -1 : 0;
        }

        @Override
        public int indexIn(CharSequence charSequence, int n2) {
            int n3 = charSequence.length();
            Preconditions.checkPositionIndex(n2, n3);
            return n2 == n3 ? -1 : n2;
        }

        @Override
        public int lastIndexIn(CharSequence charSequence) {
            return charSequence.length() - 1;
        }

        @Override
        public boolean matchesAllOf(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return true;
        }

        @Override
        public boolean matchesNoneOf(CharSequence charSequence) {
            return charSequence.length() == 0;
        }

        @Override
        public String removeFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public String replaceFrom(CharSequence charSequence, char c2) {
            char[] cArray = new char[charSequence.length()];
            Arrays.fill(cArray, c2);
            return new String(cArray);
        }

        @Override
        public String replaceFrom(CharSequence charSequence, CharSequence charSequence2) {
            StringBuilder stringBuilder = new StringBuilder(charSequence.length() * charSequence2.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                stringBuilder.append(charSequence2);
            }
            return stringBuilder.toString();
        }

        @Override
        public String collapseFrom(CharSequence charSequence, char c2) {
            return charSequence.length() == 0 ? "" : String.valueOf(c2);
        }

        @Override
        public String trimFrom(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return "";
        }

        @Override
        public int countIn(CharSequence charSequence) {
            return charSequence.length();
        }

        @Override
        public CharMatcher and(CharMatcher charMatcher) {
            return Preconditions.checkNotNull(charMatcher);
        }

        @Override
        public CharMatcher or(CharMatcher charMatcher) {
            Preconditions.checkNotNull(charMatcher);
            return this;
        }

        @Override
        public CharMatcher negate() {
            return Any.none();
        }
    }

    @GwtIncompatible
    private static final class BitSetMatcher
    extends NamedFastMatcher {
        private final BitSet table;

        private BitSetMatcher(BitSet bitSet, String string) {
            super(string);
            if (bitSet.length() + 64 < bitSet.size()) {
                bitSet = (BitSet)bitSet.clone();
            }
            this.table = bitSet;
        }

        @Override
        public boolean matches(char c2) {
            return this.table.get(c2);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.or(this.table);
        }
    }

    static class NegatedFastMatcher
    extends Negated {
        NegatedFastMatcher(CharMatcher charMatcher) {
            super(charMatcher);
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        NamedFastMatcher(String string) {
            this.description = Preconditions.checkNotNull(string);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }
}

