/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@GwtCompatible
public final class Ascii {
    public static final byte NUL = 0;
    public static final byte SOH = 1;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final byte EOT = 4;
    public static final byte ENQ = 5;
    public static final byte ACK = 6;
    public static final byte BEL = 7;
    public static final byte BS = 8;
    public static final byte HT = 9;
    public static final byte LF = 10;
    public static final byte NL = 10;
    public static final byte VT = 11;
    public static final byte FF = 12;
    public static final byte CR = 13;
    public static final byte SO = 14;
    public static final byte SI = 15;
    public static final byte DLE = 16;
    public static final byte DC1 = 17;
    public static final byte XON = 17;
    public static final byte DC2 = 18;
    public static final byte DC3 = 19;
    public static final byte XOFF = 19;
    public static final byte DC4 = 20;
    public static final byte NAK = 21;
    public static final byte SYN = 22;
    public static final byte ETB = 23;
    public static final byte CAN = 24;
    public static final byte EM = 25;
    public static final byte SUB = 26;
    public static final byte ESC = 27;
    public static final byte FS = 28;
    public static final byte GS = 29;
    public static final byte RS = 30;
    public static final byte US = 31;
    public static final byte SP = 32;
    public static final byte SPACE = 32;
    public static final byte DEL = 127;
    public static final char MIN = '\u0000';
    public static final char MAX = '\u007f';
    private static final char CASE_MASK = ' ';

    private Ascii() {
    }

    public static String toLowerCase(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Ascii.isUpperCase(string.charAt(i2))) continue;
            char[] cArray = string.toCharArray();
            while (i2 < n2) {
                char c2 = cArray[i2];
                if (Ascii.isUpperCase(c2)) {
                    cArray[i2] = (char)(c2 ^ 0x20);
                }
                ++i2;
            }
            return String.valueOf(cArray);
        }
        return string;
    }

    public static String toLowerCase(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return Ascii.toLowerCase((String)charSequence);
        }
        char[] cArray = new char[charSequence.length()];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = Ascii.toLowerCase(charSequence.charAt(i2));
        }
        return String.valueOf(cArray);
    }

    public static char toLowerCase(char c2) {
        return Ascii.isUpperCase(c2) ? (char)(c2 ^ 0x20) : c2;
    }

    public static String toUpperCase(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Ascii.isLowerCase(string.charAt(i2))) continue;
            char[] cArray = string.toCharArray();
            while (i2 < n2) {
                char c2 = cArray[i2];
                if (Ascii.isLowerCase(c2)) {
                    cArray[i2] = (char)(c2 ^ 0x20);
                }
                ++i2;
            }
            return String.valueOf(cArray);
        }
        return string;
    }

    public static String toUpperCase(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return Ascii.toUpperCase((String)charSequence);
        }
        char[] cArray = new char[charSequence.length()];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = Ascii.toUpperCase(charSequence.charAt(i2));
        }
        return String.valueOf(cArray);
    }

    public static char toUpperCase(char c2) {
        return Ascii.isLowerCase(c2) ? (char)(c2 ^ 0x20) : c2;
    }

    public static boolean isLowerCase(char c2) {
        return c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isUpperCase(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }

    public static String truncate(CharSequence charSequence, int n2, String string) {
        Preconditions.checkNotNull(charSequence);
        int n3 = n2 - string.length();
        Preconditions.checkArgument(n3 >= 0, "maxLength (%s) must be >= length of the truncation indicator (%s)", n2, string.length());
        if (charSequence.length() <= n2) {
            String string2 = charSequence.toString();
            if (string2.length() <= n2) {
                return string2;
            }
            charSequence = string2;
        }
        return new StringBuilder(n2).append(charSequence, 0, n3).append(string).toString();
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = charSequence.length();
        if (charSequence == charSequence2) {
            return true;
        }
        if (n2 != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            char c2;
            char c3 = charSequence.charAt(i2);
            if (c3 == (c2 = charSequence2.charAt(i2)) || (n3 = Ascii.getAlphaIndex(c3)) < 26 && n3 == Ascii.getAlphaIndex(c2)) continue;
            return false;
        }
        return true;
    }

    private static int getAlphaIndex(char c2) {
        return (char)((c2 | 0x20) - 97);
    }
}

