/*
 * Decompiled with CFR 0.152.
 */
package satDomain;

import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import satDomain.Clause;
import satDomain.UnexpectedComplexity;

class CNFSolver {
    private ISolver solver = SolverFactory.newDefault();

    CNFSolver(int numVars) {
        int resVars = this.solver.newVar(numVars);
        assert (resVars == numVars);
    }

    void addClause(Clause clause) {
        if (this.solver != null) {
            try {
                this.addClauseUnchecked(clause);
            }
            catch (ContradictionException e) {
                this.solver = null;
            }
        }
    }

    boolean checkSat() {
        if (this.solver == null) {
            return false;
        }
        try {
            return this.solver.isSatisfiable();
        }
        catch (TimeoutException e) {
            throw new UnexpectedComplexity("checkSat");
        }
    }

    private void addClauseUnchecked(Clause clause) throws ContradictionException {
        this.solver.addClause(clause.toVecInt());
    }
}

