/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import javalx.exceptions.UnimplementedException;
import rreil.RReilGrammarException;
import rreil.assembler.CompiledAssembler;
import rreil.lang.AssemblerParseable;
import rreil.lang.AssertionOp;
import rreil.lang.FlopOp;
import rreil.lang.Lhs;
import rreil.lang.RReilAddr;
import rreil.lang.Reconstructable;
import rreil.lang.Rhs;
import rreil.lang.util.RReilVisitor;

public abstract class RReil
implements AssemblerParseable,
Reconstructable {
    protected static final char $AddressSeparator = '&';
    protected static final String $OperandSeparator = ", ";
    protected static final char $SizeSeparator = ':';
    protected static final char $OffsetSeparator = '/';
    private final RReilAddr address;

    private RReil(RReilAddr rreilAddress) {
        this.address = rreilAddress;
    }

    public static RReil from(String instruction) {
        CompiledAssembler compiled = CompiledAssembler.from(instruction);
        SortedMap<RReilAddr, RReil> instructions = compiled.getInstructions();
        assert (instructions.size() == 1);
        return (RReil)instructions.get(instructions.firstKey());
    }

    public RReilAddr getRReilAddress() {
        return this.address;
    }

    public abstract String mnemonic();

    protected String formattedMnemonic() {
        return String.format("%-8s", this.mnemonic());
    }

    public abstract <R, T> R accept(RReilVisitor<R, T> var1, T var2);

    public boolean isBranch() {
        return false;
    }

    public boolean isAlwaysTakenBranch() {
        return false;
    }

    public boolean isDeadBranch() {
        return false;
    }

    public boolean isConditionalBranch() {
        return false;
    }

    public boolean isIndirectBranch() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RReil)) {
            return false;
        }
        RReil other = (RReil)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    public static String reconstructList(String type, List<? extends Reconstructable> list) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Reconstructable reconstructable : list) {
            if (!first) {
                builder.append($OperandSeparator);
            }
            first = false;
            builder.append(reconstructable.reconstructCode());
        }
        return "Arrays.asList(new " + type + "[] {" + builder.toString() + "})";
    }

    public static final class Flop
    extends RReil {
        private final FlopOp flop;
        private final Rhs.Rvar lhs;
        private final List<Rhs.Rvar> rhs;
        private final Rhs.Rvar flags;

        public Flop(RReilAddr address, FlopOp flop, Rhs.Rvar lhs, List<Rhs.Rvar> rhs, Rhs.Rvar flags) {
            super(address);
            this.flop = flop;
            this.lhs = lhs;
            this.rhs = rhs;
            this.flags = flags;
        }

        public FlopOp getOp() {
            return this.flop;
        }

        public Rhs.Rvar getLhs() {
            return this.lhs;
        }

        public List<Rhs.Rvar> getRhs() {
            return this.rhs;
        }

        public Rhs.Rvar getFlags() {
            return this.flags;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return this.flop.asPrefix();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            builder.append(this.lhs);
            builder.append(RReil.$OperandSeparator);
            builder.append("(");
            boolean first = true;
            for (Rhs.Rvar var : this.rhs) {
                if (!first) {
                    builder.append(RReil.$OperandSeparator);
                }
                first = false;
                builder.append(var);
            }
            builder.append("), [");
            builder.append(this.flags);
            builder.append("]");
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
            result = 31 * result + (this.flop == null ? 0 : this.flop.hashCode());
            result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Flop)) {
                return false;
            }
            Flop other = (Flop)obj;
            if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
                return false;
            }
            if (this.flop != other.flop) {
                return false;
            }
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Flop(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.flop.reconstructCode() + RReil.$OperandSeparator + this.lhs.reconstructCode() + RReil.$OperandSeparator + Flop.reconstructList("Rhs.Rvar", this.rhs) + RReil.$OperandSeparator + this.flags.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            throw new UnimplementedException();
        }
    }

    public static final class Throw
    extends RReil {
        private final String exception;

        public Throw(RReilAddr address, String exception) {
            super(address);
            this.exception = exception;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return "throw";
        }

        public String getException() {
            return this.exception;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            builder.append(this.exception);
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Throw)) {
                return false;
            }
            Throw other = (Throw)obj;
            return !(this.exception == null ? other.exception != null : !this.exception.equals(other.exception));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Throw(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.exception + ")";
        }

        @Override
        public String toAssemblerString() {
            throw new UnimplementedException();
        }
    }

    public static final class Native
    extends RReil {
        private final String name;
        private final Rhs.Rlit opnd;

        public Native(RReilAddr address, String name, Rhs.Rlit opnd) {
            super(address);
            this.name = name;
            this.opnd = opnd;
        }

        public String getName() {
            return this.name;
        }

        public Rhs.Rlit getOpnd() {
            return this.opnd;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return "native " + this.name;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            builder.append("(");
            builder.append(this.opnd);
            builder.append(")");
            builder.append(":");
            builder.append(this.opnd.getSize());
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.opnd == null ? 0 : this.opnd.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Native)) {
                return false;
            }
            Native other = (Native)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.opnd == null ? other.opnd != null : !this.opnd.equals(other.opnd));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Native(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.name + RReil.$OperandSeparator + this.opnd.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            throw new UnimplementedException();
        }
    }

    public static final class PrimOp
    extends RReil {
        private final String name;
        private final List<Lhs> outArgs;
        private final List<Rhs.Rval> inArgs;

        public PrimOp(String name, List<Lhs> outArgs, List<Rhs.Rval> inArgs) {
            this(null, name, outArgs, inArgs);
        }

        public PrimOp(RReilAddr address, String name, List<Lhs> outArgs, List<Rhs.Rval> inArgs) {
            super(address);
            this.name = name;
            this.outArgs = outArgs != null ? outArgs : Collections.emptyList();
            this.inArgs = inArgs != null ? inArgs : Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public List<Lhs> getOutArgs() {
            return this.outArgs;
        }

        public Lhs getOutArg(int number) {
            return this.outArgs.get(number);
        }

        public List<Rhs.Rval> getInArgs() {
            return this.inArgs;
        }

        public Rhs.Rval getInArg(int number) {
            return this.inArgs.get(number);
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public boolean is(String operationName, int outArgsNumber, int inArgsNumber) {
            if (!this.name.equals(operationName)) {
                return false;
            }
            if (outArgsNumber != Integer.MAX_VALUE && this.outArgs.size() != outArgsNumber) {
                return false;
            }
            return inArgsNumber == Integer.MAX_VALUE || this.inArgs.size() == inArgsNumber;
        }

        @Override
        public String mnemonic() {
            return this.name;
        }

        public String toString() {
            String sep;
            StringBuilder builder = new StringBuilder();
            if (!this.outArgs.isEmpty()) {
                if (this.outArgs.size() > 1) {
                    builder.append("<");
                }
                sep = "";
                for (Lhs lhs : this.outArgs) {
                    builder.append(sep);
                    builder.append(lhs);
                    sep = RReil.$OperandSeparator;
                }
                if (this.outArgs.size() > 1) {
                    builder.append(">");
                }
                builder.append(" = ");
            }
            builder.append(this.name);
            builder.append("(");
            sep = "";
            for (Rhs.Rval rhs : this.inArgs) {
                builder.append(sep);
                builder.append(rhs);
                sep = RReil.$OperandSeparator;
            }
            builder.append(")");
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.inArgs == null ? 0 : this.inArgs.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.outArgs == null ? 0 : this.outArgs.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof PrimOp)) {
                return false;
            }
            PrimOp other = (PrimOp)obj;
            if (this.inArgs == null ? other.inArgs != null : !this.inArgs.equals(other.inArgs)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.outArgs == null ? other.outArgs != null : !this.outArgs.equals(other.outArgs));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.PrimOp(" + this.getRReilAddress().reconstructCode() + ", \"" + this.name + "\", " + PrimOp.reconstructList("Lhs", this.outArgs) + RReil.$OperandSeparator + PrimOp.reconstructList("Rhs.Rval", this.inArgs) + ")";
        }

        @Override
        public String toAssemblerString() {
            return this.toString();
        }
    }

    public static final class Nop
    extends RReil {
        public Nop(RReilAddr address) {
            super(address);
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return "nop";
        }

        public String toString() {
            return this.mnemonic();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Nop)) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Nop(" + this.getRReilAddress().reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            builder.append("nop");
            return builder.toString();
        }
    }

    public static final class Branch
    extends RReil {
        private final Rhs.Lin target;
        private final BranchTypeHint hint;

        public Branch(RReilAddr rreilAddress, Rhs.Lin target, BranchTypeHint hint) {
            super(rreilAddress);
            this.target = target;
            this.hint = hint;
        }

        public Rhs.Lin getTarget() {
            return this.target;
        }

        public BranchTypeHint getBranchType() {
            return this.hint;
        }

        @Override
        public boolean isBranch() {
            return true;
        }

        @Override
        public boolean isIndirectBranch() {
            return !(this.target instanceof Rhs.LinRval) || !(((Rhs.LinRval)this.target).getRval() instanceof Rhs.Rlit);
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return this.hint.toString().toLowerCase();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            if (this.target instanceof Rhs.LinRval && ((Rhs.LinRval)this.target).getRval() instanceof Rhs.Rlit) {
                ((Rhs.Rlit)((Rhs.LinRval)this.target).getRval()).asHexPrefix(builder);
            } else {
                builder.append(this.target);
            }
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.hint == null ? 0 : this.hint.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Branch)) {
                return false;
            }
            Branch other = (Branch)obj;
            if (this.hint != other.hint) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Branch(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.target.reconstructCode() + RReil.$OperandSeparator + "BranchTypeHint." + (Object)((Object)this.hint) + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            int size = this.getTarget().getSize();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            builder.append("br");
            builder.append("." + size);
            builder.append(" ");
            builder.append(this.target.toAssemblerString());
            builder.append(" // ");
            builder.append((Object)this.hint);
            return builder.toString();
        }

        public static enum BranchTypeHint {
            Call,
            Jump,
            Return;

        }
    }

    public static final class BranchToRReil
    extends RReil {
        private final Rhs.SimpleExpression cond;
        private final Rhs.Address target;

        public BranchToRReil(RReilAddr rreilAddress, Rhs.SimpleExpression cond, Rhs.Address target) {
            super(rreilAddress);
            this.cond = cond;
            this.target = target;
        }

        public Rhs.SimpleExpression getCond() {
            return this.cond;
        }

        public Rhs.Address getTarget() {
            return this.target;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public boolean isAlwaysTakenBranch() {
            Rhs.Rval condRval;
            if (this.cond instanceof Rhs.LinRval && (condRval = ((Rhs.LinRval)this.cond).getRval()) instanceof Rhs.Rlit) {
                return !((Rhs.Rlit)condRval).getValue().isZero();
            }
            return false;
        }

        @Override
        public boolean isBranch() {
            return true;
        }

        @Override
        public boolean isConditionalBranch() {
            return !(this.cond instanceof Rhs.LinRval) || !(((Rhs.LinRval)this.cond).getRval() instanceof Rhs.Rlit);
        }

        @Override
        public String mnemonic() {
            if (this.isAlwaysTakenBranch()) {
                return "if TRUE";
            }
            if (this.isDeadBranch()) {
                return "if FALSE";
            }
            return "if";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            if (this.isConditionalBranch()) {
                builder.append(this.cond);
                builder.append(" ");
            }
            builder.append("goto rreil");
            builder.append(" ");
            builder.append(this.target);
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.cond == null ? 0 : this.cond.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof BranchToRReil)) {
                return false;
            }
            BranchToRReil other = (BranchToRReil)obj;
            if (this.cond == null ? other.cond != null : !this.cond.equals(other.cond)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.BranchToRReil(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.cond.reconstructCode() + RReil.$OperandSeparator + this.target.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            int size = this.getTarget().getSize();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            builder.append("brci");
            builder.append("." + size);
            builder.append(" ");
            builder.append(this.cond.toAssemblerString());
            builder.append(RReil.$OperandSeparator);
            builder.append(this.target.toAssemblerString());
            return builder.toString();
        }
    }

    public static final class BranchToNative
    extends RReil {
        private final Rhs.SimpleExpression cond;
        private final Rhs.Lin target;

        public BranchToNative(RReilAddr rreilAddress, Rhs.SimpleExpression cond, Rhs.Lin target) {
            super(rreilAddress);
            this.cond = cond;
            this.target = target;
        }

        public Rhs.SimpleExpression getCond() {
            return this.cond;
        }

        public Rhs.Lin getTarget() {
            return this.target;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public boolean isAlwaysTakenBranch() {
            Rhs.Rval condRval;
            if (this.cond instanceof Rhs.LinRval && (condRval = ((Rhs.LinRval)this.cond).getRval()) instanceof Rhs.Rlit) {
                return !((Rhs.Rlit)condRval).getValue().isZero();
            }
            return false;
        }

        @Override
        public boolean isDeadBranch() {
            Rhs.Rval condRval;
            if (this.cond instanceof Rhs.LinRval && (condRval = ((Rhs.LinRval)this.cond).getRval()) instanceof Rhs.Rlit) {
                return ((Rhs.Rlit)condRval).getValue().isZero();
            }
            return false;
        }

        @Override
        public boolean isBranch() {
            return true;
        }

        @Override
        public boolean isConditionalBranch() {
            return !(this.cond instanceof Rhs.LinRval) || !(((Rhs.LinRval)this.cond).getRval() instanceof Rhs.Rlit);
        }

        @Override
        public boolean isIndirectBranch() {
            return !(this.target instanceof Rhs.LinRval) || !(((Rhs.LinRval)this.target).getRval() instanceof Rhs.Rlit);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.cond == null ? 0 : this.cond.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof BranchToNative)) {
                return false;
            }
            BranchToNative other = (BranchToNative)obj;
            if (this.cond == null ? other.cond != null : !this.cond.equals(other.cond)) {
                return false;
            }
            return !(this.target == null ? other.target != null : !this.target.equals(other.target));
        }

        @Override
        public String mnemonic() {
            if (this.isAlwaysTakenBranch()) {
                return "if TRUE";
            }
            if (this.isDeadBranch()) {
                return "if FALSE";
            }
            return "if";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            if (this.isConditionalBranch()) {
                builder.append(this.cond);
                builder.append(" ");
            }
            builder.append("goto native");
            builder.append(" ");
            if (this.target instanceof Rhs.LinRval && ((Rhs.LinRval)this.target).getRval() instanceof Rhs.Rlit) {
                ((Rhs.Rlit)((Rhs.LinRval)this.target).getRval()).asHexPrefix(builder);
            } else {
                builder.append(this.target);
            }
            return builder.toString();
        }

        @Override
        public String reconstructCode() {
            return "new RReil.BranchToNative(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.cond.reconstructCode() + RReil.$OperandSeparator + this.target.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            int size = this.getTarget().getSize();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            builder.append("brc");
            builder.append("." + size);
            builder.append(" ");
            builder.append(this.cond.toAssemblerString());
            builder.append(RReil.$OperandSeparator);
            throw new RReilGrammarException();
        }
    }

    public static final class Store
    extends RReil {
        private final Rhs.Lin writeAddress;
        private final Rhs.Lin rhs;

        public Store(RReilAddr rreilAddress, Rhs.Lin address, Rhs.Lin rhs) {
            super(rreilAddress);
            this.writeAddress = address;
            this.rhs = rhs;
        }

        public int pointerSize() {
            return this.writeAddress.getSize();
        }

        public Rhs.Lin getWriteAddress() {
            return this.writeAddress;
        }

        public int rhsSize() {
            return this.rhs.getSize();
        }

        public Rhs.Lin getRhs() {
            return this.rhs;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return "store";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            builder.append('[');
            builder.append(this.writeAddress);
            builder.append(']');
            builder.append(RReil.$OperandSeparator);
            builder.append(this.rhs);
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            result = 31 * result + (this.writeAddress == null ? 0 : this.writeAddress.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Store)) {
                return false;
            }
            Store other = (Store)obj;
            if (this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs)) {
                return false;
            }
            return !(this.writeAddress == null ? other.writeAddress != null : !this.writeAddress.equals(other.writeAddress));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Store(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.writeAddress.reconstructCode() + RReil.$OperandSeparator + this.rhs.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            builder.append("store");
            builder.append("." + this.writeAddress.getSize());
            builder.append("." + this.rhs.getSize());
            builder.append(" ");
            builder.append(this.writeAddress.toAssemblerString());
            builder.append(RReil.$OperandSeparator);
            builder.append(this.rhs.toAssemblerString());
            return builder.toString();
        }
    }

    public static final class Load
    extends RReil {
        private final Rhs.Lin readAddress;
        private final Lhs lhs;

        public Load(RReilAddr rreilAddress, Rhs.Rvar lhs, Rhs.Lin rhs) {
            super(rreilAddress);
            this.lhs = new Lhs(lhs.getSize(), lhs.getOffset(), lhs.getRegionId());
            this.readAddress = rhs;
        }

        public Load(RReilAddr rreilAddress, Lhs lhs, Rhs.Lin address) {
            super(rreilAddress);
            this.readAddress = address;
            this.lhs = lhs;
        }

        public int pointerSize() {
            return this.readAddress.getSize();
        }

        public Rhs.Lin getReadAddress() {
            return this.readAddress;
        }

        public int lhsSize() {
            return this.lhs.getSize();
        }

        public Lhs getLhs() {
            return this.lhs;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            return "load";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            builder.append(this.lhs);
            builder.append(RReil.$OperandSeparator).append('[');
            builder.append(this.readAddress);
            builder.append(']');
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
            result = 31 * result + (this.readAddress == null ? 0 : this.readAddress.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Load)) {
                return false;
            }
            Load other = (Load)obj;
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.readAddress == null ? other.readAddress != null : !this.readAddress.equals(other.readAddress));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Load(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.lhs.reconstructCode() + RReil.$OperandSeparator + this.readAddress.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            builder.append("load");
            builder.append("." + this.lhs.getSize());
            builder.append("." + this.readAddress.getSize());
            builder.append(" ");
            builder.append(this.lhs.toAssemblerString());
            builder.append(RReil.$OperandSeparator);
            builder.append(this.readAddress.toAssemblerString());
            return builder.toString();
        }
    }

    public static final class Assign
    extends RReil {
        private final Lhs lhs;
        private final Rhs rhs;

        public Assign(RReilAddr rreilAddress, Rhs.Rvar lhs, Rhs rhs) {
            super(rreilAddress);
            this.lhs = new Lhs(lhs.getSize(), lhs.getOffset(), lhs.getRegionId());
            this.rhs = rhs;
        }

        public Assign(RReilAddr rreilAddress, Lhs lhs, Rhs rhs) {
            super(rreilAddress);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public int size() {
            return this.lhs.getSize();
        }

        public Lhs getLhs() {
            return this.lhs;
        }

        public Rhs getRhs() {
            return this.rhs;
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String mnemonic() {
            if (this.rhs instanceof Rhs.Rval || this.rhs instanceof Rhs.RangeRhs) {
                return "mov";
            }
            if (this.rhs instanceof Rhs.Bin) {
                return ((Rhs.Bin)this.rhs).mnemonic();
            }
            if (this.rhs instanceof Rhs.Lin) {
                return "mov";
            }
            if (this.rhs instanceof Rhs.Cmp) {
                return ((Rhs.Cmp)this.rhs).mnemonic();
            }
            if (this.rhs instanceof Rhs.SignExtend) {
                return ((Rhs.SignExtend)this.rhs).mnemonic();
            }
            if (this.rhs instanceof Rhs.Convert) {
                return ((Rhs.Convert)this.rhs).mnemonic();
            }
            throw new IllegalStateException();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.formattedMnemonic());
            builder.append(" ");
            if (this.rhs instanceof Rhs.Rval || this.rhs instanceof Rhs.RangeRhs) {
                builder.append(this.lhs);
                builder.append(RReil.$OperandSeparator);
                builder.append(this.rhs);
            } else if (this.rhs instanceof Rhs.Bin) {
                Rhs.Bin binexpr = (Rhs.Bin)this.rhs;
                Rhs.Rval par1 = binexpr.getLeft();
                Rhs.Rval par2 = binexpr.getRight();
                builder.append(this.lhs);
                builder.append(RReil.$OperandSeparator);
                builder.append(par1);
                builder.append(RReil.$OperandSeparator);
                builder.append(par2);
            } else if (this.rhs instanceof Rhs.Lin) {
                builder.append(this.lhs);
                builder.append(RReil.$OperandSeparator);
                builder.append(this.rhs.toString());
            } else if (this.rhs instanceof Rhs.Cmp) {
                Rhs.Cmp cmpexpr = (Rhs.Cmp)this.rhs;
                Rhs.Lin par1 = cmpexpr.getLeft();
                Rhs.Lin par2 = cmpexpr.getRight();
                builder.append(this.lhs);
                builder.append(RReil.$OperandSeparator);
                builder.append(par1);
                builder.append(RReil.$OperandSeparator);
                builder.append(par2);
            } else if (this.rhs instanceof Rhs.SignExtend) {
                Rhs.SignExtend signextendexpr = (Rhs.SignExtend)this.rhs;
                builder.append(this.lhs);
                builder.append(RReil.$OperandSeparator);
                builder.append(signextendexpr.getRhs());
            } else if (this.rhs instanceof Rhs.Convert) {
                Rhs.Convert convertexpr = (Rhs.Convert)this.rhs;
                builder.append(this.lhs);
                builder.append(RReil.$OperandSeparator);
                builder.append(convertexpr.getRhs());
            } else {
                throw new IllegalStateException();
            }
            return builder.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Assign)) {
                return false;
            }
            Assign other = (Assign)obj;
            if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                return false;
            }
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }

        @Override
        public String reconstructCode() {
            return "new RReil.Assign(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.lhs.reconstructCode() + RReil.$OperandSeparator + this.rhs.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getRReilAddress().toAssemblerString());
            builder.append(" ");
            if (this.rhs instanceof Rhs.Rval || this.rhs instanceof Rhs.RangeRhs) {
                builder.append("mov");
                builder.append("." + this.lhs.getSize());
                builder.append(" ");
                builder.append(this.lhs.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(this.rhs.toAssemblerString());
            } else if (this.rhs instanceof Rhs.Bin) {
                Rhs.Bin binexpr = (Rhs.Bin)this.rhs;
                Rhs.Rval par1 = binexpr.getLeft();
                Rhs.Rval par2 = binexpr.getRight();
                String operation = binexpr.mnemonic();
                builder.append(operation);
                builder.append("." + this.lhs.getSize());
                builder.append(" ");
                builder.append(this.lhs.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(par1.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(par2.toAssemblerString());
            } else if (this.rhs instanceof Rhs.Cmp) {
                Rhs.Cmp cmpexpr = (Rhs.Cmp)this.rhs;
                Rhs.Lin par1 = cmpexpr.getLeft();
                Rhs.Lin par2 = cmpexpr.getRight();
                String operation = cmpexpr.mnemonic();
                builder.append(operation);
                builder.append("." + par1.getSize());
                builder.append(" ");
                builder.append(this.lhs.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(par1.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(par2.toAssemblerString());
            } else if (this.rhs instanceof Rhs.SignExtend) {
                Rhs.SignExtend signextendexpr = (Rhs.SignExtend)this.rhs;
                String operation = signextendexpr.mnemonic();
                builder.append(operation);
                builder.append("." + this.lhs.getSize());
                builder.append("." + signextendexpr.getRhs().getSize());
                builder.append(" ");
                builder.append(this.lhs.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(signextendexpr.getRhs().toAssemblerString());
            } else if (this.rhs instanceof Rhs.Convert) {
                Rhs.Convert convertexpr = (Rhs.Convert)this.rhs;
                String operation = convertexpr.mnemonic();
                builder.append(operation);
                builder.append("." + this.lhs.getSize());
                builder.append("." + convertexpr.getRhs().getSize());
                builder.append(" ");
                builder.append(this.lhs.toAssemblerString());
                builder.append(RReil.$OperandSeparator);
                builder.append(convertexpr.getRhs().toAssemblerString());
            } else {
                throw new IllegalStateException();
            }
            return builder.toString();
        }
    }

    public static abstract class Assertion
    extends RReil {
        public Assertion(RReilAddr rreilAddress) {
            super(rreilAddress);
        }

        @Override
        public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String toAssemblerString() {
            throw new UnimplementedException();
        }

        @Override
        public String mnemonic() {
            return "assert";
        }

        public static final class AssertionWarnings
        extends Assertion {
            private final int numberOfExpectedWarnings;

            public AssertionWarnings(RReilAddr rreilAddress, int numberOfExpectedWarnings) {
                super(rreilAddress);
                this.numberOfExpectedWarnings = numberOfExpectedWarnings;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formattedMnemonic());
                builder.append(" ");
                builder.append("#warnings");
                builder.append(" = ");
                builder.append(this.numberOfExpectedWarnings);
                return builder.toString();
            }

            public int getNumberOfExpectedWarnings() {
                return this.numberOfExpectedWarnings;
            }

            @Override
            public int hashCode() {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + this.numberOfExpectedWarnings;
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (!(obj instanceof AssertionWarnings)) {
                    return false;
                }
                AssertionWarnings other = (AssertionWarnings)obj;
                return this.numberOfExpectedWarnings == other.numberOfExpectedWarnings;
            }

            @Override
            public String reconstructCode() {
                return "new RReil.AssertionWarnings(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.numberOfExpectedWarnings + ")";
            }
        }

        public static final class AssertionUnreachable
        extends Assertion {
            public AssertionUnreachable(RReilAddr rreilAddress) {
                super(rreilAddress);
            }

            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof AssertionUnreachable)) {
                    return false;
                }
                return super.equals(obj);
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formattedMnemonic());
                builder.append(" ");
                builder.append("<unreachable>");
                return builder.toString();
            }

            @Override
            public String reconstructCode() {
                return "new RReil.AssertionUnreachable(" + this.getRReilAddress().reconstructCode() + ")";
            }
        }

        public static final class AssertionReachable
        extends Assertion {
            public AssertionReachable(RReilAddr rreilAddress) {
                super(rreilAddress);
            }

            @Override
            public boolean equals(Object obj) {
                if (!(obj instanceof AssertionReachable)) {
                    return false;
                }
                return super.equals(obj);
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formattedMnemonic());
                builder.append(" ");
                builder.append("<reachable>");
                return builder.toString();
            }

            @Override
            public String reconstructCode() {
                return "new AssertionReachable(" + this.getRReilAddress().reconstructCode() + ")";
            }
        }

        public static final class AssertionCompare
        extends Assertion {
            private final Rhs lhs;
            private final AssertionOp operator;
            private final Rhs rhs;
            private final int size;

            public AssertionCompare(RReilAddr rreilAddress, Rhs lhs, AssertionOp operator, Rhs rhs, int size) {
                super(rreilAddress);
                this.lhs = lhs;
                this.operator = operator;
                this.rhs = rhs;
                this.size = size;
            }

            public Rhs getLhs() {
                return this.lhs;
            }

            public AssertionOp getOperator() {
                return this.operator;
            }

            public Rhs getRhs() {
                return this.rhs;
            }

            public int getSize() {
                return this.size;
            }

            @Override
            public <R, T> R accept(RReilVisitor<R, T> visitor, T data) {
                return visitor.visit(this, data);
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.formattedMnemonic());
                builder.append(" ");
                builder.append(this.lhs);
                builder.append(" ");
                builder.append(this.operator);
                builder.append(" ");
                builder.append(this.rhs);
                return builder.toString();
            }

            @Override
            public int hashCode() {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
                result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
                result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
                result = 31 * result + this.size;
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (!(obj instanceof AssertionCompare)) {
                    return false;
                }
                AssertionCompare other = (AssertionCompare)obj;
                if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
                    return false;
                }
                if (this.operator != other.operator) {
                    return false;
                }
                if (this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs)) {
                    return false;
                }
                return this.size == other.size;
            }

            @Override
            public String reconstructCode() {
                return "new RReil.AssertionValues(" + this.getRReilAddress().reconstructCode() + RReil.$OperandSeparator + this.lhs.reconstructCode() + RReil.$OperandSeparator + this.operator.reconstructCode() + RReil.$OperandSeparator + this.rhs.reconstructCode() + ")";
            }
        }
    }
}

