/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import java.util.Map;
import java.util.TreeMap;
import rreil.lang.Reconstructable;
import rreil.lang.util.StampGen;

public class MemVar
implements Comparable<MemVar>,
Reconstructable {
    private static StampGen stamps = new StampGen();
    private static Map<MemVar, String> names = new TreeMap<MemVar, String>();
    private static Map<String, MemVar> reverse = new TreeMap<String, MemVar>();
    public final int stamp = stamps.next();

    private MemVar() {
    }

    public static MemVar fresh() {
        return new MemVar();
    }

    public static MemVar fresh(String name) {
        MemVar var = new MemVar();
        var.setName(name);
        return var;
    }

    public static MemVar freshTemporary() {
        MemVar var = new MemVar();
        var.setName("_t" + var.stamp);
        return var;
    }

    public static MemVar getVarOrFresh(String name) {
        MemVar var = reverse.get(name);
        if (var == null) {
            var = new MemVar();
            var.setName(name);
        }
        return var;
    }

    public static MemVar getVarOrNull(String name) {
        return reverse.get(name);
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        names.put(this, name);
        reverse.put(name, this);
    }

    public String getName() {
        String name = names.get(this);
        if (name == null) {
            name = "m" + this.stamp;
            this.setName(name);
        }
        return name;
    }

    public int hashCode() {
        return this.stamp;
    }

    public boolean equals(Object other) {
        return this.stamp == ((MemVar)other).stamp;
    }

    @Override
    public int compareTo(MemVar other) {
        return Integer.signum(this.stamp - other.stamp);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String reconstructCode() {
        return "MemVar.getVarOrFresh(\"" + names.get(this) + "\")";
    }

    public static void reset() {
        stamps = new StampGen();
        names = new TreeMap<MemVar, String>();
        reverse = new TreeMap<String, MemVar>();
    }
}

