/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import rreil.lang.Reconstructable;
import rreil.lang.SignednessHint;

public enum ComparisonOp implements Reconstructable
{
    Cmpeq("cmpeq", "=="),
    Cmpneq("cmpneq", "!="),
    Cmples("cmples", "<="),
    Cmpleu("cmpleu", "<=u"),
    Cmplts("cmplts", "<"),
    Cmpltu("cmpltu", "<u");

    private final String asPrefix;
    private final String asInfix;

    private ComparisonOp(String asPrefix, String asInfix) {
        this.asPrefix = asPrefix;
        this.asInfix = asInfix;
    }

    public String asInfix() {
        return this.asInfix;
    }

    public String asPrefix() {
        return this.asPrefix;
    }

    public SignednessHint signedness() {
        switch (this) {
            case Cmples: 
            case Cmplts: {
                return SignednessHint.ForceSigned;
            }
            case Cmpleu: 
            case Cmpltu: {
                return SignednessHint.ForceUnsigned;
            }
        }
        return SignednessHint.DontCare;
    }

    @Override
    public String reconstructCode() {
        return "ComparisonOp." + this.toString();
    }
}

