/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.builder.statement;

import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.StatementCollection;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.builder.StatementCollectionBuilder;
import rreil.gdsl.builder.sexpr.SexprBuilder;
import rreil.gdsl.builder.statement.StatementBuilder;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;
import rreil.lang.util.RhsFactory;

public class WhileBuilder
extends StatementBuilder {
    private SexprBuilder cond;
    private StatementCollectionBuilder body;

    public WhileBuilder(BuildingStateManager manager, SexprBuilder cond, StatementCollectionBuilder body) {
        super(manager);
        this.cond = cond.size(1);
        this.body = body;
    }

    @Override
    public BuildResult<? extends RReil> build() {
        BuildResult<? extends Rhs.SimpleExpression> condR = this.cond.build();
        RReilAddr branchCondAddr = this.manager.nextAddress();
        RReilAddr branchBehindAddress = this.manager.nextAddress();
        RReilAddr bodyAddr = this.manager.stageAddress();
        RReil.BranchToRReil branchCondRReil = RReilFactory.instance.branch(branchCondAddr, condR.getResult(), RhsFactory.getInstance().rreilAddress(64, bodyAddr));
        BuildResult<StatementCollection> bodyR = this.body.build();
        RReil.BranchToRReil branchBackRReil = RReilFactory.instance.branch(this.manager.nextAddress(), RhsFactory.getInstance().trueLin(), RhsFactory.getInstance().rreilAddress(64, branchCondAddr));
        RReilAddr behindAddr = this.manager.stageAddress();
        RReil.BranchToRReil branchBehindRReil = RReilFactory.instance.branch(branchBehindAddress, RhsFactory.getInstance().trueLin(), RhsFactory.getInstance().rreilAddress(64, behindAddr));
        SortedMap<RReilAddr, RReil> stmts = BuildResult.emptyStatements();
        stmts.put(branchCondAddr, branchCondRReil);
        stmts.put(branchBehindAddress, branchBehindRReil);
        stmts.putAll(bodyR.getResult().getInstructions());
        stmts.put(branchBackRReil.getRReilAddress(), branchBackRReil);
        return WhileBuilder.result(branchBackRReil, stmts);
    }
}

