/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class LodsTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final OperandSize elementSize;

    public LodsTranslator(OperandSize elementSize) {
        this.elementSize = elementSize;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd si = registerTranslator.translateRegister("esi").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd ax = registerTranslator.translateRegister("eax").withSize(this.elementSize);
        LowLevelRReilOpnd idx = factory.immediate(si.size(), (Number)this.elementSize.getSizeInBytes());
        if (env.getDefaultArchitectureSize() == 64 && this.elementSize.getBits() == 32) {
            LowLevelRReilOpnd t1 = registerTranslator.temporaryRegister(env, this.elementSize);
            instructions.add(factory.LOAD(env.getNextReilAddress(), t1, si));
            X86Helpers.emitWritebackAndMaybeZeroExtend(env, ax, t1, instructions);
        } else {
            instructions.add(factory.LOAD(env.getNextReilAddress(), ax, si));
        }
        long base = env.getBaseAddress();
        long reilBase = env.getCurrentReilOffset();
        long doDecrement = 3L + reilBase;
        long done = 1L + doDecrement;
        instructions.addAll(Arrays.asList(factory.IFGOTORREIL(env.getNextReilAddress(), X86Helpers.DIRECTION_FLAG_OPERAND, base, doDecrement), factory.ADD(env.getNextReilAddress(), si, si, idx), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.SUB(env.getNextReilAddress(), si, si, idx), factory.NOP(env.getNextReilAddress())));
    }
}

