/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86FlagHelpers;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class CmpsTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private static final InsnEmitter subFlagEmitter = new X86FlagHelpers.SubFlagEmitter();
    private final OperandSize elementSize;

    public CmpsTranslator(OperandSize elementSize) {
        this.elementSize = elementSize;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd si = registerTranslator.translateRegister("esi").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd di = registerTranslator.translateRegister("edi").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd t1 = registerTranslator.temporaryRegister(env, this.elementSize);
        LowLevelRReilOpnd t2 = registerTranslator.temporaryRegister(env, this.elementSize);
        LowLevelRReilOpnd idx = factory.immediate(si.size(), (Number)this.elementSize.getSizeInBytes());
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, this.elementSize);
        instructions.addAll(Arrays.asList(factory.LOAD(env.getNextReilAddress(), t1, si), factory.LOAD(env.getNextReilAddress(), t2, di)));
        long base = env.getBaseAddress();
        long reilBase = env.getCurrentReilOffset();
        long doDecrement = 4L + reilBase;
        long doFlags = 2L + doDecrement;
        instructions.addAll(Arrays.asList(factory.IFGOTORREIL(env.getNextReilAddress(), X86Helpers.DIRECTION_FLAG_OPERAND, base, doDecrement), factory.ADD(env.getNextReilAddress(), si, si, idx), factory.ADD(env.getNextReilAddress(), di, di, idx), factory.GOTORREIL(env.getNextReilAddress(), base, doFlags), factory.SUB(env.getNextReilAddress(), si, si, idx), factory.SUB(env.getNextReilAddress(), di, di, idx), factory.SUB(env.getNextReilAddress(), tmp, t1, t2)));
        subFlagEmitter.emit(env, tmp, t1, t2, instructions);
    }
}

