/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.avr8.common;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.avr8.common.AVR8OperandTranslator;
import rreil.disassembler.translators.avr8.implementations.AvrImplementation;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public abstract class AVR8OperationTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final ReturnType returnType;
    private final boolean loadFromMemory;
    private final boolean ioAddresses;

    public AVR8OperationTranslator(ReturnType returnType) {
        this(returnType, true, false);
    }

    public AVR8OperationTranslator(ReturnType returnType, boolean loadFromMemory) {
        this(returnType, loadFromMemory, false);
    }

    public AVR8OperationTranslator(ReturnType returnType, boolean loadFromMemory, boolean ioAddresses) {
        this.returnType = returnType;
        this.loadFromMemory = loadFromMemory;
        this.ioAddresses = ioAddresses;
    }

    public abstract void emit(TranslationCtx var1, LowLevelRReilOpnd var2, LowLevelRReilOpnd var3, LowLevelRReilOpnd var4, List<LowLevelRReil> var5);

    @Override
    public void translate(TranslationCtx ctx, Instruction insn, List<LowLevelRReil> instructions) {
        int numerOfArguments = insn.operands().size();
        TranslationState[] opndStates = new TranslationState[numerOfArguments];
        for (int i = 0; i < opndStates.length; ++i) {
            opndStates[i] = AVR8OperandTranslator.translateOperand(ctx, insn.operand(i), this.loadFromMemory, this.ioAddresses);
        }
        LowLevelRReilOpnd[] LowLevelRReilOpnds = new LowLevelRReilOpnd[numerOfArguments];
        LowLevelRReilOpnd address = null;
        for (int i = 0; i < LowLevelRReilOpnds.length; ++i) {
            LowLevelRReilOpnds[i] = opndStates[i].getOperandStack().pop();
            if (opndStates[i].getOperandStack().isEmpty()) continue;
            address = opndStates[i].getOperandStack().pop();
        }
        LowLevelRReilOpnd dst = null;
        if (this.returnType != ReturnType.None) {
            dst = ctx.temporaryRegister(LowLevelRReilOpnds[0].size());
        }
        for (int i = 0; i < opndStates.length; ++i) {
            for (int j = 0; j < opndStates[i].getInstructionStack().size(); ++j) {
                instructions.add((LowLevelRReil)opndStates[i].getInstructionStack().get(j));
            }
            opndStates[i].getInstructionStack().clear();
        }
        this.emit(ctx, dst, numerOfArguments >= 1 ? LowLevelRReilOpnds[0] : null, numerOfArguments >= 2 ? LowLevelRReilOpnds[1] : null, instructions);
        switch (this.returnType) {
            case None: {
                break;
            }
            case Register: {
                instructions.add(factory.MOV(ctx.getNextReilAddress(), LowLevelRReilOpnds[0], dst));
                break;
            }
            case Memory: {
                LowLevelRReilOpnd t0 = ctx.temporaryRegister(OperandSize.WORD);
                instructions.add(factory.CONVERT(ctx.getNextReilAddress(), t0, address));
                if (this.ioAddresses) {
                    instructions.add(factory.ADD(ctx.getNextReilAddress(), t0, t0, factory.immediate(t0.size(), (Number)AvrImplementation.$ATMEGA32L.getIORegistersOffset())));
                }
                instructions.add(factory.STORE(ctx.getNextReilAddress(), t0, dst));
                break;
            }
        }
    }

    public static enum ReturnType {
        None,
        Register,
        Memory;

    }
}

