/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ElfBinaryArchive
extends BinaryFile
implements IBinaryParser.IBinaryArchive {
    private ArrayList<IBinaryParser.IBinaryObject> children;

    public ElfBinaryArchive(IBinaryParser parser, IPath p) throws IOException {
        super(parser, p, 8);
        new AR(p.toOSString()).dispose();
        this.children = new ArrayList(5);
    }

    @Override
    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            AR ar = null;
            try {
                ar = new AR(this.getPath().toOSString());
                AR.ARHeader[] headers = ar.getHeaders();
                IBinaryParser.IBinaryObject[] bobjs = this.createArchiveMembers(headers);
                this.children.addAll(Arrays.asList(bobjs));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ar != null) {
                ar.dispose();
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    protected IBinaryParser.IBinaryObject[] createArchiveMembers(AR.ARHeader[] headers) {
        IBinaryParser.IBinaryObject[] result = new IBinaryParser.IBinaryObject[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            result[i] = new ElfBinaryObject(this.getBinaryParser(), this.getPath(), headers[i]);
        }
        return result;
    }

    @Deprecated
    protected void addArchiveMembers(AR.ARHeader[] headers, ArrayList children) {
        IBinaryParser.IBinaryObject[] bobjs = this.createArchiveMembers(headers);
        children.addAll(Arrays.asList(bobjs));
    }
}

