/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections.tree;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import javalx.data.products.P2;
import javalx.numeric.FiniteRange;

public class OverlappingRanges<V>
implements Iterable<P2<FiniteRange, V>> {
    private static final Comparator<P2<FiniteRange, ?>> comparator = new Comparator<P2<FiniteRange, ?>>(){

        @Override
        public int compare(P2<FiniteRange, ?> a, P2<FiniteRange, ?> b) {
            return a._1().compareTo(b._1());
        }
    };
    private final LinkedList<P2<FiniteRange, V>> overlaps = new LinkedList();

    public void sortByFiniteRangeKey() {
        Collections.sort(this.overlaps, comparator);
    }

    void push(FiniteRange k, V v) {
        this.overlaps.push(new P2<FiniteRange, V>(k, v));
    }

    public String toString() {
        Iterator iterator = this.overlaps.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2 element = (P2)iterator.next();
            FiniteRange key = (FiniteRange)element._1();
            Object value = element._2();
            builder.append(key.toString());
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    public int size() {
        return this.overlaps.size();
    }

    public boolean isEmpty() {
        return this.overlaps.isEmpty();
    }

    public P2<FiniteRange, V> getFirst() {
        return this.overlaps.getFirst();
    }

    @Override
    public Iterator<P2<FiniteRange, V>> iterator() {
        return this.overlaps.iterator();
    }

    public void add(FiniteRange of, V v) {
        this.overlaps.add(new P2<FiniteRange, V>(of, v));
    }
}

