/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections.tree;

import com.jamesmurty.utils.XMLBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn2;
import javalx.numeric.Bound;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.ExtendedTree;
import javalx.persistentcollections.tree.OverlappingRanges;
import javalx.xml.XmlPrintable;

public abstract class FiniteRangeTree<V>
implements ExtendedTree<FiniteRange, V, FiniteRangeTree<V>>,
XmlPrintable {
    private static final int WEIGHT = 3;
    FiniteRange fst;
    V snd;
    private final int size;
    private final Bound max;
    final FiniteRangeTree<V> left;
    final FiniteRangeTree<V> right;

    private FiniteRangeTree(FiniteRange key, V value, int size, Bound maxBoundInSubtree, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        this.fst = key;
        this.snd = value;
        this.size = size;
        this.max = maxBoundInSubtree;
        this.left = left;
        this.right = right;
    }

    public OverlappingRanges<V> searchOverlaps(FiniteRange key) {
        return this.searchOverlaps(key.toInterval());
    }

    public OverlappingRanges<V> searchOverlaps(Interval key) {
        OverlappingRanges overlapping = new OverlappingRanges();
        this.searchOverlaps(key, overlapping);
        return overlapping;
    }

    private void searchOverlaps(Interval key, OverlappingRanges<V> overlapping) {
        if (!this.isEmpty()) {
            if (this.fst.overlaps(key)) {
                overlapping.push(this.fst, this.snd);
            }
            if (!this.left.isEmpty() && key.low().isLessThanOrEqualTo(this.left.max)) {
                super.searchOverlaps(key, overlapping);
            }
            if (!this.right.isEmpty() && key.low().isLessThanOrEqualTo(this.right.max)) {
                super.searchOverlaps(key, overlapping);
            }
        }
    }

    private static boolean lessThan(FiniteRange leftKey, FiniteRange rightKey) {
        return leftKey.compareTo(rightKey) < 0;
    }

    public static <V> FiniteRangeTree<V> empty() {
        return new Node();
    }

    @Override
    public final Option<V> get(FiniteRange key) {
        if (this.isEmpty()) {
            return Option.none();
        }
        if (FiniteRangeTree.lessThan(key, this.fst)) {
            return this.left.get(key);
        }
        if (FiniteRangeTree.lessThan(this.fst, key)) {
            return this.right.get(key);
        }
        return Option.some(this.snd);
    }

    @Override
    public final V getOrNull(FiniteRange key) {
        if (this.isEmpty()) {
            return null;
        }
        if (FiniteRangeTree.lessThan(key, this.fst)) {
            return this.left.getOrNull(key);
        }
        if (FiniteRangeTree.lessThan(this.fst, key)) {
            return this.right.getOrNull(key);
        }
        return this.snd;
    }

    @Override
    public final FiniteRangeTree<V> bind(FiniteRange key, V value) {
        if (this.isEmpty()) {
            return this.node(key, value, 1, this, this);
        }
        if (FiniteRangeTree.lessThan(key, this.fst)) {
            return FiniteRangeTree.balance(this.fst, this.snd, this.left.bind(key, value), this.right);
        }
        if (FiniteRangeTree.lessThan(this.fst, key)) {
            return FiniteRangeTree.balance(this.fst, this.snd, this.left, this.right.bind(key, value));
        }
        return this.node(key, value, this.size, this.left, this.right);
    }

    @Override
    public final FiniteRangeTree<V> remove(FiniteRange key) {
        if (this.isEmpty()) {
            return this;
        }
        if (FiniteRangeTree.lessThan(key, this.fst)) {
            return FiniteRangeTree.balance(this.fst, this.snd, this.left.remove(key), this.right);
        }
        if (FiniteRangeTree.lessThan(this.fst, key)) {
            return FiniteRangeTree.balance(this.fst, this.snd, this.left, this.right.remove(key));
        }
        return FiniteRangeTree.remove(this.left, this.right);
    }

    private static <V> FiniteRangeTree<V> remove(FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        FiniteRangeTree<V> min = super.min();
        return FiniteRangeTree.balance(min.fst, min.snd, left, right.removeMin());
    }

    @Override
    public FiniteRangeTree<V> removeMin() {
        if (this.left.isEmpty()) {
            return this.right;
        }
        return FiniteRangeTree.balance(this.fst, this.snd, this.left.removeMin(), this.right);
    }

    @Override
    public Option<P2<FiniteRange, V>> getMin() {
        if (this.isEmpty()) {
            return Option.none();
        }
        FiniteRangeTree<V> min = this.min();
        return Option.some(P2.tuple2(min.fst, min.snd));
    }

    private FiniteRangeTree<V> min() {
        if (this.left.isEmpty()) {
            return this;
        }
        return super.min();
    }

    @Override
    public FiniteRangeTree<V> removeMax() {
        if (this.right.isEmpty()) {
            return this.left;
        }
        return FiniteRangeTree.balance(this.fst, this.snd, this.left, this.right.removeMax());
    }

    @Override
    public Option<P2<FiniteRange, V>> getMax() {
        if (this.isEmpty()) {
            return Option.none();
        }
        FiniteRangeTree<V> maxNode = this.max();
        return Option.some(P2.tuple2(maxNode.fst, maxNode.snd));
    }

    private FiniteRangeTree<V> max() {
        if (this.right.isEmpty()) {
            return this;
        }
        return super.max();
    }

    private final FiniteRangeTree<V> node(FiniteRange key, V value, int size, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        return new Node<V>(key, value, size, left, right);
    }

    @Override
    public final int size() {
        return this.size;
    }

    private static <V> FiniteRangeTree<V> join(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        return new Node<V>(key, value, left.size + right.size + 1, left, right);
    }

    private static <V> FiniteRangeTree<V> balance(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        if (Math.abs(left.size - right.size) > 1) {
            if (right.size >= 3 * left.size) {
                if (right.left.size < right.right.size) {
                    return FiniteRangeTree.rotateSingleLeft(key, value, left, right);
                }
                return FiniteRangeTree.rotateDoubleLeft(key, value, left, right);
            }
            if (left.size >= 3 * right.size) {
                if (left.right.size < left.left.size) {
                    return FiniteRangeTree.rotateSingleRight(key, value, left, right);
                }
                return FiniteRangeTree.rotateDoubleRight(key, value, left, right);
            }
            return new Node<V>(key, value, left.size + right.size + 1, left, right);
        }
        return new Node<V>(key, value, left.size + right.size + 1, left, right);
    }

    private static <V> FiniteRangeTree<V> rotateDoubleLeft(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        return FiniteRangeTree.join(right.left.fst, right.left.snd, FiniteRangeTree.join(key, value, left, right.left.left), FiniteRangeTree.join(right.fst, right.snd, right.left.right, right.right));
    }

    private static <V> FiniteRangeTree<V> rotateDoubleRight(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        return FiniteRangeTree.join(left.right.fst, left.right.snd, FiniteRangeTree.join(left.fst, left.snd, left.left, left.right.left), FiniteRangeTree.join(key, value, left.right.right, right));
    }

    private static <V> FiniteRangeTree<V> rotateSingleLeft(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        return FiniteRangeTree.join(right.fst, right.snd, FiniteRangeTree.join(key, value, left, right.left), right.right);
    }

    private static <V> FiniteRangeTree<V> rotateSingleRight(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        return FiniteRangeTree.join(left.fst, left.snd, left.left, FiniteRangeTree.join(key, value, left.right, right));
    }

    @Override
    public final FiniteRangeTree<V> union(FiniteRangeTree<V> other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        FiniteRangeTree<V> lowerSubTree = other.splitTail(this.fst);
        FiniteRangeTree<V> upperSubTree = other.splitHead(this.fst);
        return FiniteRangeTree.concat3(this.fst, this.snd, this.left.union(lowerSubTree), this.right.union(upperSubTree));
    }

    @Override
    public final FiniteRangeTree<V> union(Fn2<V, V, V> selector, FiniteRangeTree<V> other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        FiniteRangeTree<V> lowerSubTree = other.splitTail(this.fst);
        FiniteRangeTree<V> upperSubTree = other.splitHead(this.fst);
        Option<V> valueInOther = other.get(this.fst);
        if (valueInOther.isSome()) {
            V v = selector.apply(this.snd, valueInOther.get());
            return FiniteRangeTree.concat3(this.fst, v, this.left.union(selector, lowerSubTree), this.right.union(selector, upperSubTree));
        }
        return FiniteRangeTree.concat3(this.fst, this.snd, this.left.union(selector, lowerSubTree), this.right.union(selector, upperSubTree));
    }

    @Override
    public final FiniteRangeTree<V> intersection(FiniteRangeTree<V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        FiniteRangeTree<V> lowerSubTree = this.splitTail(other.fst);
        FiniteRangeTree<V> upperSubTree = this.splitHead(other.fst);
        Option<V> valueInThis = this.get(other.fst);
        if (valueInThis.isSome()) {
            return FiniteRangeTree.concat3(other.fst, valueInThis.get(), lowerSubTree.intersection(other.left), upperSubTree.intersection(other.right));
        }
        return FiniteRangeTree.concat(lowerSubTree.intersection(other.left), upperSubTree.intersection(other.right));
    }

    @Override
    public final FiniteRangeTree<V> intersection(Fn2<V, V, V> selector, FiniteRangeTree<V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        FiniteRangeTree<V> lowerSubTree = this.splitTail(other.fst);
        FiniteRangeTree<V> upperSubTree = this.splitHead(other.fst);
        Option<V> valueInThis = this.get(other.fst);
        if (valueInThis.isSome()) {
            V v = selector.apply(valueInThis.get(), other.snd);
            return FiniteRangeTree.concat3(other.fst, v, lowerSubTree.intersection(selector, other.left), upperSubTree.intersection(selector, other.right));
        }
        return FiniteRangeTree.concat(lowerSubTree.intersection(selector, other.left), upperSubTree.intersection(selector, other.right));
    }

    @Override
    public final FiniteRangeTree<V> difference(FiniteRangeTree<V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        FiniteRangeTree<V> lowerSubTree = this.splitTail(other.fst);
        FiniteRangeTree<V> upperSubTree = this.splitHead(other.fst);
        return FiniteRangeTree.concat(lowerSubTree.difference(other.left), upperSubTree.difference(other.right));
    }

    private static <V> FiniteRangeTree<V> concat3(FiniteRange key, V value, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        if (left.isEmpty()) {
            return right.bind(key, value);
        }
        if (right.isEmpty()) {
            return left.bind(key, value);
        }
        if (3 * left.size < right.size) {
            return FiniteRangeTree.balance(right.fst, right.snd, FiniteRangeTree.concat3(key, value, left, right.left), right.right);
        }
        if (3 * right.size < left.size) {
            return FiniteRangeTree.balance(left.fst, left.snd, left.left, FiniteRangeTree.concat3(key, value, left.right, right));
        }
        return FiniteRangeTree.join(key, value, left, right);
    }

    private static <V> FiniteRangeTree<V> concat(FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        if (3 * left.size < right.size) {
            return FiniteRangeTree.balance(right.fst, right.snd, FiniteRangeTree.concat(left, right.left), right.right);
        }
        if (3 * right.size < left.size) {
            return FiniteRangeTree.balance(left.fst, left.snd, left.left, FiniteRangeTree.concat(left.right, right));
        }
        FiniteRangeTree<V> min = super.min();
        return FiniteRangeTree.balance(min.fst, min.snd, left, right.removeMin());
    }

    @Override
    public final FiniteRangeTree<V> splitHead(FiniteRange key) {
        if (this.isEmpty()) {
            return this;
        }
        if (FiniteRangeTree.lessThan(this.fst, key)) {
            return this.right.splitHead(key);
        }
        if (FiniteRangeTree.lessThan(key, this.fst)) {
            return FiniteRangeTree.concat3(this.fst, this.snd, this.left.splitHead(key), this.right);
        }
        return this.right;
    }

    @Override
    public final FiniteRangeTree<V> splitTail(FiniteRange key) {
        if (this.isEmpty()) {
            return this;
        }
        if (FiniteRangeTree.lessThan(key, this.fst)) {
            return this.left.splitTail(key);
        }
        if (FiniteRangeTree.lessThan(this.fst, key)) {
            return FiniteRangeTree.concat3(this.fst, this.snd, this.left, this.right.splitTail(key));
        }
        return this.left;
    }

    private final FiniteRangeTree<V> greedyIntersection(FiniteRangeTree<V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        FiniteRangeTree<V> lowerSubTree = this.splitTail(other.fst);
        FiniteRangeTree<V> upperSubTree = this.splitHead(other.fst);
        Option<V> valueInThis = this.get(other.fst);
        if (valueInThis.isSome()) {
            V actualValueInOther;
            V actualValueInThis = valueInThis.get();
            if (actualValueInThis == (actualValueInOther = other.snd) || actualValueInThis.equals(actualValueInOther)) {
                return FiniteRangeTree.concat(super.greedyIntersection(other.left), super.greedyIntersection(other.right));
            }
            return FiniteRangeTree.concat3(other.fst, valueInThis.get(), super.greedyIntersection(other.left), super.greedyIntersection(other.right));
        }
        return FiniteRangeTree.concat(super.greedyIntersection(other.left), super.greedyIntersection(other.right));
    }

    @Override
    public final ThreeWaySplit<FiniteRangeTree<V>> split(FiniteRangeTree<V> other) {
        FiniteRangeTree<V> inBoth = this.intersection(other);
        FiniteRangeTree<V> inBothWithNonEqualKeys = this.greedyIntersection(other);
        FiniteRangeTree<V> onlyInLeft = this.difference(inBoth);
        FiniteRangeTree<V> onlyInRight = other.difference(inBoth);
        return ThreeWaySplit.make(onlyInLeft, inBothWithNonEqualKeys, onlyInRight);
    }

    public String toString() {
        Iterator<P2<FiniteRange, V>> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<FiniteRange, V> element = iterator.next();
            FiniteRange key = element._1();
            V value = element._2();
            builder.append(key.toString());
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public final Iterator<P2<FiniteRange, V>> iterator() {
        return new FiniteRangeTreeIterator(this);
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        XMLBuilder xml = builder.e("FiniteRangeTree");
        for (P2<FiniteRange, V> binding : this) {
            xml = xml.e("Binding").e("Key").t(binding._1().toString()).up();
            xml = xml.e("Value").t(binding._2().toString()).up().up();
        }
        return xml.up();
    }

    @Override
    public boolean isEmpty() {
        return this.left == null && this.right == null;
    }

    public boolean hasOverlaps(FiniteRange rangeInBytes) {
        OverlappingRanges<V> overlappingSegments = this.searchOverlaps(rangeInBytes.toInterval());
        return !overlappingSegments.isEmpty();
    }

    static Bound max(FiniteRange key, FiniteRangeTree<?> left, FiniteRangeTree<?> right) {
        Bound maxInSubtree = key.high();
        if (!left.isEmpty()) {
            maxInSubtree = left.max.max(maxInSubtree);
        }
        if (!right.isEmpty()) {
            maxInSubtree = right.max.max(maxInSubtree);
        }
        return maxInSubtree;
    }

    static void renderAsGml(FiniteRangeTree<?> tree, String filePath) {
        new TreeWriter().renderAsGml(tree, filePath);
    }

    private static final class TreeWriter {
        private TreeWriter() {
        }

        private void renderAsGml(FiniteRangeTree<?> tree, String filePath) {
            try {
                PrintWriter out = new PrintWriter(new File(filePath));
                this.renderAsGml(tree, out);
                out.close();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FiniteRangeTree.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private void renderAsGml(FiniteRangeTree<?> tree, PrintWriter out) {
            out.println("graph [");
            out.println(" directed 1");
            this.renderNodes(tree, out);
            out.println("]");
        }

        private void renderNodes(FiniteRangeTree<?> n, PrintWriter out) {
            if (!n.isEmpty()) {
                TreeWriter.renderNode(n, out);
                this.renderNodes(n.left, out);
                this.renderNodes(n.right, out);
                TreeWriter.renderEdge(n, n.left, out);
                TreeWriter.renderEdge(n, n.right, out);
            }
        }

        private static void renderNode(FiniteRangeTree<?> n, PrintWriter out) {
            out.println(" node [");
            out.println("  id " + n.hashCode());
            out.println("  label \"" + n.toString() + "\"");
            out.println("  graphics [");
            out.println("   type \"roundrectangle\"");
            out.println("   fill \"#C0C0C0\"");
            out.println("   outline \"#000000\"");
            out.println("  ]");
            out.println(" ]");
        }

        private static void renderEdge(FiniteRangeTree<?> u, FiniteRangeTree<?> v, PrintWriter out) {
            if (v.isEmpty()) {
                return;
            }
            out.println(" edge [");
            out.println("  source " + u.hashCode());
            out.println("  target " + v.hashCode());
            out.println("  graphics [");
            out.println("   fill \"#000000\"");
            out.println("   targetArrow \"standard\"");
            out.println("  ]");
            out.println(" ]");
        }
    }

    private static final class Node<V>
    extends FiniteRangeTree<V> {
        Node(FiniteRange key, V value, int size, FiniteRangeTree<V> left, FiniteRangeTree<V> right) {
            super(key, value, size, FiniteRangeTree.max(key, left, right), left, right);
        }

        private Node() {
            super(null, null, 0, null, null, null);
        }
    }

    private static final class FiniteRangeTreeIterator<V>
    implements Iterator<P2<FiniteRange, V>> {
        FiniteRangeTree<V> tree;

        private FiniteRangeTreeIterator(FiniteRangeTree<V> tree) {
            this.tree = tree;
        }

        @Override
        public boolean hasNext() {
            return !this.tree.isEmpty();
        }

        @Override
        public P2<FiniteRange, V> next() {
            FiniteRangeTree min = ((FiniteRangeTree)this.tree).min();
            this.tree = this.tree.removeMin();
            return P2.tuple2(min.fst, min.snd);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

