/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections;

import java.util.Iterator;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn;
import javalx.fn.Fn2;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.IterableWrapper;
import javalx.persistentcollections.OrderedMap;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.AVLTree;

public class AVLMap<K, V>
implements OrderedMap<K, V, AVLMap<K, V>> {
    private final AVLTree<K, V> tree;
    private final Fn<AVLTree<K, V>, AVLMap<K, V>> buildMapFromTree = new Fn<AVLTree<K, V>, AVLMap<K, V>>(){

        @Override
        public AVLMap<K, V> apply(AVLTree<K, V> tree) {
            return AVLMap.this.build(tree);
        }
    };

    protected AVLMap(AVLTree<K, V> tree) {
        this.tree = tree;
    }

    private AVLMap<K, V> build(AVLTree<K, V> tree) {
        return new AVLMap<K, V>(tree);
    }

    public static <K, V> AVLMap<K, V> empty() {
        return new AVLMap(AVLTree.empty());
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean contains(K key) {
        return this.tree.get(key).isSome();
    }

    @Override
    public Option<V> get(K key) {
        return this.tree.get(key);
    }

    public V getOrNull(K key) {
        return this.tree.getOrNull(key);
    }

    @Override
    public AVLMap<K, V> bind(K key, V value) {
        return this.build((AVLTree<K, V>)this.tree.bind((Object)key, (Object)value));
    }

    @Override
    public AVLMap<K, V> remove(K key) {
        return this.build((AVLTree<K, V>)this.tree.remove((Object)key));
    }

    @Override
    public AVLMap<K, V> removeMin() {
        return this.build((AVLTree<K, V>)this.tree.removeMin());
    }

    @Override
    public AVLMap<K, V> removeMax() {
        return this.build((AVLTree<K, V>)this.tree.removeMax());
    }

    @Override
    public Option<P2<K, V>> getMin() {
        return this.tree.getMin();
    }

    @Override
    public Option<P2<K, V>> getMax() {
        return this.tree.getMax();
    }

    @Override
    public AVLMap<K, V> union(AVLMap<K, V> other) {
        return this.build(this.tree.union(other.tree));
    }

    @Override
    public AVLMap<K, V> union(Fn2<V, V, V> selector, AVLMap<K, V> other) {
        return this.build(this.tree.union(selector, other.tree));
    }

    @Override
    public AVLMap<K, V> difference(AVLMap<K, V> right) {
        return this.build(this.tree.difference(right.tree));
    }

    @Override
    public AVLMap<K, V> intersection(AVLMap<K, V> right) {
        return this.build(this.tree.intersection(right.tree));
    }

    @Override
    public AVLMap<K, V> intersection(Fn2<V, V, V> selector, AVLMap<K, V> other) {
        return this.build(this.tree.intersection(selector, other.tree));
    }

    @Override
    public Iterator<P2<K, V>> iterator() {
        return this.tree.iterator();
    }

    @Override
    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                return IterableWrapper.getKeysIterator(AVLMap.this);
            }
        };
    }

    @Override
    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return IterableWrapper.getValuesIterator(AVLMap.this);
            }
        };
    }

    public AVLSet<V> valueSet() {
        return AVLSet.fromIterable(this.values());
    }

    @Override
    public ThreeWaySplit<AVLMap<K, V>> split(AVLMap<K, V> other) {
        return ThreeWaySplit.map(this.tree.split(other.tree), this.buildMapFromTree);
    }

    public <R> AVLMap<R, V> mapOnKeys(Fn<K, R> fn) {
        return new AVLMap<R, V>(this.tree.mapOnKeys(fn));
    }

    public <R> AVLMap<K, R> mapOnValues(Fn<V, R> fn) {
        return new AVLMap<K, R>(this.tree.mapOnValues(fn));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator<P2<K, V>> iterator = this.iterator();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<K, V> element = iterator.next();
            K key = element._1();
            V value = element._2();
            builder.append((Object)(key == this ? "(this Map)" : key));
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public String toString(Fn<K, String> keyRenderer) {
        Iterator<P2<K, V>> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<K, V> element = iterator.next();
            K key = element._1();
            V value = element._2();
            builder.append(key == this ? "(this Map)" : keyRenderer.apply(key));
            builder.append('=');
            builder.append((Object)(value == this ? "(this Map)" : value));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AVLTree)) {
            return false;
        }
        AVLMap other = (AVLMap)obj;
        ThreeWaySplit<AVLMap<K, V>> split = this.split(other);
        return split.inBothButDiffering().isEmpty() && split.onlyInFirst().isEmpty() && split.onlyInSecond().isEmpty();
    }
}

