/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import java.util.NoSuchElementException;
import javalx.numeric.BigInt;
import javalx.numeric.NegInf;
import javalx.numeric.PosInf;

public abstract class Bound
implements Comparable<Bound> {
    public static final Bound NEGINF = new NegInf();
    public static final Bound POSINF = new PosInf();
    public static final BigInt MINUSONE = BigInt.of(-1L);
    public static final BigInt ZERO = BigInt.of(0L);
    public static final BigInt ONE = BigInt.of(1L);
    public static final BigInt TWO = BigInt.of(2L);
    public static final BigInt EIGHT = BigInt.of(8L);

    public BigInt asInteger() {
        throw new NoSuchElementException("Unbounded values cannot be casted to integers");
    }

    public final boolean isFinite() {
        return this instanceof BigInt;
    }

    public abstract Bound max(Bound var1);

    public abstract Bound max(BigInt var1);

    public abstract Bound min(Bound var1);

    public abstract Bound min(BigInt var1);

    public abstract Bound add(Bound var1);

    public abstract Bound add(BigInt var1);

    public Bound sub(Bound other) {
        return this.add(other.negate());
    }

    public abstract Bound mul(Bound var1);

    public abstract Bound divRoundUp(BigInt var1);

    public abstract Bound divRoundDown(Bound var1);

    public abstract Bound divRoundZero(Bound var1);

    public abstract Bound divRoundNearest(Bound var1);

    public abstract Bound divRoundNone(Bound var1);

    public abstract Bound shl(Bound var1);

    public abstract Bound negate();

    public abstract int sign();

    public final boolean isNegative() {
        return this.sign() < 0;
    }

    public final boolean isZero() {
        return this.sign() == 0;
    }

    public final boolean isPositive() {
        return this.sign() > 0;
    }

    @Override
    public abstract int compareTo(Bound var1);

    @Override
    public abstract int compareTo(BigInt var1);

    public final boolean isEqualTo(Bound other) {
        return this.compareTo(other) == 0;
    }

    public final boolean isLessThan(Bound other) {
        return this.compareTo(other) < 0;
    }

    public final boolean isLessThanOrEqualTo(Bound other) {
        return this.compareTo(other) <= 0;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Bound && this.isEqualTo((Bound)obj);
    }

    public abstract int hashCode();
}

