/*
 * Decompiled with CFR 0.152.
 */
package gdsl.decoder;

import gdsl.Gdsl;
import gdsl.HeapExpiredException;
import gdsl.asm.GeneralizerBackend;
import gdsl.asm.Instruction;
import gdsl.decoder.OperandType;
import gdsl.decoder.OperandTypeVisitor;

public class NativeInstruction {
    private long insnPtr = 0L;
    private Gdsl gdsl;
    private long heapRevision;

    public long getInsnPtr() {
        if (this.heapRevision != this.gdsl.getHeapRevision()) {
            throw new HeapExpiredException();
        }
        if (this.insnPtr == 0L) {
            throw new NullPointerException();
        }
        return this.insnPtr;
    }

    @Deprecated
    public long getSize() {
        return this.generalize().getLength();
    }

    public Gdsl getGdsl() {
        return this.gdsl;
    }

    public NativeInstruction(Gdsl gdsl, long l) {
        this.gdsl = gdsl;
        this.heapRevision = gdsl.getHeapRevision();
        gdsl.heapManager.ref();
        this.insnPtr = l;
    }

    public String toString() {
        return this.pretty(this.gdsl.getFrontendPtr(), this.gdsl.getGdslStatePtr(), this.getInsnPtr());
    }

    private native String pretty(long var1, long var3, long var5);

    @Deprecated
    public int operands() {
        return this.generalize().getOperands().length;
    }

    @Deprecated
    public String operandToString(int n) {
        return this.generalize().getOperands()[n].toString();
    }

    @Deprecated
    public OperandType operandType(int n) {
        OperandTypeVisitor operandTypeVisitor = new OperandTypeVisitor();
        this.generalize().accept(operandTypeVisitor);
        if (!operandTypeVisitor.getVisited()) {
            throw new RuntimeException("Unable to determine the operand type");
        }
        return operandTypeVisitor.getOperandType();
    }

    @Deprecated
    public String mnemonic() {
        return this.generalize().getMnemonic();
    }

    protected void finalize() throws Throwable {
        this.gdsl.heapManager.unref();
        super.finalize();
    }

    public Instruction generalize() {
        return new GeneralizerBackend().generalize(this.gdsl.getFrontendPtr(), this.gdsl.getGdslStatePtr(), this.getInsnPtr());
    }
}

