/*
 * Decompiled with CFR 0.152.
 */
package gdsl;

import gdsl.Frontend;
import gdsl.HeapUseIndicator;
import gdsl.IReferable;
import gdsl.ListFrontend;
import gdsl.ReferenceManager;
import gdsl.ResourceUnavailableException;
import java.nio.ByteBuffer;

public class Gdsl
implements IReferable {
    private Frontend frontend;
    private long gdslStatePtr = 0L;
    private ByteBuffer buffer;
    private long heapRevision = 0L;
    public final ReferenceManager heapManager = new ReferenceManager(this);

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public long getHeapRevision() {
        return this.heapRevision;
    }

    public long getGdslStatePtr() {
        if (this.gdslStatePtr == 0L) {
            throw new ResourceUnavailableException("Gdsl Frontend not initialized");
        }
        return this.gdslStatePtr;
    }

    public Frontend getFrontend() {
        if (this.frontend == null) {
            throw new RuntimeException("Frontend not set");
        }
        return this.frontend;
    }

    public long getFrontendPtr() {
        return this.getFrontend().getPointer();
    }

    public static Frontend[] getFrontends() {
        return Gdsl.getFrontendsNative();
    }

    public static Frontend[] getFrontends(String string) {
        return Gdsl.getFrontendsNativeWithBase(string);
    }

    private static native ListFrontend[] getFrontendsNative();

    private static native ListFrontend[] getFrontendsNativeWithBase(String var0);

    public Gdsl(Frontend frontend) {
        this.frontend = frontend;
        this.frontend.referenceManager.ref();
        this.gdslStatePtr = this.init(this.getFrontendPtr());
    }

    public void setCode(ByteBuffer byteBuffer, long l, long l2) {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (!byteBuffer.isDirect()) {
            throw new RuntimeException("Buffer must be direct");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.buffer = byteBuffer;
        this.setCode(this.getFrontendPtr(), this.getGdslStatePtr(), byteBuffer, l, l2);
    }

    public long decodeOne() {
        if (this.frontend.isConfigured()) {
            return this.decodeOneWithConfig(this.getFrontendPtr(), this.getGdslStatePtr(), this.frontend.getConfig().vector());
        }
        return this.decodeOne(this.getFrontendPtr(), this.getGdslStatePtr());
    }

    private native long decodeOne(long var1, long var3);

    private native long decodeOneWithConfig(long var1, long var3, long var5);

    public long getIpOffset() {
        return this.getIpOffset(this.getFrontend().getPointer(), this.getGdslStatePtr());
    }

    public void resetHeap() {
        this.resetHeap(this.getFrontend().getPointer(), this.getGdslStatePtr());
        ++this.heapRevision;
    }

    protected void finalize() throws Throwable {
        this.destroy(this.getFrontend().getPointer(), this.getGdslStatePtr());
        this.getFrontend().referenceManager.unref();
        this.gdslStatePtr = 0L;
        super.finalize();
    }

    @Override
    public void free() {
        if (this.gdslStatePtr != 0L) {
            this.resetHeap();
        }
    }

    public HeapUseIndicator heapUseIndicator() {
        return new HeapUseIndicator(this);
    }

    private native long init(long var1);

    private native void setCode(long var1, long var3, ByteBuffer var5, long var6, long var8);

    private native long getIpOffset(long var1, long var3);

    private native void resetHeap(long var1, long var3);

    private native void destroy(long var1, long var3);

    static {
        System.loadLibrary("jgdsl");
    }
}

