/*
 * Decompiled with CFR 0.152.
 */
package gdsl;

import gdsl.IFrontendConfig;
import gdsl.IReferable;
import gdsl.ReferenceManager;
import gdsl.ResourceUnavailableException;

public abstract class Frontend
implements IReferable {
    private long pointer;
    public final ReferenceManager referenceManager = new ReferenceManager(this, 1L);
    private IFrontendConfig config;
    private boolean configured = false;
    private final String name;

    public long getPointer() {
        if (this.pointer == 0L) {
            throw new ResourceUnavailableException("Pointer to native frontend object missing");
        }
        if (this.pointer < 0L) {
            throw new ResourceUnavailableException("Frontend destroyed");
        }
        return this.pointer;
    }

    protected void setPointer(long l) {
        if (l == 0L) {
            throw new RuntimeException("Invalid pointer");
        }
        this.pointer = l;
    }

    public IFrontendConfig getConfig() {
        if (!this.configured) {
            throw new UnsupportedOperationException();
        }
        return this.config;
    }

    public void setConfig(IFrontendConfig iFrontendConfig) {
        this.config = iFrontendConfig;
        this.configured = true;
    }

    public String getName() {
        return this.name;
    }

    protected Frontend(String string) {
        this.name = string;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    protected void finalize() throws Throwable {
        this.referenceManager.unref();
        super.finalize();
    }

    @Override
    public void free() {
        if (this.pointer != 0L) {
            this.destroy(this.getPointer());
            this.pointer = -1L;
        }
    }

    private native void destroy(long var1);

    static {
        System.loadLibrary("jgdsl");
    }
}

