/*
 * Decompiled with CFR 0.152.
 */
package binparse.trace;

import binparse.Binary;
import binparse.Segment;
import binparse.UncheckedIOException;
import binparse.trace.TraceParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javalx.data.products.P3;
import javalx.numeric.BigInt;

public class TraceDump {
    private final String traceDumpPrefix;
    private static final String traceSuffixInfo = ".info";
    private static final String traceSuffixSegments = ".segments";
    private static final String traceSuffixRegisters = ".registers";
    private static final String traceSuffixStack = ".stack";
    private static final String traceSuffixHeap = ".heap";
    private static final String traceSuffixFlow = ".flow";
    private static final String traceSuffixDebug = ".debug";
    private final Binary tracedBinary;

    public TraceDump(String tracesPrefix, Binary tracedBinary) {
        this.traceDumpPrefix = tracesPrefix;
        this.tracedBinary = tracedBinary;
    }

    public Binary getTracedBinary() {
        return this.tracedBinary;
    }

    public long getTraceStartAddress() {
        return TraceParser.parseInfo(this.traceDumpPrefix + traceSuffixInfo).getStartAddress();
    }

    public long getTraceEndAddress() {
        return TraceParser.parseInfo(this.traceDumpPrefix + traceSuffixInfo).getStopAddress();
    }

    public List<Segment> getSegments() {
        List<Segment> segments = TraceParser.parseModule(this.traceDumpPrefix + traceSuffixSegments);
        TraceDump.removeUnwantedSegmentsHack(segments);
        if (segments == null) {
            segments = new ArrayList<Segment>();
        }
        return segments;
    }

    private static void removeUnwantedSegmentsHack(List<Segment> segments) {
        Iterator<Segment> iterator = segments.iterator();
        while (iterator.hasNext()) {
            Segment segment = iterator.next();
            if (!segment.getNameOrAddress().equals(".tbss") && !segment.getNameOrAddress().equals(".tdata")) continue;
            iterator.remove();
        }
    }

    public Segment getStack() {
        return TraceParser.parseSegment(this.traceDumpPrefix + traceSuffixStack);
    }

    public Segment getHeap() {
        try {
            return TraceParser.parseSegment(this.traceDumpPrefix + traceSuffixHeap);
        }
        catch (UncheckedIOException e) {
            return null;
        }
    }

    public Map<String, BigInt> getRegisters() {
        return TraceParser.parseRegisters(this.traceDumpPrefix + traceSuffixRegisters);
    }

    public List<P3<Long, Long, Boolean>> getControlFlow() {
        return TraceParser.parseControlFlow(this.traceDumpPrefix + traceSuffixFlow);
    }

    public String getControlFlowDebugOutput() {
        return TraceParser.parseControlFlowDebug(this.traceDumpPrefix + traceSuffixDebug);
    }
}

