/*
 * Decompiled with CFR 0.152.
 */
package binparse;

import java.util.EnumSet;
import java.util.Set;

public enum Permission {
    Read,
    Write,
    Execute;

    public static final Set<Permission> $ReadOnly;
    public static final Set<Permission> $ReadWrite;
    public static final Set<Permission> $ReadExecute;
    public static final Set<Permission> $ReadExecuteWrite;

    public static boolean isReadable(Set<Permission> permissions) {
        return permissions.contains((Object)Read);
    }

    public static boolean isWritable(Set<Permission> permissions) {
        return permissions.contains((Object)Write);
    }

    public static boolean isExecutable(Set<Permission> permissions) {
        return permissions.contains((Object)Execute);
    }

    public static String unixStylePrettyPrint(Set<Permission> permissions) {
        StringBuilder builder = new StringBuilder();
        builder.append(permissions.contains((Object)Read) ? "r" : "-");
        builder.append(permissions.contains((Object)Write) ? "w" : "-");
        builder.append(permissions.contains((Object)Execute) ? "x" : "-");
        return builder.toString();
    }

    static {
        $ReadOnly = EnumSet.of(Read);
        $ReadWrite = EnumSet.of(Read, Write);
        $ReadExecute = EnumSet.of(Read, Execute);
        $ReadExecuteWrite = EnumSet.of(Read, Execute, Write);
    }
}

