/*
 * Decompiled with CFR 0.152.
 */
package bindis.gdsl;

import gdsl.decoder.NativeInstruction;
import gdsl.rreil.IRReilCollection;
import gdsl.rreil.statement.IStatement;
import gdsl.translator.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.TranslationException;
import rreil.gdsl.StatementCollection;
import rreil.gdsl.builder.Builder;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.RReilHighLevelToLowLevelWrapper;

public class GdslInstruction
extends Instruction {
    private final NativeInstruction gdslInsn;
    private Translator rreilTranslator;

    public GdslInstruction(long address, byte[] opcode, NativeInstruction gdslInsn, List<OperandTree> opnds, Translator rreilTranslator) {
        super(address, opcode, gdslInsn.mnemonic().toLowerCase(), opnds);
        this.gdslInsn = gdslInsn;
        this.rreilTranslator = rreilTranslator;
    }

    @Override
    public List<LowLevelRReil> toRReilInstructions() throws TranslationException {
        ArrayList<LowLevelRReil> rreil = new ArrayList<LowLevelRReil>();
        IRReilCollection<IStatement> coll = this.rreilTranslator.translate(this.gdslInsn);
        StatementCollection statements = (StatementCollection)((Builder)((Object)coll)).build().getResult();
        SortedMap<RReilAddr, RReil> instructions = statements.getInstructions();
        for (RReil next : instructions.values()) {
            rreil.add(new RReilHighLevelToLowLevelWrapper(next));
        }
        return rreil;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-6s", this.mnemonic().trim()));
        builder.append(" ");
        builder.append(this.getOperandsString());
        return GdslInstruction.prettyPrintFixup(builder.toString());
    }

    public String getMnemonicString() {
        return this.mnemonic().trim();
    }

    public String getOperandsString() {
        String rawString = this.gdslInsn.toString().trim().toLowerCase();
        String mnemonicString = this.getMnemonicString();
        String operandsString = rawString.replaceFirst(mnemonicString, "").trim();
        operandsString = operandsString.replaceAll("dword ptr", "DWORD PTR");
        operandsString = operandsString.replaceAll("ptr\\(0\\) ", "");
        return operandsString;
    }

    public String oldToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-6s", this.gdslInsn.mnemonic()));
        builder.append(" ");
        for (int i = 0; i < this.gdslInsn.operands(); ++i) {
            builder.append(this.gdslInsn.operandToString(i));
            if (i >= this.gdslInsn.operands() - 1) continue;
            builder.append(", ");
        }
        return GdslInstruction.prettyPrintFixup(builder.toString());
    }

    private static String prettyPrintFixup(String instruction) {
        return instruction.toLowerCase().replaceAll("dword ptr", "DWORD PTR");
    }
}

