/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.widening.oldthresholds;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.debug.PrettyDomain;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domains.widening.oldthresholds.Threshold;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.fn.Fn2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;

class ThresholdsWideningState
extends FunctorState {
    private final AVLMap<Threshold, AVLSet<ProgramPoint>> appliedForNarrowingAt;
    private final AVLMap<Threshold.Origin, Threshold> origins;
    public static final ThresholdsWideningState EMPTY = new ThresholdsWideningState();

    private ThresholdsWideningState() {
        this.appliedForNarrowingAt = AVLMap.empty();
        this.origins = AVLMap.empty();
    }

    private ThresholdsWideningState(MutableState state) {
        assert (state.isConsistent());
        this.appliedForNarrowingAt = state.appliedForNarrowingAt;
        this.origins = state.origins;
    }

    MutableState mutableCopy() {
        return new MutableState(this.appliedForNarrowingAt, this.origins);
    }

    private static XMLBuilder pretty(Zeno.Test test, XMLBuilder builder) {
        builder = builder.e("Test");
        builder = test.toXML(builder);
        builder = builder.up();
        return builder;
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e("THRESHOLDSWIDENING(OLD)");
        for (P2<Threshold.Origin, Threshold> p2 : this.origins) {
            Threshold.Origin origin = p2._1();
            Threshold threshold = p2._2();
            AVLSet<ProgramPoint> locations = this.appliedForNarrowingAt.get(threshold).get();
            builder = builder.e("Entry").a("type", "Thresholds").e("Value").e("Origin").e("Location").t(origin.getLocation().toString()).up();
            builder = ThresholdsWideningState.pretty(origin.getTest(), builder);
            builder = builder.up();
            builder = ThresholdsWideningState.pretty(threshold.getTest(), builder);
            builder = builder.e("appliedAt");
            for (ProgramPoint point : locations) {
                builder = builder.e("point").t(point.toString()).up();
            }
            builder = builder.up().up().up();
        }
        return builder.up();
    }

    public String toString() {
        return "#" + this.appliedForNarrowingAt.size() + " " + this.contentToString();
    }

    private String contentToString() {
        Iterator<P2<Threshold, AVLSet<ProgramPoint>>> iterator = this.appliedForNarrowingAt.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<Threshold, AVLSet<ProgramPoint>> element = iterator.next();
            Threshold key = element._1();
            AVLSet<ProgramPoint> value = element._2();
            builder.append(key);
            builder.append(" : ");
            builder.append(value);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }

    static class MutableState
    implements Iterable<Threshold> {
        private AVLMap<Threshold, AVLSet<ProgramPoint>> appliedForNarrowingAt;
        private AVLMap<Threshold.Origin, Threshold> origins;

        private MutableState(AVLMap<Threshold, AVLSet<ProgramPoint>> appliedForNarrowingAt, AVLMap<Threshold.Origin, Threshold> origins) {
            this.appliedForNarrowingAt = appliedForNarrowingAt;
            this.origins = origins;
        }

        ThresholdsWideningState immutableCopy() {
            return new ThresholdsWideningState(this);
        }

        public boolean isConsistent() {
            for (Threshold threshold : this) {
                Threshold.Origin original = threshold.getOrigin();
                if (this.origins.contains(original) && this.origins.get(original).get().compareTo(threshold) == 0) continue;
                return false;
            }
            return true;
        }

        private MutableState rebuildReverseMapping() {
            this.origins = AVLMap.empty();
            for (Threshold threshold : this) {
                this.origins = this.origins.bind((Object)threshold.getOrigin(), (Object)threshold);
            }
            return this;
        }

        public P3<MutableState, MutableState, MutableState> split(MutableState other) {
            P3<AVLMap<Threshold, AVLSet<ProgramPoint>>, AVLMap<Threshold, AVLSet<ProgramPoint>>, AVLMap<Threshold, AVLSet<ProgramPoint>>> narrowingSplit = MutableState.splitWithMergerForDiffering(this.appliedForNarrowingAt, other.appliedForNarrowingAt, new Merger<AVLSet<ProgramPoint>>(){

                @Override
                public AVLSet<ProgramPoint> apply(AVLSet<ProgramPoint> a, AVLSet<ProgramPoint> b) {
                    return a.union(b);
                }
            });
            AVLMap<Threshold.Origin, Threshold> empty = AVLMap.empty();
            return P3.tuple3(new MutableState(narrowingSplit._1(), empty).rebuildReverseMapping(), new MutableState(narrowingSplit._2(), empty).rebuildReverseMapping(), new MutableState(narrowingSplit._3(), empty).rebuildReverseMapping());
        }

        private static <A, B> P3<AVLMap<A, B>, AVLMap<A, B>, AVLMap<A, B>> splitWithMergerForDiffering(AVLMap<A, B> first, AVLMap<A, B> second, Fn2<B, B, B> differingValuesMerger) {
            ThreeWaySplit<AVLMap<A, B>> triple = first.split(second);
            FiniteMap inBoth = first.difference(triple.onlyInFirst());
            for (P2<A, B> p2 : triple.inBothButDiffering()) {
                A threshold = p2._1();
                B thisValue = p2._2();
                B thatValue = second.get(threshold).get();
                inBoth = inBoth.bind(threshold, differingValuesMerger.apply(thisValue, thatValue));
            }
            return P3.tuple3(triple.onlyInFirst(), inBoth, triple.onlyInSecond());
        }

        public boolean hasAppliedThresholdsNotIn(MutableState other) {
            AVLSet<ProgramPoint> thisValue;
            Threshold threshold;
            AVLMap<Threshold, AVLSet<ProgramPoint>> first = this.appliedForNarrowingAt;
            AVLMap<Threshold, AVLSet<ProgramPoint>> second = other.appliedForNarrowingAt;
            ThreeWaySplit<AVLMap<Threshold, AVLSet<ProgramPoint>>> triple = first.split(second);
            for (P2<Threshold, AVLSet<ProgramPoint>> p2 : triple.inBothButDiffering()) {
                AVLSet<ProgramPoint> thatValue;
                threshold = p2._1();
                thisValue = p2._2();
                AVLSet<ProgramPoint> difference = thisValue.difference(thatValue = second.get(threshold).get());
                if (difference.isEmpty()) continue;
                return false;
            }
            for (P2<Threshold, AVLSet<ProgramPoint>> p2 : triple.onlyInFirst()) {
                AVLSet<ProgramPoint> thatValue;
                AVLSet<ProgramPoint> difference;
                threshold = p2._1();
                thisValue = p2._2();
                Option<Threshold> origin = other.origins.get(threshold.getOrigin());
                if (origin.isNone() && !thisValue.isEmpty()) {
                    return false;
                }
                if (!origin.isSome() || (difference = thisValue.difference(thatValue = second.get(origin.get()).get())).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public void add(Threshold threshold) {
            this.add(threshold, AVLSet.empty());
        }

        public void add(Threshold threshold, AVLSet<ProgramPoint> appliedAt) {
            Option<Threshold> contained = this.origins.get(threshold.getOrigin());
            if (contained.isSome()) {
                this.appliedForNarrowingAt = this.appliedForNarrowingAt.remove((Object)contained.get());
            }
            this.appliedForNarrowingAt = this.appliedForNarrowingAt.bind((Object)threshold, appliedAt);
            this.origins = this.origins.bind((Object)threshold.getOrigin(), (Object)threshold);
        }

        public void remove(Threshold threshold) {
            assert (this.appliedForNarrowingAt.contains(threshold));
            this.appliedForNarrowingAt = this.appliedForNarrowingAt.remove((Object)threshold);
            this.origins = this.origins.remove((Object)threshold.getOrigin());
        }

        public void substitute(Threshold threshold, Threshold newThreshold) {
            assert (this.appliedForNarrowingAt.contains(threshold));
            AVLSet<ProgramPoint> appliedSet = this.getAppliedPoints(threshold);
            this.remove(threshold);
            this.add(newThreshold, appliedSet);
        }

        public boolean contains(Threshold threshold) {
            return this.appliedForNarrowingAt.contains(threshold);
        }

        public boolean contains(Threshold.Origin originalThreshold) {
            return this.origins.contains(originalThreshold);
        }

        public boolean containsAnyAppliedFrom(ProgramPoint point) {
            for (P2<Threshold.Origin, Threshold> p2 : this.origins) {
                Threshold.Origin original = p2._1();
                if (!original.getLocation().equals(point) || !this.isApplied(original)) continue;
                return true;
            }
            return false;
        }

        public boolean isApplied(Threshold.Origin originalThreshold) {
            assert (this.origins.contains(originalThreshold));
            Threshold threshold = this.origins.get(originalThreshold).get();
            assert (this.appliedForNarrowingAt.contains(threshold));
            return !this.appliedForNarrowingAt.get(threshold).get().isEmpty();
        }

        public boolean isAppliedAt(Threshold threshold, ProgramPoint point) {
            assert (this.appliedForNarrowingAt.contains(threshold));
            return this.appliedForNarrowingAt.get(threshold).get().contains(point);
        }

        public void markAppliedAt(Threshold threshold, ProgramPoint point) {
            assert (this.appliedForNarrowingAt.contains(threshold));
            AVLSet<ProgramPoint> newAppliedSet = this.appliedForNarrowingAt.get(threshold).get().add(point);
            this.appliedForNarrowingAt = this.appliedForNarrowingAt.bind((Object)threshold, newAppliedSet);
        }

        public AVLSet<ProgramPoint> getAppliedPoints(Threshold threshold) {
            assert (this.appliedForNarrowingAt.contains(threshold));
            return this.appliedForNarrowingAt.get(threshold).get();
        }

        @Override
        public Iterator<Threshold> iterator() {
            return this.appliedForNarrowingAt.keys().iterator();
        }

        public String toString() {
            return new ThresholdsWideningState(this).toString();
        }

        private static abstract class Merger<T>
        extends Fn2<T, T, T> {
            private Merger() {
            }
        }
    }
}

