/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.syntacticstripes;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domains.affine.Substitution;
import bindead.domains.syntacticstripes.Stripe;
import bindead.domains.syntacticstripes.StripeState;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.ThreeWaySplit;

final class StripeStateBuilder
extends ZenoStateBuilder {
    private static final ZenoFactory zeno = ZenoFactory.getInstance();
    private static final String SPECIALVARIABLEPREFIX = "w";
    AVLMap<Linear, Stripe> stripes;
    AVLMap<NumVar, AVLSet<Linear>> reverse;
    AVLMap<NumVar, Constraint> narrowingconstraints;
    VarSet specials;

    public StripeStateBuilder(StripeState stripes) {
        this(stripes, false);
    }

    public StripeStateBuilder(StripeState stripes, boolean keeppredicates) {
        this.stripes = stripes.stripes;
        this.reverse = stripes.reverse;
        this.specials = stripes.specials;
        this.narrowingconstraints = keeppredicates ? stripes.narrowingconstraints : StripeState.EMPTYCONSTRAINTS;
    }

    public StripeState build() {
        return new StripeState(this.stripes, this.reverse, this.specials, this.narrowingconstraints);
    }

    public void applyDirectSubstitution(NumVar x, NumVar y) {
        this.applyDirectSubstitutionToConstraints(x, y);
        AVLSet<Linear> usedIn = this.reverse.getOrNull(x);
        for (Linear oldLin : usedIn) {
            Stripe special = this.stripes.get(oldLin).get();
            BigInt coeff = oldLin.getCoeff(x);
            Linear newLin = oldLin.dropTerm(x);
            newLin = newLin.addTerm(coeff, y).toEquality();
            this.normalizeSpecial(oldLin, newLin, special);
            this.removeLinear(oldLin, special.special);
            this.insertStripe(newLin, special);
        }
    }

    private void applyDirectSubstitutionToConstraints(NumVar x, NumVar y) {
        Constraint c = this.narrowingconstraints.get(x).getOrNull();
        if (c == null) {
            return;
        }
        this.removeConstraint(c);
        this.addConstraint(c.applySubstitution(x, y));
    }

    public void applyAffineTransformation(Transformation trans) {
        Linear newEq = trans.getNewEquality();
        if (newEq == null) {
            this.applyInvertibleSubstitution(trans);
        } else {
            this.applyNonInvertibleSubstitution(trans);
        }
    }

    private void applyInvertibleSubstitution(Transformation trans) {
        NumVar x = trans.getLhs();
        Linear rhs = trans.getRhs();
        AVLSet<Linear> usedIn = this.reverse.get(x).getOrElse(StripeState.EMPTYSET);
        this.applyInvertibleSubstitutionToConstraints(trans);
        if (usedIn.isEmpty()) {
            if (rhs.getVars().size() >= 2) {
                Stripe w = this.allocateSpecial();
                Substitution sigma = trans.genSubstitution();
                Linear.Divisor gcd = Linear.Divisor.one();
                Linear newLin = sigma.getExpr();
                BigInt c = newLin.getConstant();
                newLin = newLin.dropConstant().lowestForm(gcd);
                newLin = StripeStateBuilder.normalize(newLin, gcd);
                this.getChildOps().addAssignment(zeno.assign(zeno.variable(w.special), zeno.linear(Linear.linear(c, Linear.term(x)), gcd.get())));
                this.insertStripe(newLin, w);
            }
        } else {
            Substitution subst = trans.genSubstitution();
            this.applySubstitution$(subst);
        }
    }

    private void applyInvertibleSubstitutionToConstraints(Transformation trans) {
        NumVar x = trans.getLhs();
        Substitution sigma = trans.genSubstitution();
        this.applyInvertibleSubstitutionToConstraints(x, sigma);
    }

    private void applyInvertibleSubstitutionToConstraints(NumVar x, Substitution sigma) {
        Constraint c = this.narrowingconstraints.getOrNull(x);
        if (c == null) {
            return;
        }
        this.removeConstraint(c);
        this.addConstraint(c.applySubstitution(sigma));
    }

    private void applySubstitution$(Substitution subst) {
        NumVar var = subst.getVar();
        AVLSet<Linear> usedIn = this.reverse.get(var).getOrElse(StripeState.EMPTYSET);
        for (Linear oldLin : usedIn) {
            Stripe special = this.stripes.get(oldLin).get();
            Linear newLin = oldLin.applySubstitution(subst);
            BigInt c = newLin.getConstant();
            if ((newLin = newLin.dropConstant().toEquality()).getVars().size() < 2) {
                if (oldLin.getVars().size() > 2) {
                    newLin = this.shortenStripe(oldLin, special, var);
                    this.removeLinear(oldLin, special.special);
                    this.insertStripe(newLin, special);
                    continue;
                }
                this.removeLinear(oldLin, special.special);
                this.getChildOps().addKill(special.special);
                continue;
            }
            Stripe newSpecial = this.allocateSpecial();
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(newSpecial.special), zeno.linear(special.special)));
            this.normalizeSpecial(oldLin, newLin, newSpecial, subst.getFac(), c);
            this.removeLinear(oldLin, special.special);
            this.insertStripe(newLin, newSpecial);
            this.getChildOps().addKill(special.special);
        }
    }

    private Linear shortenStripe(Linear oldLin, Stripe special, NumVar x) {
        Linear.Divisor gcd = Linear.Divisor.one();
        Linear newLin = oldLin.dropTerm(x).lowestForm(gcd);
        newLin = StripeStateBuilder.normalize(newLin, gcd);
        this.getChildOps().addAssignment(zeno.assign(zeno.variable(special.special), zeno.linear(Linear.linear(Linear.term(special.special), Linear.term(oldLin.getCoeff(x), x)), gcd.get())));
        return newLin;
    }

    private void normalizeSpecial(Linear oldLin, Linear newLin, Stripe special) {
        BigInt b;
        NumVar key = StripeStateBuilder.chooseVar(oldLin, newLin);
        if (key == null) {
            return;
        }
        BigInt a = oldLin.getCoeff(key);
        if (a.mul(b = newLin.getCoeff(key)).isNegative()) {
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(special.special), zeno.linear(Linear.linear(Linear.term(Bound.MINUSONE, special.special)))));
        }
    }

    private void normalizeSpecial(Linear oldLin, Linear newLin, Stripe special, BigInt f, BigInt c) {
        BigInt b;
        NumVar key = StripeStateBuilder.chooseVar(oldLin, newLin);
        BigInt a = oldLin.getCoeff(key);
        if (a.mul(b = newLin.getCoeff(key)).mul(f).isPositive()) {
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(special.special), zeno.linear(Linear.linear(c, Linear.term(f, special.special)))));
        } else {
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(special.special), zeno.linear(Linear.linear(c, Linear.term(f.negate(), special.special)))));
        }
    }

    private static NumVar chooseVar(Linear oldLin, Linear newLin) {
        VarSet oldVars = oldLin.getVars();
        VarSet newVars = newLin.getVars();
        for (NumVar x : oldVars) {
            if (!newVars.contains(x)) continue;
            return x;
        }
        return null;
    }

    private void applyNonInvertibleSubstitution(Transformation trans) {
        NumVar var = trans.getLhs();
        Linear newEq = trans.getNewEquality();
        assert (newEq != null);
        this.applyProjection(var, trans.channel);
        if (newEq.getVars().size() >= 2) {
            Stripe special = this.allocateSpecial();
            Linear lin = this.allocateStripe(newEq, special);
            this.insertStripe(lin, special);
        }
    }

    private Stripe allocateSpecial() {
        NumVar special = NumVar.fresh(SPECIALVARIABLEPREFIX);
        this.getChildOps().addIntro(special);
        return new Stripe(special);
    }

    private Linear allocateStripe(Linear lin, Stripe special) {
        BigInt c = lin.getConstant();
        BigInt coeff = lin.getCoeff(lin.getKey());
        Linear newLin = lin.dropConstant().toEquality();
        c = coeff.isEqualTo(lin.getCoeff(lin.getKey())) ? c : c.negate();
        this.getChildOps().addAssignment(zeno.assign(zeno.variable(special.special), zeno.literal(c)));
        return newLin;
    }

    private void bootstrapStripe(Stripe special, Linear lin) {
        assert (StripeStateBuilder.isNormalized(lin));
        this.getChildOps().addIntro(special.special);
        this.getChildOps().addAssignment(zeno.assign(zeno.variable(special.special), zeno.linear(lin.negate())));
    }

    private void insertStripe(Linear lin, Stripe stripe) {
        assert (StripeStateBuilder.isNormalized(lin)) : "trying to insert non-normalized linear expression";
        assert (lin.getConstant().isZero()) : "trying to insert stripe with non-zero constant";
        if (this.stripes.contains(lin)) {
            this.getChildOps().addKill(stripe.special);
            return;
        }
        this.stripes = this.stripes.bind((Object)lin, (Object)stripe);
        this.reverse = this.reverse.bind((Object)stripe.special, StripeState.EMPTYSET.add(lin));
        this.specials = this.specials.add(stripe.special);
        for (Linear.Term t : lin) {
            NumVar x = t.getId();
            AVLSet<Linear> vs = this.reverse.get(x).getOrElse(StripeState.EMPTYSET).add(lin);
            this.reverse = this.reverse.bind((Object)x, vs);
        }
    }

    private static boolean isNormalized(Linear lin) {
        BigInt coeff = lin.getCoeff(lin.getKey());
        return coeff.isPositive();
    }

    void removeLinear(Linear lin, NumVar special) {
        for (Linear.Term t : lin) {
            NumVar x = t.getId();
            this.reverse = this.reverse.bind((Object)x, this.reverse.get(x).get().remove(lin));
        }
        this.reverse = this.reverse.bind((Object)special, this.reverse.get(special).get().remove(lin));
        this.stripes = this.stripes.remove((Object)lin);
        this.specials = this.specials.remove(special);
    }

    public static void makeCompatible(StripeStateBuilder fst, StripeStateBuilder snd) {
        AVLSet<Linear> usedIn;
        Stripe special;
        Linear lin;
        ThreeWaySplit<AVLMap<Linear, Stripe>> diff = fst.stripes.split(snd.stripes);
        for (P2<Linear, Stripe> p2 : diff.onlyInFirst()) {
            lin = p2._1();
            special = p2._2();
            usedIn = snd.reverse.get(special.special).getOrElse(StripeState.EMPTYSET);
            if (usedIn.isEmpty()) {
                snd.bootstrapStripe(special, lin);
                snd.insertStripe(lin, special);
                continue;
            }
            fst.removeLinear(lin, special.special);
            fst.getChildOps().addKill(special.special);
        }
        for (P2<Linear, Stripe> p2 : diff.onlyInSecond()) {
            lin = p2._1();
            special = p2._2();
            usedIn = fst.reverse.get(special.special).getOrElse(StripeState.EMPTYSET);
            if (usedIn.isEmpty()) {
                fst.bootstrapStripe(special, lin);
                fst.insertStripe(lin, special);
                continue;
            }
            snd.removeLinear(lin, special.special);
            snd.getChildOps().addKill(special.special);
        }
        for (P2<Linear, Stripe> p2 : diff.inBothButDiffering()) {
            lin = p2._1();
            Stripe fromFst = p2._2();
            Stripe fromSnd = snd.stripes.get(p2._1()).get();
            snd.removeLinear(lin, fromSnd.special);
            snd.insertStripe(lin, fromFst);
            snd.getChildOps().addDirectSubstitution(fromSnd.special, fromFst.special);
        }
        ThreeWaySplit<AVLMap<NumVar, Constraint>> splitConstraints = fst.narrowingconstraints.split(snd.narrowingconstraints);
        fst.narrowingconstraints = fst.narrowingconstraints.difference(splitConstraints.onlyInFirst());
        fst.narrowingconstraints = fst.narrowingconstraints.difference(splitConstraints.inBothButDiffering());
        snd.narrowingconstraints = snd.narrowingconstraints.difference(splitConstraints.onlyInSecond());
        snd.narrowingconstraints = snd.narrowingconstraints.difference(splitConstraints.inBothButDiffering());
    }

    public static void makeCompatibleForWidening(StripeStateBuilder fst, StripeStateBuilder snd) {
        Stripe special;
        Linear lin;
        ThreeWaySplit<AVLMap<Linear, Stripe>> diff = fst.stripes.split(snd.stripes);
        for (P2<Linear, Stripe> p2 : diff.onlyInFirst()) {
            lin = p2._1();
            special = p2._2();
            fst.removeLinear(lin, special.special);
            fst.getChildOps().addKill(special.special);
        }
        for (P2<Linear, Stripe> p2 : diff.onlyInSecond()) {
            lin = p2._1();
            special = p2._2();
            snd.removeLinear(lin, special.special);
            snd.getChildOps().addKill(special.special);
        }
        for (P2<Linear, Stripe> p2 : diff.inBothButDiffering()) {
            lin = p2._1();
            Stripe fromFst = p2._2();
            Stripe fromSnd = snd.stripes.get(p2._1()).get();
            snd.removeLinear(lin, fromSnd.special);
            snd.insertStripe(lin, fromFst);
            snd.getChildOps().addDirectSubstitution(fromSnd.special, fromFst.special);
        }
    }

    void findNarrowingConstraints(QueryChannel proxyOfFst, QueryChannel proxyOfSnd) {
        for (P2<Linear, Stripe> p2 : this.stripes) {
            Interval inSnd;
            Interval inFst;
            Interval fromSnd;
            Linear lin = p2._1();
            Stripe special = p2._2();
            Interval fromFst = proxyOfFst.queryRange(special.special).convexHull();
            if (fromFst.compareTo(fromSnd = proxyOfSnd.queryRange(special.special).convexHull()) == 0 || !fromFst.isFinite() || !fromSnd.isFinite() || (inFst = proxyOfFst.queryRange(lin).convexHull()).compareTo(inSnd = proxyOfSnd.queryRange(lin).convexHull()) == 0 || !inFst.isFinite() || !inSnd.isFinite()) continue;
            Linear q = lin;
            Linear w = special.asLinear();
            BigInt uw1 = fromFst.high().asInteger();
            BigInt uw2 = fromSnd.high().asInteger();
            BigInt lw1 = fromFst.low().asInteger();
            BigInt lw2 = fromSnd.low().asInteger();
            BigInt uq1 = inFst.high().asInteger();
            BigInt uq2 = inSnd.high().asInteger();
            BigInt lq1 = inFst.low().asInteger();
            BigInt lq2 = inSnd.low().asInteger();
            this.maybeAddConstraint(false, w, false, q, lw1, lq1, lw2, lq2);
            this.maybeAddConstraint(true, w, false, q, uw1, lq1, uw2, lq2);
            this.maybeAddConstraint(false, w, true, q, lw1, uq1, lw2, uq2);
            this.maybeAddConstraint(true, w, true, q, uw1, uq1, uw2, uq2);
        }
    }

    private void maybeAddConstraint(boolean maxX, Linear x, boolean maxY, Linear y, BigInt x1, BigInt y1, BigInt x2, BigInt y2) {
        Constraint c = Constraint.findConstraintOrNull(maxX, x, maxY, y, x1, y1, x2, y2);
        if (c != null) {
            this.addConstraint(c);
        }
    }

    private void addConstraint(Constraint c) {
        for (NumVar x : c.getVars()) {
            this.narrowingconstraints = this.narrowingconstraints.bind((Object)x, (Object)c);
        }
    }

    private void removeConstraint(Constraint c) {
        for (NumVar x : c.getVars()) {
            this.narrowingconstraints = this.narrowingconstraints.remove((Object)x);
        }
    }

    public void applyProjection(NumVar x, QueryChannel channel) {
        AVLSet<Linear> usedIn = this.reverse.get(x).getOrElse(StripeState.EMPTYSET);
        AVLSet<Linear> equalities = StripeState.EMPTYSET;
        for (Linear lin : usedIn) {
            Range range = this.querySpecial(channel, lin);
            BigInt c = range.getConstantOrNull();
            if (c == null) continue;
            equalities = equalities.add(lin.add(c));
        }
        for (Linear eq : equalities) {
            for (Linear oldLin : usedIn.remove(eq)) {
                this.tryInsertEquality(eq, x, oldLin);
            }
        }
        this.removeVariable(x);
    }

    private void tryInsertEquality(Linear eq, NumVar x, Linear oldLin) {
        Stripe oldSpecial = this.stripes.get(oldLin).get();
        oldLin = oldLin.add(oldSpecial.special);
        Substitution sigma = eq.genSubstitution(x);
        Linear lin = oldLin.applySubstitution(sigma);
        this.applyInvertibleSubstitutionToConstraints(x, sigma);
        if (lin.getVars().size() > 2) {
            Stripe newSpecial = this.allocateSpecial();
            Linear.Divisor d = Linear.Divisor.one();
            Linear newLin = lin.dropConstant().lowestForm(d);
            newLin = newLin.dropTerm(oldSpecial.special).lowestForm(d);
            newLin = StripeStateBuilder.normalize(newLin, d);
            BigInt coeff = lin.getCoeff(oldSpecial.special);
            BigInt c = lin.getConstant();
            this.getChildOps().addAssignment(zeno.assign(zeno.variable(newSpecial.special), zeno.linear(Linear.linear(c, Linear.term(coeff, oldSpecial.special)), d.get())));
            this.insertStripe(newLin, newSpecial);
        }
    }

    public static Linear normalize(Linear lin, Linear.Divisor d) {
        BigInt c2;
        Linear newLin = lin.toEquality();
        BigInt c1 = lin.getCoeff(lin.getKey());
        if (!c1.isEqualTo(c2 = newLin.getCoeff(lin.getKey()))) {
            d.negate();
        }
        return newLin;
    }

    public void removeVariable(NumVar numVar) {
        Constraint c = this.narrowingconstraints.get(numVar).getOrNull();
        if (c != null) {
            this.removeConstraint(c);
        }
        AVLSet<Linear> usedIn = this.reverse.get(numVar).getOrElse(StripeState.EMPTYSET);
        for (Linear lin : usedIn) {
            Stripe special = this.stripes.get(lin).get();
            if (lin.getVars().size() > 2) {
                Linear newLin = this.shortenStripe(lin, special, numVar);
                this.removeLinear(lin, special.special);
                this.insertStripe(newLin, special);
                continue;
            }
            this.removeLinear(lin, special.special);
            this.getChildOps().addKill(special.special);
        }
    }

    private Range querySpecial(QueryChannel channel, Linear key) {
        NumVar special = this.stripes.get((Linear)key).get().special;
        return channel.queryRange(Linear.linear(special));
    }

    @Override
    public String toString() {
        return "StripeStateBuilder{" + this.stripes + '}';
    }

    static class Transformation {
        private final QueryChannel channel;
        private final Linear.Divisor divisor;
        private final NumVar lhs;
        private final Linear rhs;
        private final Linear newEquality;

        Transformation(QueryChannel channel, Linear.Divisor divisor, NumVar lhs, Linear rhs) {
            this.channel = channel;
            this.divisor = divisor;
            this.lhs = lhs;
            this.rhs = rhs;
            this.newEquality = this.genEqualityOrNull();
        }

        public Transformation(QueryChannel channel, Zeno.Lhs lhs, Zeno.Rlin rhs) {
            this(channel, new Linear.Divisor(rhs.getDivisor()), lhs.getId(), rhs.getLinearTerm());
        }

        private Linear genEqualityOrNull() {
            return this.rhs.addTerm(this.divisor.get().negate(), this.lhs) == null ? null : this.rhs.subTerm(this.divisor.get(), this.lhs).toEquality();
        }

        public Substitution genSubstitution() {
            return Substitution.invertingSubstitution(this.rhs, this.divisor.get(), this.lhs);
        }

        public Linear.Divisor getDivisor() {
            return this.divisor;
        }

        public NumVar getLhs() {
            return this.lhs;
        }

        public Linear getRhs() {
            return this.rhs;
        }

        public Linear getNewEquality() {
            return this.newEquality;
        }

        public String toString() {
            return "Transformation{" + this.lhs + " = " + this.rhs + " / " + this.divisor + "}";
        }
    }

    static class Constraint {
        static final boolean MAX = true;
        static final boolean MIN = false;
        final boolean max1;
        final BigInt a1;
        final Linear special;
        final boolean max2;
        final BigInt a2;
        final Linear stripe;
        final BigInt c;

        Constraint(boolean max1, BigInt a1, Linear special, boolean max2, BigInt a2, Linear stripe, BigInt c) {
            this.max1 = max1;
            this.a1 = a1;
            this.special = special;
            this.max2 = max2;
            this.a2 = a2;
            this.stripe = stripe;
            this.c = c;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("<");
            builder.append(this.max2 ? "max(" : "min(");
            builder.append(this.a2 + "(" + this.stripe + ")").append(") + ");
            builder.append(this.max1 ? "max(" : "min(");
            builder.append(this.a1 + "(" + this.special + ")").append(')');
            builder.append(" <= ").append(this.c).append('>');
            return builder.toString();
        }

        VarSet getVars() {
            return this.special.getVars().union(this.stripe.getVars());
        }

        Constraint applySubstitution(Substitution sigma) {
            Linear.Divisor d = Linear.Divisor.one();
            Linear newStripe = this.stripe.applySubstitution(sigma).lowestForm(d);
            if (d.get().isNegative()) {
                return new Constraint(!this.max1, this.a1, this.special, !this.max2, this.a2, newStripe, this.c.negate());
            }
            return new Constraint(this.max1, this.a1, this.special, this.max2, this.a2, newStripe, this.c);
        }

        Constraint applySubstitution(NumVar y, NumVar x) {
            Linear newStripe = this.stripe.applySubstitution(y, x);
            if (StripeStateBuilder.isNormalized(newStripe)) {
                return new Constraint(this.max1, this.a1, this.special, this.max2, this.a2, newStripe, this.c);
            }
            return new Constraint(!this.max1, this.a1, this.special, !this.max2, this.a2, newStripe.toEquality(), this.c.negate());
        }

        Zeno.Test asTestOrNull(QueryChannel channel) {
            Interval fromStripe = channel.queryRange(this.stripe).convexHull().mul(this.a2);
            if (!fromStripe.isFinite()) {
                return null;
            }
            BigInt x = this.max2 ? fromStripe.high().asInteger() : fromStripe.low().asInteger();
            x = this.c.sub(x);
            Linear lin = this.special.sub(x);
            lin = this.max1 ? lin : lin.smul(this.a1).negate();
            return zeno.comparison(lin, Zeno.ZenoTestOp.LessThanOrEqualToZero);
        }

        static Constraint findConstraintOrNull(boolean maxX, Linear x, boolean maxY, Linear y, BigInt x1, BigInt y1, BigInt x2, BigInt y2) {
            BigInt a = y2.sub(y1);
            BigInt b = x1.sub(x2);
            BigInt c = a.mul(x1).add(b.mul(y1));
            if (!a.isZero() && !b.isZero()) {
                return new Constraint(maxX, a, x, maxY, b, y, c);
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a1 == null ? 0 : this.a1.hashCode());
            result = 31 * result + (this.a2 == null ? 0 : this.a2.hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            result = 31 * result + (this.max1 ? 1231 : 1237);
            result = 31 * result + (this.max2 ? 1231 : 1237);
            result = 31 * result + (this.special == null ? 0 : this.special.hashCode());
            result = 31 * result + (this.stripe == null ? 0 : this.stripe.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Constraint other = (Constraint)obj;
            if (this.a1 == null ? other.a1 != null : !this.a1.isEqualTo(other.a1)) {
                return false;
            }
            if (this.a2 == null ? other.a2 != null : !this.a2.isEqualTo(other.a2)) {
                return false;
            }
            if (this.c == null ? other.c != null : !this.c.isEqualTo(other.c)) {
                return false;
            }
            if (this.max1 != other.max1) {
                return false;
            }
            if (this.max2 != other.max2) {
                return false;
            }
            if (this.special == null ? other.special != null : !this.special.equals(other.special)) {
                return false;
            }
            return !(this.stripe == null ? other.stripe != null : !this.stripe.equals(other.stripe));
        }
    }
}

