/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.syntacticstripes;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SynthChannel;
import bindead.domainnetwork.interfaces.FunctorState;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.syntacticstripes.Stripe;
import bindead.domains.syntacticstripes.StripeProperties;
import bindead.domains.syntacticstripes.StripeStateBuilder;
import bindead.domains.syntacticstripes.Stripes;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;

final class StripeState
extends FunctorState {
    private static final boolean CHECK = StripeProperties.INSTANCE.checkState.isTrue();
    static final AVLSet<Linear> EMPTYSET = AVLSet.empty();
    static final AVLMap<NumVar, StripeStateBuilder.Constraint> EMPTYCONSTRAINTS = AVLMap.empty();
    static final StripeState EMPTY = StripeState.empty();
    final AVLMap<Linear, Stripe> stripes;
    final AVLMap<NumVar, AVLSet<Linear>> reverse;
    final AVLMap<NumVar, StripeStateBuilder.Constraint> narrowingconstraints;
    final VarSet specials;

    StripeState(AVLMap<Linear, Stripe> stripes, AVLMap<NumVar, AVLSet<Linear>> reverse, VarSet specials) {
        this.stripes = stripes;
        this.reverse = reverse;
        this.specials = specials;
        this.narrowingconstraints = EMPTYCONSTRAINTS;
        if (CHECK) {
            this.check();
        }
    }

    StripeState(AVLMap<Linear, Stripe> stripes, AVLMap<NumVar, AVLSet<Linear>> reverse, VarSet specials, AVLMap<NumVar, StripeStateBuilder.Constraint> narrowingpredicates) {
        this.stripes = stripes;
        this.reverse = reverse;
        this.specials = specials;
        this.narrowingconstraints = narrowingpredicates;
        if (CHECK) {
            this.check();
        }
    }

    private static StripeState empty() {
        return new StripeState(AVLMap.empty(), AVLMap.empty(), VarSet.empty());
    }

    boolean notInSupport(NumVar var) {
        return !this.inSupport(var);
    }

    boolean inSupport(NumVar var) {
        return this.inReverseMapping(var);
    }

    private boolean inReverseMapping(NumVar var) {
        Option<AVLSet<Linear>> usedIn = this.reverse.get(var);
        if (usedIn.isNone()) {
            return false;
        }
        return usedIn.get().size() > 0;
    }

    public String toString() {
        Iterator<P2<Linear, Stripe>> iterator = this.stripes.iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            P2<Linear, Stripe> element = iterator.next();
            Linear key = element._1();
            Stripe value = element._2();
            builder.append(value);
            builder.append(": ");
            builder.append(key);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        XMLBuilder xml = builder;
        for (P2<Linear, Stripe> p2 : this.stripes) {
            p2._1().toXML(builder);
        }
        return xml;
    }

    Linear inlineSyntactically(Linear linear) {
        Linear.Divisor gcd = Linear.Divisor.one();
        Linear t = linear.dropConstant().lowestForm(gcd);
        if (this.stripes.contains(t)) {
            Stripe stripe = this.stripes.get(t).get();
            return stripe.asNegatedLinear(gcd, linear.getConstant());
        }
        if (this.stripes.contains(t.negate())) {
            Stripe stripe = this.stripes.get(t.negate()).get();
            return stripe.asLinear(gcd, linear.getConstant());
        }
        return linear;
    }

    Linear inlineSyntacticallyForTest(Linear linear) {
        Linear.Divisor gcd = Linear.Divisor.one();
        Linear t = linear.dropConstant().lowestForm(gcd);
        if (this.stripes.contains(t)) {
            Stripe stripe = this.stripes.get(t).get();
            return linear.add(stripe.asLinear());
        }
        if (this.stripes.contains(t.negate())) {
            Stripe stripe = this.stripes.get(t.negate()).get();
            return linear.sub(stripe.asLinear());
        }
        return linear;
    }

    <D extends ZenoDomain<D>> P2<D, SynthChannel> applyStripes(Zeno.Test stmt, D childState) {
        D newChildState = childState;
        VarSet vs = stmt.getExpr().getVars();
        AVLSet<Linear> affectedStripes = EMPTYSET;
        for (NumVar x : vs) {
            affectedStripes = affectedStripes.union(this.reverse.get(x).getOrElse(EMPTYSET));
        }
        SynthChannel channel = newChildState.getSynthChannel();
        if (Stripes.DEBUGTESTS) {
            System.out.println("  affected stripes: " + affectedStripes);
            System.out.println("  child: " + newChildState);
        }
        for (Linear lin : affectedStripes) {
            Stripe s = this.stripes.get(lin).get();
            Zeno.Test t = s.asEquality(lin);
            if (Stripes.DEBUGTESTS) {
                System.out.println("  evaluating test: " + t);
            }
            newChildState = newChildState.eval(t);
            if (Stripes.DEBUGTESTS) {
                System.out.println("  child: " + newChildState);
            }
            channel = channel.intersect(newChildState.getSynthChannel());
        }
        return P2.tuple2(newChildState, channel);
    }

    <D extends ZenoDomain<D>> P2<D, SynthChannel> applyNarrowingConstraints(Zeno.Test test, D childState, SynthChannel channel) {
        D newChildState = childState;
        if (this.narrowingconstraints.isEmpty()) {
            return P2.tuple2(newChildState, channel);
        }
        for (NumVar x : test.getVars()) {
            Zeno.Test t;
            StripeStateBuilder.Constraint c = this.narrowingconstraints.getOrNull(x);
            if (c == null || (t = c.asTestOrNull(childState)) == null) continue;
            if (Stripes.DEBUGTESTS) {
                System.out.println("  evaluating constraint: " + c + " as: " + t);
            }
            newChildState = newChildState.eval(t);
            if (Stripes.DEBUGTESTS) {
                System.out.println("  child: " + newChildState);
            }
            channel = channel.intersect(newChildState.getSynthChannel());
        }
        return P2.tuple2(newChildState, channel);
    }

    VarSet getLocalVariables() {
        VarSet locals = VarSet.empty();
        for (NumVar x : this.specials) {
            locals = locals.add(x);
        }
        return locals;
    }

    private void check() {
        for (P2<NumVar, AVLSet<Linear>> p2 : this.reverse) {
            AVLSet<Linear> vs = p2._2();
            NumVar var = p2._1();
            for (Linear lin : vs) {
                assert (this.stripes.contains(lin));
                Stripe special = this.stripes.getOrNull(lin);
                if (var != special.special) assert (lin.getVars().contains(var));
            }
        }
        for (P2<Comparable<NumVar>, Object> p2 : this.stripes) {
            Stripe stripe = (Stripe)p2._2();
            assert (((Linear)p2._1()).getVars().size() >= 2);
            assert (((Linear)p2._1()).getConstant().isZero());
            assert (this.reverse.get(stripe.special).get().size() == 1);
            for (Linear.Term t : (Linear)p2._1()) {
                assert (this.reverse.get(t.getId()).get().contains((Linear)p2._1()));
            }
        }
        assert (this.stripes.size() == this.specials.size());
    }
}

