/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.machine;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.abstractsyntax.memderef.SymbolicOffset;
import bindead.data.Linear;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.segments.basics.RegionAccess;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.domains.segments.warnings.BufferOverflow;
import bindead.domains.segments.warnings.FrameAccess;
import bindead.domains.segments.warnings.NonConstantStackOffset;
import bindead.domains.segments.warnings.ReturnAddressOverwritten;
import bindead.domains.segments.warnings.StackUnderflow;
import bindead.domains.segments.warnings.UnknownStackFrame;
import bindead.environment.platform.Platform;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.numeric.BigInt;
import javalx.numeric.FiniteRange;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.AVLSet;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.Type;

public class StackSegment<D extends MemoryDomain<D>>
extends Segment<D> {
    public static final String NAME = "Stack";
    private static final FiniteFactory fin = FiniteFactory.getInstance();
    private final NumVar.AddrVar stackAddr = NumVar.getSingletonAddress("activeFrame");
    private final MemVar currentBpRelative = MemVar.getVarOrFresh("currBP");
    private final NumVar currentBarrier = NumVar.getSingleton("BP|SP");
    private final MemVar currentSpRelative = MemVar.getVarOrFresh("currSP");
    private final RReilAddr currentFunction;
    private final Frame<D> currentFrame;
    private final AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>> callsites;
    private final AVLMap<RReilAddr, RReilAddr> returnsites;
    private final AVLMap<NumVar.AddrVar, FramePair<D>> inactiveFrames;
    private final AVLMap<RReilAddr, AVLSet<RReilAddr>> functions;
    private final AVLMap<RReilAddr, RReilAddr> reverse;
    public static final AVLMap<RReilAddr, NumVar.AddrVar> emptyCallsite = AVLMap.empty();

    public StackSegment() {
        this.currentFunction = RReilAddr.ZERO;
        this.currentFrame = new Frame(this);
        this.callsites = AVLMap.empty();
        this.returnsites = AVLMap.empty();
        this.inactiveFrames = AVLMap.empty();
        this.reverse = AVLMap.empty().bind(RReilAddr.ZERO, this.currentFunction);
        AVLSet<RReilAddr> functionBlocks = AVLSet.empty().add(RReilAddr.ZERO);
        this.functions = AVLMap.empty().bind(this.currentFunction, functionBlocks);
    }

    private StackSegment(RReilAddr currentFunction, Frame<D> currentFrame, AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>> callsites, AVLMap<RReilAddr, RReilAddr> returnsites, AVLMap<NumVar.AddrVar, FramePair<D>> inactive, AVLMap<RReilAddr, AVLSet<RReilAddr>> functions, AVLMap<RReilAddr, RReilAddr> reverse) {
        this.currentFunction = currentFunction;
        this.currentFrame = currentFrame;
        this.inactiveFrames = inactive;
        this.callsites = callsites;
        this.returnsites = returnsites;
        this.functions = functions;
        this.reverse = reverse;
    }

    @Override
    public P3<List<MemVar>, Boolean, D> initialize(D state) {
        state = state.introduce(this.stackAddr, Type.Address, Option.none());
        state = this.currentFrame.allocate(state);
        return P3.tuple3(new LinkedList(), Boolean.TRUE, state);
    }

    @Override
    public SegmentWithState<D> triggerAssignment(Lhs lhs, Rhs rhs, D state) {
        assert (false);
        Platform platform = state.getContext().getEnvironment().getPlatform();
        MemVar sp = MemVar.getVarOrNull(platform.getStackPointer());
        if (sp != null && lhs.getRegionId().equals(sp) && lhs.getOffset() == 0) {
            Option<NumVar> spVar = this.getStackPointer(state);
            if (spVar.isNone()) {
                return new SegmentWithState<D>(this, state);
            }
            Range offset = state.queryRange(Linear.linear(Linear.term(spVar.get()), Linear.term(BigInt.MINUSONE, this.stackAddr)));
            if (offset.isConstant() && offset.getConstantOrNull().isZero()) assert (false);
        }
        return new SegmentWithState<D>(this, state);
    }

    @Override
    public MemVarSet getChildSupportSet() {
        MemVarSet css = this.currentFrame.getChildSupportSet();
        for (P2<NumVar.AddrVar, FramePair<D>> p2 : this.inactiveFrames) {
            css = css.insertAll(p2._2().getChildSupportSet());
        }
        return css;
    }

    @Override
    public SegmentWithState<D> tryPrimitive(RReil.PrimOp prim, D state) {
        if (prim.is("currentStackFrameAddress", 1, 0)) {
            Lhs sp = prim.getOutArg(0);
            state = state.assignSymbolicAddressOf(sp, this.stackAddr);
            return new SegmentWithState<D>(this, state);
        }
        return null;
    }

    private StackSegment<D> addLocationsToCurrentFrame(RReilAddr target) {
        FiniteMap callsites = this.callsites;
        FiniteMap functions = this.functions;
        FiniteMap reverse = this.reverse;
        RReilAddr currentFunction = this.currentFunction;
        RReilAddr point = target;
        Option<RReilAddr> ownerFunction = ((AVLMap)reverse).get((RReilAddr)point);
        if (ownerFunction.isNone()) {
            AVLSet<RReilAddr> basicBlocks = functions.get(currentFunction).get();
            functions.bind(currentFunction, basicBlocks.add(point));
            reverse = ((AVLMap)reverse).bind(point, currentFunction);
        } else if (!ownerFunction.get().equals(currentFunction)) {
            RReilAddr from;
            RReilAddr to;
            if (currentFunction.base() < ownerFunction.get().base()) {
                to = ownerFunction.get();
                from = currentFunction;
            } else {
                to = currentFunction;
                from = ownerFunction.get();
            }
            currentFunction = to;
            AVLSet<RReilAddr> basicBlocks = functions.get(from).get();
            for (RReilAddr block : basicBlocks) {
                reverse = ((AVLMap)((AVLMap)reverse).remove(block)).bind(block, to);
            }
            basicBlocks = basicBlocks.union(functions.get(to).get());
            functions = ((AVLMap)functions.remove(from)).bind(to, basicBlocks);
            Option<AVLMap<RReilAddr, NumVar.AddrVar>> callsitesOpt = callsites.get(from);
            if (callsitesOpt.isSome()) {
                callsites = ((AVLMap)callsites.remove(from)).bind(to, callsitesOpt.get());
            }
        }
        return new StackSegment<D>(currentFunction, this.currentFrame, (AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>>)callsites, this.returnsites, this.inactiveFrames, (AVLMap<RReilAddr, AVLSet<RReilAddr>>)functions, (AVLMap<RReilAddr, RReilAddr>)reverse);
    }

    private boolean isCall(BigInt stackOffset, D state, ProgramPoint nextInstruction) {
        Platform platform = state.getContext().getEnvironment().getPlatform();
        BigInt offsetInBits = stackOffset.mul(BigInt.EIGHT);
        FiniteRange access = FiniteRange.of(offsetInBits, (long)platform.defaultArchitectureSize());
        Range value = state.queryRange(this.currentFrame.getDynamicRegion(), access);
        if (value != null && value.isConstant()) {
            BigInt r = value.getConstantOrNull();
            return r.isEqualTo(BigInt.of(nextInstruction.getAddress().base()));
        }
        return false;
    }

    private static boolean isReturn(BigInt stackOffset) {
        return stackOffset.isPositive();
    }

    private static boolean isTailCall(BigInt stackOffset) {
        return stackOffset.isZero();
    }

    @Override
    public SegmentWithState<D> evalJump(RReilAddr target, D state, ProgramPoint current, ProgramPoint next) {
        NumVar spVar = this.getStackPointer(state).get();
        Range offsetRange = state.queryRange(Linear.linear(Linear.term(spVar), Linear.term(BigInt.MINUSONE, this.stackAddr), Linear.term(BigInt.MINUSONE, this.currentFrame.getBarrier())));
        if (!offsetRange.isConstant()) {
            state.getContext().addWarning(new NonConstantStackOffset(spVar, offsetRange));
            return null;
        }
        BigInt offset = offsetRange.getConstantOrNull();
        if (this.isCall(offset, state, next)) {
            state = this.setInstructionPointer(target, state);
            SegmentWithState<D> pair = this.pushFrame(state, current, next, target);
            return pair;
        }
        if (StackSegment.isReturn(offset)) {
            Option<RReilAddr> callsite = this.returnsites.get(target);
            if (callsite.isNone() || !((Frame)this.currentFrame).prevFrames.contains(callsite.get())) {
                state.getContext().addWarning(new UnknownStackFrame(target));
                throw new IllegalStateException("We return to a stack frame that we have not seen before.");
            }
            D predState = this.currentFrame.getPredecessor(callsite.get(), state);
            predState = this.setInstructionPointer(target, predState);
            P2<StackSegment<D>, D> pair = this.popFrame(predState, callsite.get());
            StackSegment<D> newSegment = pair._1();
            MemoryDomain newState = (MemoryDomain)pair._2();
            newSegment = super.addLocationsToCurrentFrame(target);
            return new SegmentWithState<MemoryDomain>(newSegment, newState);
        }
        if (StackSegment.isTailCall(offset)) {
            throw new DomainStateException.UnimplementedMethodException("Handling of tail calls not yet implemented.");
        }
        D resultState = this.setInstructionPointer(target, state);
        StackSegment<D> newSegment = this.addLocationsToCurrentFrame(target);
        return new SegmentWithState<D>(newSegment, resultState);
    }

    private D setInstructionPointer(RReilAddr target, D state) {
        Platform platform = state.getContext().getEnvironment().getPlatform();
        assert (target.offset() == 0) : "Native jumps/calls cannot jump to intra-RREIL addresses.";
        MemVar ip = MemVar.getVarOrNull(platform.getInstructionPointer());
        int architectureSize = platform.defaultArchitectureSize();
        FiniteRange access = FiniteRange.of(0L, (long)(architectureSize - 1));
        Option<NumVar> ipVar = state.pickSpecificField(ip, access);
        Finite.Rlin rhs = fin.literal(architectureSize, BigInt.of(target.base()));
        state = state.evalFiniteAssign(fin.variable(architectureSize, ipVar.get()), rhs);
        return state;
    }

    private Option<NumVar> getStackPointer(D state) {
        Platform platform = state.getContext().getEnvironment().getPlatform();
        MemVar sp = MemVar.getVarOrNull(platform.getStackPointer());
        if (sp == null) {
            return Option.none();
        }
        FiniteRange access = FiniteRange.of(0L, (long)(platform.defaultArchitectureSize() - 1));
        return state.pickSpecificField(sp, access);
    }

    private SegmentWithState<D> pushFrame(D state, ProgramPoint exitPoint, ProgramPoint returnPoint, RReilAddr entryPoint) {
        FiniteMap inactiveFrames = this.inactiveFrames;
        FiniteMap callsites = this.callsites;
        FiniteMap functions = this.functions;
        FiniteMap reverse = this.reverse;
        RReilAddr currentFunction = this.currentFunction;
        FiniteMap returnsites = this.returnsites;
        if (!reverse.contains(exitPoint.getAddress())) {
            reverse = reverse.bind(exitPoint.getAddress(), currentFunction);
            AVLSet<RReilAddr> basicBlocks = functions.get(currentFunction).get();
            functions = functions.bind(currentFunction, basicBlocks.add(exitPoint.getAddress()));
            assert (basicBlocks.getMin().get().base() <= exitPoint.getAddress().base());
        }
        if (!reverse.contains(entryPoint)) {
            reverse = reverse.bind(entryPoint, entryPoint);
            functions = functions.bind(entryPoint, AVLSet.empty().add(entryPoint));
        }
        NumVar.AddrVar inactiveAddr = NumVar.freshAddress("frame_" + exitPoint.getAddress().toShortString());
        Option<NumVar> stackPointer = this.getStackPointer(state);
        if (stackPointer.isNone()) {
            throw new IllegalStateException("Stack pointer has not been initialized in the analysis.");
        }
        Platform platform = state.getContext().getEnvironment().getPlatform();
        int spSize = platform.defaultArchitectureSize();
        P2<Frame<D>, D> pair = this.currentFrame.makeInactive(exitPoint, spSize, stackPointer.get(), inactiveAddr, state);
        Frame<D> inactiveFrame = pair._1();
        state = (MemoryDomain)pair._2();
        NumVar.FlagVar flag = NumVar.freshFlag("f(" + entryPoint.toShortString() + "->" + exitPoint.getAddress().toShortString() + ")");
        Frame<D> currentFrame = new Frame<D>(this, exitPoint.getAddress(), flag);
        state = currentFrame.allocate(state, exitPoint.getAddress());
        FiniteMap currentCallsites = callsites.get(currentFunction).getOrElse(emptyCallsite);
        if (currentCallsites.contains(exitPoint.getAddress())) {
            NumVar.AddrVar frameAddr = currentCallsites.get(exitPoint.getAddress()).get();
            FramePair<D> fPair = ((AVLMap)inactiveFrames).get((NumVar.AddrVar)frameAddr).get();
            P2<D, FramePair<D>> pair2 = fPair.summarize(inactiveAddr, inactiveFrame, frameAddr, state);
            state = (MemoryDomain)pair2._1();
            fPair = pair2._2();
            inactiveFrames = ((AVLMap)inactiveFrames).bind(frameAddr, fPair);
        } else {
            inactiveFrames = ((AVLMap)inactiveFrames).bind(inactiveAddr, new FramePair<D>(inactiveFrame));
            currentCallsites = currentCallsites.bind(exitPoint.getAddress(), inactiveAddr);
            callsites = callsites.bind(currentFunction, currentCallsites);
            returnsites = returnsites.bind(returnPoint.getAddress(), exitPoint.getAddress());
        }
        currentFunction = entryPoint;
        StackSegment seg = new StackSegment(currentFunction, currentFrame, (AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>>)callsites, (AVLMap<RReilAddr, RReilAddr>)returnsites, inactiveFrames, (AVLMap<RReilAddr, AVLSet<RReilAddr>>)functions, (AVLMap<RReilAddr, RReilAddr>)reverse);
        return new SegmentWithState(seg, state);
    }

    private P2<StackSegment<D>, D> popFrame(D predState, RReilAddr callsite) {
        AVLMap<RReilAddr, AVLSet<RReilAddr>> functions = this.functions;
        AVLMap<RReilAddr, RReilAddr> reverse = this.reverse;
        Frame<Object> predFrame = this.currentFrame;
        FiniteMap inactiveFrames = this.inactiveFrames;
        FiniteMap callsites = this.callsites;
        predState = predFrame.deallocate(predState);
        RReilAddr predFunction = reverse.get(callsite).get();
        NumVar.AddrVar predAddr = callsites.get(predFunction).get().get(callsite).get();
        FramePair<Object> predFramePair = ((AVLMap)inactiveFrames).get(predAddr).get();
        if (((FramePair)predFramePair).materialized == null) {
            if (((FramePair)predFramePair).summarized == null) {
                throw new IllegalStateException("The predecessor frame was not found.");
            }
            P2<Object, FramePair<Object>> resPair = predFramePair.materialize(predAddr, predState);
            predFramePair = resPair._2();
            predState = (MemoryDomain)resPair._1();
        }
        predFrame = ((FramePair)predFramePair).materialized;
        predFramePair = predFramePair.claimMaterialized();
        inactiveFrames = ((AVLMap)inactiveFrames).bind(predAddr, predFramePair);
        Option<NumVar> stackPointer = this.getStackPointer(predState);
        if (stackPointer.isNone()) {
            throw new IllegalStateException("Stack pointer has not been initialized in the analysis.");
        }
        Platform platform = predState.getContext().getEnvironment().getPlatform();
        int spSize = platform.defaultArchitectureSize();
        P2<Frame<Object>, Object> predPair = predFrame.makeActive(spSize, stackPointer.get(), predAddr, predState);
        predFrame = predPair._1();
        predState = (MemoryDomain)predPair._2();
        AVLSet<RReilAddr> worklist = predFrame.getAllPredecessors();
        AVLSet<Object> unreachable = AVLSet.empty();
        for (P2<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>> p2 : callsites) {
            for (RReilAddr exitAddr : p2._2().keys()) {
                unreachable = unreachable.add(exitAddr);
            }
        }
        while (!worklist.isEmpty()) {
            RReilAddr next = worklist.getMax().get();
            worklist = worklist.remove(next);
            unreachable = unreachable.remove(next);
            RReilAddr rReilAddr = reverse.get(next).get();
            NumVar.AddrVar frameAddr = callsites.get(rReilAddr).get().get(next).get();
            FramePair fPair = (FramePair)((AVLMap)inactiveFrames).get(frameAddr).get();
            Frame frame = fPair.materialized;
            if (frame == null) continue;
            for (RReilAddr addr : frame.getAllPredecessors()) {
                if (!unreachable.contains(addr)) continue;
                worklist = worklist.add(addr);
            }
            frame = fPair.summarized;
            if (frame == null) continue;
            for (RReilAddr addr : frame.getAllPredecessors()) {
                if (!unreachable.contains(addr)) continue;
                worklist = worklist.add(addr);
            }
        }
        for (RReilAddr rReilAddr : unreachable) {
            RReilAddr entryAddr = reverse.get(rReilAddr).get();
            FiniteMap functionCallsites = callsites.get(entryAddr).get();
            NumVar.AddrVar var = functionCallsites.get(rReilAddr).get();
            functionCallsites = functionCallsites.remove(rReilAddr);
            callsites = callsites.bind(entryAddr, functionCallsites);
            FramePair fPair = (FramePair)((AVLMap)inactiveFrames).get(var).get();
            if (fPair.materialized != null) {
                predState = fPair.materialized.deallocate(predState);
            }
            if (fPair.summarized != null) {
                predState = fPair.summarized.deallocate(predState);
            }
            inactiveFrames = ((AVLMap)inactiveFrames).remove(var);
            predState = predState.project(var);
        }
        StackSegment<Object> seg = new StackSegment<Object>(predFunction, predFrame, (AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>>)callsites, this.returnsites, (AVLMap<NumVar.AddrVar, FramePair<Object>>)inactiveFrames, functions, reverse);
        return P2.tuple2(seg, predState);
    }

    private void derefFrame(List<RegionAccess<D>> res, AbstractPointer dRef, D state, Frame<D> frame) {
        MemVar region;
        WarningsContainer warn = state.getContext().getWarningsChannel();
        Linear barrier = Linear.linear(frame.getBarrier());
        Object dynState = null;
        try {
            dynState = dRef.calcBelowAccess(state, barrier);
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        D staticState = state;
        try {
            staticState = dRef.calcBelowAccess(staticState, Linear.ZERO);
            staticState = dRef.calcAboveAccess(staticState, barrier);
        }
        catch (Unreachable e) {
            staticState = null;
        }
        Object prevState = null;
        try {
            prevState = dRef.calcAboveAccess(state, Linear.ZERO);
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        if (dynState != null && staticState != null) {
            warn.addWarning(new BufferOverflow(dRef));
            staticState = null;
            prevState = null;
        }
        if (staticState != null && prevState != null) {
            warn.addWarning(new ReturnAddressOverwritten(dRef));
            prevState = null;
        }
        SymbolicOffset offset = new SymbolicOffset(dRef.offset);
        if (dynState != null) {
            region = frame.getDynamicRegion();
            assert (region != null);
            RegionAccess<Object> resolveRegion = new RegionAccess<Object>(new AbstractMemPointer(region, offset), new SegmentWithState<Object>((Segment<Object>)this, dynState));
            RegionAccess<Object> rdRef = resolveRegion.addOffset(barrier.negate());
            res.add(rdRef);
        }
        if (staticState != null) {
            region = frame.getStaticRegion();
            assert (region != null);
            RegionAccess<D> rdRef = new RegionAccess<D>(new AbstractMemPointer(region, offset), new SegmentWithState<D>(this, staticState));
            res.add(rdRef);
        }
        if (prevState == null) {
            return;
        }
        List<P2<RReilAddr, Object>> preds = frame.getAllPredecessors(prevState);
        if (preds.isEmpty()) {
            warn.addWarning(new StackUnderflow(dRef));
        }
        for (P2<RReilAddr, Object> pair : preds) {
            RReilAddr exitPoint = pair._1();
            RReilAddr entryPoint = this.reverse.getOrNull(exitPoint);
            NumVar.AddrVar prevAddr = this.callsites.get(entryPoint).get().get(exitPoint).get();
            FramePair<MemoryDomain> fPair = this.inactiveFrames.get(prevAddr).get();
            Frame prevFrame = ((FramePair)fPair).materialized;
            boolean descend = true;
            MemoryDomain funState = pair._2();
            StackSegment<MemoryDomain> stack = this;
            if (prevFrame == null) {
                descend = false;
                P2<MemoryDomain, FramePair<MemoryDomain>> matPair = fPair.materialize(prevAddr, funState);
                funState = matPair._1();
                FiniteMap inactive = this.inactiveFrames.bind((Object)prevAddr, matPair._2());
                stack = new StackSegment<MemoryDomain>(this.currentFunction, (Frame<MemoryDomain>)this.currentFrame, this.callsites, this.returnsites, (AVLMap<NumVar.AddrVar, FramePair<MemoryDomain>>)inactive, this.functions, this.reverse);
            }
            assert (prevFrame != null);
            AbstractPointer prevFramedRef = dRef.setAddr(prevAddr).addOffset(Linear.linear(Linear.term(prevFrame.spAtCall)));
            if (!descend) continue;
            stack.derefFrame(res, prevFramedRef, funState, prevFrame);
        }
    }

    @Override
    public List<RegionAccess<D>> dereference(Rhs.Lin sourcePointerValue, AbstractPointer dRef, D state) {
        if (dRef.isAbsolute()) {
            return null;
        }
        NumVar.AddrVar addr = dRef.address;
        if (!this.stackAddr.equalTo(addr) && !this.inactiveFrames.contains(addr)) {
            return null;
        }
        LinkedList<RegionAccess<D>> res = new LinkedList<RegionAccess<D>>();
        if (this.stackAddr.equalTo(addr)) {
            this.derefFrame(res, dRef, state, this.currentFrame);
            return res;
        }
        FramePair<D> fPair = this.inactiveFrames.getOrNull(addr);
        Frame frame = ((FramePair)fPair).materialized;
        StackSegment<D> localSegment = this;
        if (frame == null) {
            P2<D, FramePair<D>> matPair = fPair.materialize(addr, state);
            frame = ((FramePair)matPair._2()).materialized;
            state = (MemoryDomain)matPair._1();
            FiniteMap inactive = this.inactiveFrames.bind((Object)addr, matPair._2());
            localSegment = new StackSegment<D>(this.currentFunction, this.currentFrame, this.callsites, this.returnsites, inactive, this.functions, this.reverse);
        }
        localSegment.derefFrame(res, dRef, state, frame);
        return res;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("parents: ");
        builder.append(this.currentFrame.getAllPredecessors());
        if (!this.callsites.isEmpty()) {
            builder.append("; ");
            builder.append("callsites: ");
            builder.append(this.callsites);
        }
        if (!this.reverse.isEmpty()) {
            builder.append("; ");
            builder.append("frames: ");
            builder.append(this.functions);
        }
        return StringHelpers.indentMultiline("Stack: ", builder.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SegCompatibleState<D> makeCompatible(Segment<D> otherRaw, D state, D otherState) {
        void var15_32;
        void var13_19;
        StackSegment other = (StackSegment)otherRaw;
        FiniteMap functions = this.functions;
        FiniteMap reverse = this.reverse;
        RReilAddr currentFunction = this.currentFunction;
        FiniteMap thisCallsites = this.callsites;
        FiniteMap otherCallsites = other.callsites;
        AVLMap<RReilAddr, RReilAddr> returnsites = this.returnsites.union(other.returnsites);
        ThreeWaySplit<AVLMap<RReilAddr, AVLSet<RReilAddr>>> splitFuncs = ((AVLMap)functions).split(other.functions);
        for (P2<RReilAddr, AVLSet<RReilAddr>> p2 : splitFuncs.inBothButDiffering()) {
            AVLSet<RReilAddr> blocks = other.functions.get(p2._1()).get();
            for (RReilAddr addr : blocks.difference(p2._2())) {
                reverse = ((AVLMap)reverse).bind(addr, p2._1());
            }
            functions = ((AVLMap)functions).bind(p2._1(), p2._2().union(blocks));
        }
        for (P2<RReilAddr, AVLSet<RReilAddr>> p2 : splitFuncs.onlyInSecond()) {
            RReilAddr otherECR = p2._1();
            AVLSet<RReilAddr> aVLSet = p2._2();
            if (((AVLMap)reverse).contains((RReilAddr)otherECR)) {
                RReilAddr thisECR = ((AVLMap)reverse).get((RReilAddr)p2._1()).get();
                AVLSet aVLSet2 = (AVLSet)((AVLMap)functions).get(thisECR).get();
                AVLSet<RReilAddr> union = aVLSet2.union(aVLSet);
                if (otherECR.base() < thisECR.base()) {
                    for (RReilAddr addr : union) {
                        reverse = ((AVLMap)reverse).bind(addr, otherECR);
                    }
                    functions = ((AVLMap)((AVLMap)functions).remove(thisECR)).bind(otherECR, union);
                    thisCallsites = ((AVLMap)((AVLMap)thisCallsites).remove(thisECR)).bind(otherECR, ((AVLMap)thisCallsites).get(thisECR).get());
                    continue;
                }
                for (RReilAddr addr : aVLSet.difference(aVLSet2)) {
                    reverse = ((AVLMap)reverse).bind(thisECR, addr);
                }
                functions = ((AVLMap)functions).bind(thisECR, union);
                otherCallsites = ((AVLMap)((AVLMap)otherCallsites).remove(otherECR)).bind(thisECR, ((AVLMap)otherCallsites).get(otherECR).get());
                continue;
            }
            for (RReilAddr rReilAddr : aVLSet) {
                reverse = ((AVLMap)reverse).bind(rReilAddr, otherECR);
            }
            functions = ((AVLMap)functions).bind(otherECR, aVLSet);
            thisCallsites = ((AVLMap)thisCallsites).bind(otherECR, emptyCallsite);
        }
        for (P2<RReilAddr, AVLSet<RReilAddr>> p2 : splitFuncs.onlyInFirst()) {
            RReilAddr fstECR = p2._1();
            AVLSet<RReilAddr> aVLSet = p2._2();
            Option<RReilAddr> sndECROpt = other.reverse.get(fstECR);
            if (sndECROpt.isSome()) {
                RReilAddr rReilAddr = sndECROpt.get();
                assert (!fstECR.equals(rReilAddr));
                AVLSet sndBlocks = (AVLSet)((AVLMap)functions).get(rReilAddr).get();
                AVLSet<RReilAddr> union = aVLSet.union(sndBlocks);
                for (RReilAddr addr : union) {
                    reverse = ((AVLMap)reverse).bind(addr, fstECR);
                }
                if (fstECR.base() < rReilAddr.base()) {
                    for (RReilAddr addr : union) {
                        reverse = ((AVLMap)reverse).bind(addr, fstECR);
                    }
                    functions = ((AVLMap)functions).bind(fstECR, union);
                    thisCallsites = ((AVLMap)((AVLMap)thisCallsites).remove(rReilAddr)).bind(fstECR, ((AVLMap)thisCallsites).get(rReilAddr).get());
                    otherCallsites = ((AVLMap)((AVLMap)otherCallsites).remove(rReilAddr)).bind(fstECR, ((AVLMap)otherCallsites).get(rReilAddr).get());
                    continue;
                }
                for (RReilAddr addr : union) {
                    reverse = ((AVLMap)reverse).bind(addr, rReilAddr);
                }
                functions = ((AVLMap)functions).bind(rReilAddr, union);
                continue;
            }
            otherCallsites = ((AVLMap)otherCallsites).bind(fstECR, emptyCallsite);
        }
        ThreeWaySplit<AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>>> splitCallsites = ((AVLMap)thisCallsites).split(otherCallsites);
        AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>> aVLMap = splitCallsites.inBothButDiffering();
        for (P2<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>> p2 : splitCallsites.onlyInFirst()) {
            otherCallsites = ((AVLMap)otherCallsites).bind(p2._1(), emptyCallsite);
        }
        for (P2<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>> p2 : splitCallsites.onlyInSecond()) {
            thisCallsites = ((AVLMap)thisCallsites).bind(p2._1(), emptyCallsite);
            FiniteMap finiteMap = var13_19.bind(p2._1(), emptyCallsite);
        }
        FiniteMap callsites = thisCallsites;
        AVLMap<NumVar.AddrVar, FramePair<D>> aVLMap2 = this.inactiveFrames;
        for (P2 p2 : var13_19) {
            FramePair<D> fPair;
            NumVar.AddrVar var;
            FiniteMap thisExits = (AVLMap)p2._2();
            AVLMap otherExits = (AVLMap)((AVLMap)otherCallsites).get((RReilAddr)p2._1()).get();
            ThreeWaySplit splitExits = ((AVLMap)thisExits).split(otherExits);
            for (P2 call : splitExits.inBothButDiffering()) {
                P3<D, D, FramePair<D>> merged;
                FramePair<D> otherPair;
                FramePair thisPair;
                NumVar.AddrVar thisVar = (NumVar.AddrVar)call._2();
                NumVar.AddrVar otherVar = (NumVar.AddrVar)otherExits.get(call._1()).get();
                if (thisVar.getStamp() < otherVar.getStamp()) {
                    otherState = otherState.substitute(otherVar, thisVar);
                    thisPair = (FramePair)var15_32.get(thisVar).get();
                    otherPair = other.inactiveFrames.get(otherVar).get();
                    merged = FramePair.merge(state, thisPair, otherState, otherPair);
                    state = (MemoryDomain)merged._1();
                    otherState = (MemoryDomain)merged._2();
                    FiniteMap finiteMap = var15_32.bind(thisVar, merged._3());
                    continue;
                }
                if (!thisVar.equalTo(otherVar)) {
                    state = state.substitute(thisVar, otherVar);
                    thisExits = ((AVLMap)thisExits).bind(call._1(), otherVar);
                }
                thisPair = (FramePair)var15_32.get(thisVar).get();
                otherPair = other.inactiveFrames.get(otherVar).get();
                merged = FramePair.merge(state, thisPair, otherState, otherPair);
                state = (MemoryDomain)merged._1();
                otherState = (MemoryDomain)merged._2();
                FiniteMap finiteMap = ((AVLMap)var15_32.remove(thisVar)).bind(otherVar, merged._3());
            }
            for (P2 call : splitExits.onlyInFirst()) {
                var = (NumVar.AddrVar)call._2();
                otherState = otherState.introduce(var, Type.Address, Option.none());
                fPair = (FramePair<D>)var15_32.get(var).get();
                otherState = fPair.allocate(otherState);
            }
            for (P2 call : splitExits.onlyInSecond()) {
                var = (NumVar.AddrVar)call._2();
                state = state.introduce(var, Type.Address, Option.none());
                fPair = other.inactiveFrames.get(var).get();
                state = fPair.allocate(state);
                FiniteMap finiteMap = var15_32.bind(var, fPair);
                thisExits = ((AVLMap)thisExits).bind(call._1(), var);
            }
            callsites = ((AVLMap)callsites).bind(p2._1(), thisExits);
        }
        P3<Object, Object, Frame<Object>> triple = Frame.merge(state, this.currentFrame, otherState, other.currentFrame);
        state = (MemoryDomain)triple._1();
        otherState = (MemoryDomain)triple._2();
        Frame<Object> frame = triple._3();
        StackSegment<Object> seg = new StackSegment<Object>(currentFunction, frame, (AVLMap<RReilAddr, AVLMap<RReilAddr, NumVar.AddrVar>>)callsites, returnsites, (AVLMap<NumVar.AddrVar, FramePair<Object>>)var15_32, (AVLMap<RReilAddr, AVLSet<RReilAddr>>)functions, (AVLMap<RReilAddr, RReilAddr>)reverse);
        return new SegCompatibleState<Object>(seg, state, otherState);
    }

    @Override
    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
    }

    private static class Frame<D extends MemoryDomain<D>> {
        private static final AVLMap<RReilAddr, NumVar.FlagVar> noPreds = AVLMap.empty();
        private final StackSegment<D> stack;
        private final MemVar bpRelative;
        private final NumVar barrier;
        private final MemVar spRelative;
        private final NumVar spAtCall;
        private final AVLMap<RReilAddr, NumVar.FlagVar> prevFrames;

        private Frame(StackSegment<D> stack, MemVar bpRelative, NumVar barrier, MemVar spRelative, AVLMap<RReilAddr, NumVar.FlagVar> prevFrames, NumVar spAtCall) {
            this.stack = stack;
            this.bpRelative = bpRelative;
            this.barrier = barrier;
            this.spRelative = spRelative;
            this.prevFrames = prevFrames;
            this.spAtCall = spAtCall;
        }

        public Frame(StackSegment<D> stack) {
            this(stack, ((StackSegment)stack).currentBpRelative, ((StackSegment)stack).currentBarrier, ((StackSegment)stack).currentSpRelative, noPreds, null);
        }

        public Frame(StackSegment<D> stack, RReilAddr callsite, NumVar.FlagVar flag) {
            this(stack, ((StackSegment)stack).currentBpRelative, ((StackSegment)stack).currentBarrier, ((StackSegment)stack).currentSpRelative, (AVLMap<RReilAddr, NumVar.FlagVar>)noPreds.bind((Object)callsite, (Object)flag), null);
        }

        public MemVarSet getChildSupportSet() {
            return MemVarSet.of(this.bpRelative, this.spRelative);
        }

        public P2<Frame<D>, D> makeInactive(ProgramPoint entryPoint, int spSize, NumVar spVar, NumVar.AddrVar frameAddr, D state) {
            assert (this.spAtCall == null);
            String pos = entryPoint.getAddress().toShortString();
            MemVar newBpRelative = MemVar.fresh("BP@" + pos);
            NumVar newBarrier = NumVar.fresh("BP|SP@" + pos);
            MemVar newSpRelative = MemVar.fresh("SP@" + pos);
            NumVar newSpAtCall = NumVar.fresh("SPdiff@" + pos);
            state = state.substituteRegion(this.bpRelative, newBpRelative);
            state = state.substitute(this.barrier, newBarrier);
            state = state.substituteRegion(this.spRelative, newSpRelative);
            FiniteMap newPrevFrames = noPreds;
            for (P2<RReilAddr, NumVar.FlagVar> p2 : this.prevFrames) {
                NumVar.FlagVar flag = NumVar.freshFlag("f(" + pos + "->" + p2._1().toShortString() + ")");
                state = state.substitute(p2._2(), flag);
                newPrevFrames = newPrevFrames.bind(p2._1(), flag);
            }
            state = state.introduce(newSpAtCall, Type.Zeno, Option.none());
            Linear spOffset = Linear.linear(Linear.term(spVar), Linear.term(BigInt.MINUSONE, ((StackSegment)this.stack).stackAddr));
            state = state.evalFiniteAssign(fin.variable(spSize, newSpAtCall), fin.linear(spSize, spOffset));
            state = state.substitute(((StackSegment)this.stack).stackAddr, frameAddr);
            state = state.introduce(((StackSegment)this.stack).stackAddr, Type.Address, Option.none());
            state = state.evalFiniteAssign(fin.variable(spSize, spVar), fin.linear(spSize, Linear.linear(((StackSegment)this.stack).stackAddr)));
            Frame<D> frame = new Frame<D>(this.stack, newBpRelative, newBarrier, newSpRelative, (AVLMap<RReilAddr, NumVar.FlagVar>)newPrevFrames, newSpAtCall);
            return P2.tuple2(frame, state);
        }

        public P2<Frame<D>, D> makeActive(int spSize, NumVar spVar, NumVar.AddrVar frameAddr, D state) {
            Linear spTerm = Linear.linear(Linear.term(spVar), Linear.term(BigInt.MINUSONE, ((StackSegment)this.stack).stackAddr));
            state = state.evalFiniteAssign(fin.variable(spSize, spVar), fin.linear(spSize, spTerm));
            state = state.project(((StackSegment)this.stack).stackAddr);
            state = state.substitute(frameAddr, ((StackSegment)this.stack).stackAddr);
            state = state.introduce(frameAddr, Type.Address, Option.none());
            spTerm = Linear.linear(Linear.term(((StackSegment)this.stack).stackAddr), Linear.term(this.spAtCall), Linear.term(spVar));
            state = state.evalFiniteAssign(fin.variable(spSize, spVar), fin.linear(spSize, spTerm));
            state = state.substituteRegion(this.bpRelative, ((StackSegment)this.stack).currentBpRelative);
            state = state.substitute(this.barrier, ((StackSegment)this.stack).currentBarrier);
            state = state.substituteRegion(this.spRelative, ((StackSegment)this.stack).currentSpRelative);
            state = state.project(this.spAtCall);
            Frame<D> newFrame = new Frame<D>(this.stack, ((StackSegment)this.stack).currentBpRelative, ((StackSegment)this.stack).currentBarrier, ((StackSegment)this.stack).currentSpRelative, this.prevFrames, null);
            return P2.tuple2(newFrame, state);
        }

        public P2<Frame<D>, D> fold(Frame<D> other, D state) {
            assert (false);
            return P2.tuple2(other, state);
        }

        public P2<Frame<D>, D> expand(D state) {
            assert (false);
            return P2.tuple2(this, state);
        }

        public D getPredecessor(RReilAddr callsite, D domainState) {
            assert (this.prevFrames.contains(callsite));
            D state = domainState;
            for (P2<RReilAddr, NumVar.FlagVar> p2 : this.prevFrames) {
                try {
                    if (p2._1().equals(callsite)) {
                        state = state.eval(fin.equalTo(1, Linear.linear(p2._2()), Linear.ONE));
                        continue;
                    }
                    state = state.eval(fin.equalTo(1, Linear.linear(p2._2()), Linear.ZERO));
                }
                catch (Unreachable _) {
                    state.getContext().addWarning(new FrameAccess(p2._2()));
                }
            }
            return state;
        }

        public List<P2<RReilAddr, D>> getAllPredecessors(D domainState) {
            LinkedList<P2<RReilAddr, D>> res = new LinkedList<P2<RReilAddr, D>>();
            for (RReilAddr callsite : this.getAllPredecessors()) {
                D predState = this.getPredecessor(callsite, domainState);
                res.add(P2.tuple2(callsite, predState));
            }
            return res;
        }

        public AVLSet<RReilAddr> getAllPredecessors() {
            AVLSet<RReilAddr> res = AVLSet.empty();
            for (P2<RReilAddr, NumVar.FlagVar> p2 : this.prevFrames) {
                res = res.add(p2._1());
            }
            return res;
        }

        public NumVar getBarrier() {
            return this.barrier;
        }

        public MemVar getDynamicRegion() {
            return this.spRelative;
        }

        public MemVar getStaticRegion() {
            return this.bpRelative;
        }

        public static <D extends MemoryDomain<D>> P3<D, D, Frame<D>> merge(D fstDom, Frame<D> fst, D sndDom, Frame<D> snd) {
            MemVar spRelative;
            NumVar barrier;
            MemVar bpRelative;
            if (fst == snd) {
                return P3.tuple3(fstDom, sndDom, fst);
            }
            switch (fst.bpRelative.compareTo(snd.bpRelative)) {
                case 0: {
                    bpRelative = fst.bpRelative;
                    break;
                }
                case 1: {
                    bpRelative = snd.bpRelative;
                    fstDom = fstDom.substituteRegion(fst.bpRelative, bpRelative);
                    break;
                }
                default: {
                    bpRelative = fst.bpRelative;
                    sndDom = sndDom.substituteRegion(snd.bpRelative, bpRelative);
                }
            }
            switch (fst.barrier.compareTo(snd.barrier)) {
                case 0: {
                    barrier = fst.barrier;
                    break;
                }
                case 1: {
                    barrier = snd.barrier;
                    fstDom = fstDom.substitute(fst.barrier, snd.barrier);
                    break;
                }
                default: {
                    barrier = fst.barrier;
                    sndDom = sndDom.substitute(snd.barrier, fst.barrier);
                }
            }
            switch (fst.spRelative.compareTo(snd.spRelative)) {
                case 0: {
                    spRelative = fst.spRelative;
                    break;
                }
                case 1: {
                    spRelative = snd.spRelative;
                    fstDom = fstDom.substituteRegion(fst.spRelative, spRelative);
                    break;
                }
                default: {
                    spRelative = fst.spRelative;
                    sndDom = sndDom.substituteRegion(snd.spRelative, spRelative);
                }
            }
            ThreeWaySplit<AVLMap<RReilAddr, NumVar.FlagVar>> prevSplit = fst.prevFrames.split(snd.prevFrames);
            FiniteMap prevFrames = fst.prevFrames;
            for (P2<RReilAddr, NumVar.FlagVar> p2 : prevSplit.inBothButDiffering()) {
                NumVar.FlagVar fstFlag = fst.prevFrames.get(p2._1()).get();
                NumVar.FlagVar sndFlag = snd.prevFrames.get(p2._1()).get();
                assert (fstFlag.equalTo(p2._2()));
                if (fstFlag.compareTo(sndFlag) < 0) {
                    sndDom = sndDom.substitute(sndFlag, fstFlag);
                    continue;
                }
                fstDom = fstDom.substitute(fstFlag, sndFlag);
                prevFrames = prevFrames.bind(p2._1(), sndFlag);
            }
            for (P2<RReilAddr, NumVar.FlagVar> p2 : prevSplit.onlyInFirst()) {
                sndDom = sndDom.introduce(p2._2(), Type.Bool, Option.some(BigInt.ZERO));
            }
            for (P2<RReilAddr, NumVar.FlagVar> p2 : prevSplit.onlyInSecond()) {
                fstDom = fstDom.introduce(p2._2(), Type.Bool, Option.some(BigInt.ZERO));
                prevFrames = prevFrames.bind(p2._1(), p2._2());
            }
            NumVar spAtCall = null;
            if (fst.spAtCall != null) {
                assert (snd.spAtCall != null);
                switch (fst.spAtCall.compareTo(snd.spAtCall)) {
                    case 0: {
                        spAtCall = fst.spAtCall;
                        break;
                    }
                    case 1: {
                        spAtCall = snd.spAtCall;
                        fstDom = fstDom.substitute(fst.spAtCall, snd.spAtCall);
                        break;
                    }
                    default: {
                        spAtCall = fst.spAtCall;
                        sndDom = sndDom.substitute(snd.spAtCall, fst.spAtCall);
                    }
                }
            }
            assert (((StackSegment)fst.stack).stackAddr == ((StackSegment)snd.stack).stackAddr);
            assert (((StackSegment)fst.stack).currentBpRelative == ((StackSegment)snd.stack).currentBpRelative);
            assert (((StackSegment)fst.stack).currentBarrier == ((StackSegment)snd.stack).currentBarrier);
            assert (((StackSegment)fst.stack).currentSpRelative == ((StackSegment)snd.stack).currentSpRelative);
            Frame<D> frame = new Frame<D>(fst.stack, bpRelative, barrier, spRelative, (AVLMap<RReilAddr, NumVar.FlagVar>)prevFrames, spAtCall);
            return P3.tuple3(fstDom, sndDom, frame);
        }

        public D allocate(D state, RReilAddr prevFrame) {
            state = state.introduceRegion(this.bpRelative, RegionCtx.EMPTYSTICKY);
            state = state.introduceRegion(this.spRelative, RegionCtx.EMPTYSTICKY);
            state = state.introduce(this.barrier, Type.Zeno, Option.some(BigInt.ZERO));
            for (P2<RReilAddr, NumVar.FlagVar> p2 : this.prevFrames) {
                BigInt flagVal = prevFrame != null && p2._1().equals(prevFrame) ? BigInt.ONE : BigInt.ZERO;
                state = state.introduce(p2._2(), Type.Bool, Option.some(flagVal));
            }
            if (this.spAtCall != null) {
                state = state.introduce(this.spAtCall, Type.Zeno, Option.none());
            }
            return state;
        }

        public D allocate(D state) {
            return this.allocate(state, null);
        }

        public D deallocate(D state) {
            state = state.projectRegion(this.bpRelative);
            state = state.projectRegion(this.spRelative);
            state = state.project(this.barrier);
            for (P2<RReilAddr, NumVar.FlagVar> p2 : this.prevFrames) {
                state = state.project(p2._2());
            }
            if (this.spAtCall != null) {
                state = state.project(this.spAtCall);
            }
            return state;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            builder.append(this.bpRelative);
            builder.append(",");
            builder.append(this.barrier);
            builder.append(",");
            builder.append(this.spRelative);
            if (this.spAtCall != null) {
                builder.append(",");
                builder.append(this.spAtCall);
            }
            builder.append(")");
            return builder.toString();
        }
    }

    private static class FramePair<D extends MemoryDomain<D>> {
        private final Frame<D> materialized;
        private final Frame<D> summarized;

        public FramePair(Frame<D> f) {
            this.materialized = f;
            this.summarized = null;
        }

        private FramePair(Frame<D> mat, Frame<D> sum) {
            this.materialized = mat;
            this.summarized = sum;
        }

        public P2<D, FramePair<D>> summarize(NumVar.AddrVar inactiveAddr, Frame<D> inactiveFrame, NumVar.AddrVar frameAddr, D state) {
            Frame<D> resMat = this.materialized;
            Frame<D> resSum = this.summarized;
            if (resSum == null) {
                resSum = resMat;
                resMat = inactiveFrame;
                state = state.substitute(inactiveAddr, frameAddr);
            } else if (resMat != null) {
                P2<Frame<D>, D> pair = resSum.fold(resMat, state);
                resSum = pair._1();
                resMat = inactiveFrame;
                state = (MemoryDomain)pair._2();
            }
            FramePair<D> res = new FramePair<D>(resMat, resSum);
            return P2.tuple2(state, res);
        }

        public P2<D, FramePair<D>> materialize(NumVar.AddrVar frameAddr, D state) {
            Frame<D> prevMat = this.materialized;
            P2<Frame<D>, D> pair = this.summarized.expand(state);
            Frame<D> resMat = pair._1();
            Frame<D> resSum = this.summarized;
            state = (MemoryDomain)pair._2();
            if (prevMat != null) {
                P2<Frame<D>, D> sumPair = this.summarized.fold(prevMat, state);
                resSum = sumPair._1();
                state = (MemoryDomain)sumPair._2();
            }
            FramePair<D> res = new FramePair<D>(resMat, resSum);
            return P2.tuple2(state, res);
        }

        public static <D extends MemoryDomain<D>> P3<D, D, FramePair<D>> merge(D fstDom, FramePair<D> fst, D sndDom, FramePair<D> snd) {
            P2<Frame<D>, D> pair;
            Frame<D> fstMat = fst.materialized;
            Frame<D> sndMat = snd.materialized;
            Frame<D> fstSum = fst.summarized;
            Frame<D> sndSum = snd.summarized;
            if (fstMat != null && fstSum != null && sndMat != null && sndSum != null) {
                P3<D, D, Frame<D>> matTriple = Frame.merge(fstDom, fstMat, sndDom, sndMat);
                P3<D, D, Frame<D>> sumTriple = Frame.merge(matTriple._1(), fstSum, matTriple._2(), sndSum);
                FramePair<D> res = new FramePair<D>(matTriple._3(), sumTriple._3());
                return P3.tuple3(sumTriple._1(), sumTriple._2(), res);
            }
            if (fstMat != null && fstSum == null && sndMat != null && sndSum == null) {
                P3<D, D, Frame<D>> matTriple = Frame.merge(fstDom, fstMat, sndDom, sndMat);
                FramePair<D> res = new FramePair<D>(matTriple._3(), null);
                return P3.tuple3(matTriple._1(), matTriple._2(), res);
            }
            if (fstSum == null) {
                fstSum = fstMat;
            } else if (fstMat != null) {
                pair = fstSum.fold(fstMat, fstDom);
                fstSum = pair._1();
                fstDom = (MemoryDomain)pair._2();
            }
            if (sndSum == null) {
                sndSum = sndMat;
            } else if (sndMat != null) {
                pair = sndSum.fold(sndMat, sndDom);
                sndSum = pair._1();
                sndDom = (MemoryDomain)pair._2();
            }
            P3<D, D, Frame<D>> sumTriple = Frame.merge(fstDom, fstSum, sndDom, sndSum);
            FramePair<D> res = new FramePair<D>(null, sumTriple._3());
            return P3.tuple3(sumTriple._1(), sumTriple._2(), res);
        }

        public D allocate(D state) {
            if (this.materialized != null) {
                state = this.materialized.allocate(state);
            }
            if (this.summarized != null) {
                state = this.summarized.allocate(state);
            }
            return state;
        }

        public FramePair<D> claimMaterialized() {
            return new FramePair<D>(null, this.summarized);
        }

        public String toString() {
            String res = "<mat=";
            res = this.materialized == null ? res + "no" : res + "callers:" + ((Frame)this.materialized).prevFrames.size();
            res = res + ",sum=";
            res = this.summarized == null ? res + "no" : res + "yes";
            return res + ">";
        }

        public MemVarSet getChildSupportSet() {
            MemVarSet css = MemVarSet.empty();
            if (this.materialized != null) {
                css = css.insertAll(this.materialized.getChildSupportSet());
            }
            if (this.summarized != null) {
                css = css.insertAll(this.summarized.getChildSupportSet());
            }
            return css;
        }
    }
}

