/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.heap.Connector;
import bindead.domains.segments.heap.ConnectorData;
import bindead.domains.segments.heap.ConnectorId;
import bindead.domains.segments.heap.ConnectorSet;
import bindead.domains.segments.heap.HeapPartitioning;
import bindead.domains.segments.heap.HeapRegion;
import bindead.domains.segments.heap.HeapSegBuilder;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;
import rreil.lang.MemVar;
import rreil.lang.util.Type;

public class MakeHeapCompatibleWorker<D extends MemoryDomain<D>> {
    final HeapSegBuilder<D> first;
    final HeapSegBuilder<D> second;

    public MakeHeapCompatibleWorker(HeapSegBuilder<D> first, HeapSegBuilder<D> second) {
        this.first = first;
        this.second = second;
    }

    SegCompatibleState<D> makeCompatible() {
        this.movePartitionsInSecondToCompatiblePosition();
        assert (this.first.seg.connectorsAreSane());
        assert (this.second.seg.connectorsAreSane());
        this.makeRegionsCompatible();
        this.makeEdgeNodesCompatible();
        this.makeKnownRegionsCompatible();
        assert (this.first.seg.connectorsAreSane());
        assert (this.second.seg.connectorsAreSane());
        assert (this.first.seg.allKnownRegions.containsTheSameAs(this.second.seg.allKnownRegions));
        return new SegCompatibleState(this.first.seg, this.first.child, this.second.child);
    }

    private void movePartitionsInSecondToCompatiblePosition() {
        HeapPartitioning thisPartitions = this.first.seg.partition(this.first.child);
        HeapPartitioning otherPartitions = this.second.seg.partition(this.second.child);
        block0: for (MemVarSet mvs : otherPartitions.plist) {
            if (mvs.size() != 1) continue;
            MemVar fromVar = mvs.getMin().get();
            MemVarSet regs = otherPartitions.heapToRegs.get(fromVar).get();
            HeapRegion regionInSecond = this.second.seg.getRegion(fromVar);
            for (P2<MemVar, MemVarSet> p2 : thisPartitions.heapToRegs) {
                if (!p2._2().containsTheSameAs(regs) || otherPartitions.heapToRegs.contains(p2._1())) continue;
                HeapRegion regionInFirst = this.first.seg.getRegion(p2._1());
                this.second.renameRegion(regionInSecond.memId, regionInSecond.address, regionInFirst.memId, regionInFirst.address);
                continue block0;
            }
        }
    }

    private void makeKnownRegionsCompatible() {
        this.first.seg = this.first.seg.addKnownRegions(this.second.seg.allKnownRegions);
        this.second.seg = this.second.seg.addKnownRegions(this.first.seg.allKnownRegions);
    }

    void makeEdgeNodesCompatible() {
        ThreeWaySplit<ConnectorSet> es = this.first.seg.connectors.split(this.second.seg.connectors);
        for (Connector en : es.onlyInFirst()) {
            this.copyAndPasteConnector(this.second, this.first, en);
        }
        for (Connector en : es.onlyInSecond()) {
            this.copyAndPasteConnector(this.first, this.second, en);
        }
        for (Connector en : es.inBothButDiffering()) {
            ConnectorData secondData = this.second.seg.connectors.get((ConnectorId)en.id).data;
            ConnectorData firstData = en.data;
            this.second.child = this.second.child.substituteRegion(secondData.src, firstData.src);
            this.second.child = this.second.child.substituteRegion(secondData.tgt, firstData.tgt);
        }
    }

    private void copyAndPasteConnector(HeapSegBuilder<D> to, HeapSegBuilder<D> from, Connector en) {
        boolean CNP = true;
        to.child = to.child.copyAndPaste(MemVarSet.of(en.data.src, en.data.tgt), from.child);
        to.seg = to.seg.bindConnector(en.id, en.data);
    }

    void makeRegionsCompatible() {
        ThreeWaySplit<AVLMap<NumVar.AddrVar, HeapRegion>> s = this.first.seg.heapRegions.byAddress.split(this.second.seg.heapRegions.byAddress);
        for (HeapRegion e : s.onlyInFirst().values()) {
            MakeHeapCompatibleWorker.addDummyRegion(this.second, e, this.first);
        }
        for (HeapRegion e : s.onlyInSecond().values()) {
            MakeHeapCompatibleWorker.addDummyRegion(this.first, e, this.second);
        }
        for (HeapRegion thisSeg : s.inBothButDiffering().values()) {
            HeapRegion otherSeg = this.second.seg.heapRegions.get(thisSeg.address);
            assert (thisSeg.memId.equals(otherSeg.memId));
            if (thisSeg.isSummary && !otherSeg.isSummary) {
                this.second.seg = this.second.seg.bindRegion(otherSeg.turnIntoSummary());
                continue;
            }
            if (thisSeg.isSummary || !otherSeg.isSummary) continue;
            this.first.seg = this.first.seg.bindRegion(thisSeg.turnIntoSummary());
        }
    }

    private static <D extends MemoryDomain<D>> void addDummyRegion(HeapSegBuilder<D> builder, HeapRegion e, HeapSegBuilder<D> otherBuilder) {
        builder.child = builder.child.introduce(e.address, Type.Address, Option.none());
        builder.child = builder.child.copyAndPaste(MemVarSet.of(e.memId), otherBuilder.child);
        builder.seg = builder.seg.bindRegion(e);
    }
}

