/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments.heap;

import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.abstractsyntax.memderef.SymbolicOffset;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.pointsto.PointsToProperties;
import bindead.domains.segments.basics.RegionAccess;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.domains.segments.heap.Connector;
import bindead.domains.segments.heap.ConnectorData;
import bindead.domains.segments.heap.ConnectorId;
import bindead.domains.segments.heap.ConnectorSet;
import bindead.domains.segments.heap.HeapPartitioning;
import bindead.domains.segments.heap.HeapRegion;
import bindead.domains.segments.heap.HeapRegionMap;
import bindead.domains.segments.heap.HeapSegBuilder;
import bindead.domains.segments.heap.MakeHeapCompatibleWorker;
import bindead.domains.segments.heap.PathString;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.Unreachable;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Range;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.Rhs;
import rreil.lang.util.Type;

public class HeapSegment<D extends MemoryDomain<D>>
extends Segment<D> {
    public static final String NAME = "Heap";
    final boolean DEBUG;
    final HeapRegionMap heapRegions;
    final MemVarSet allKnownRegions;
    final ConnectorSet connectors;

    public HeapSegment() {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.heapRegions = HeapRegionMap.empty();
        this.allKnownRegions = MemVarSet.empty();
        this.connectors = ConnectorSet.empty();
    }

    HeapSegment(HeapRegionMap a, ConnectorSet ens, MemVarSet regs) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.heapRegions = a;
        this.allKnownRegions = regs;
        this.connectors = ens;
    }

    void msg(String s) {
        if (this.DEBUG) {
            System.out.println("\nHeapSegment:\n" + s);
        }
    }

    private void msgs(String s) {
        if (this.DEBUG) {
            System.out.println("\nHeapSegment:\n" + s);
            System.out.println("\nin state:\n" + this);
        }
    }

    @Override
    public P3<List<MemVar>, Boolean, D> initialize(D state) {
        return P3.tuple3(new LinkedList(), Boolean.FALSE, state);
    }

    @Override
    public SegmentWithState<D> triggerAssignment(Lhs lhs, Rhs rhs, D state) {
        throw new DomainStateException.InvariantViolationException();
    }

    public HeapRegion getRegion(MemVar region) {
        return this.heapRegions.get(region);
    }

    @Override
    public List<RegionAccess<D>> dereference(Rhs.Lin fieldThatPoints, AbstractPointer pointer, D state) {
        if (!this.responsibleFor(pointer)) {
            return null;
        }
        this.checkOffset(pointer, state);
        if (this.isSummary(pointer.address)) {
            return this.dereferenceSummaryNG(fieldThatPoints, pointer, state);
        }
        return this.dereferenceConcreteNG(fieldThatPoints, pointer, state);
    }

    private boolean isSummary(NumVar.AddrVar address) {
        return this.heapRegions.get((NumVar.AddrVar)address).isSummary;
    }

    private List<RegionAccess<D>> dereferenceConcreteNG(Rhs.Lin fieldThatPoints, AbstractPointer pointer, D state) {
        LinkedList<RegionAccess<D>> res = new LinkedList<RegionAccess<D>>();
        try {
            HeapRegion accessedRegion = this.heapRegions.get(pointer.address);
            HeapSegBuilder<D> hsb2 = new HeapSegBuilder<D>(this, state);
            hsb2.assumeEdgeNG(fieldThatPoints, accessedRegion);
            AbstractMemPointer mp = new AbstractMemPointer(accessedRegion.memId, new SymbolicOffset(pointer.offset));
            res.add(new RegionAccess<D>(mp, hsb2.build()));
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        return res;
    }

    private List<RegionAccess<D>> dereferenceSummaryNG(Rhs.Lin fieldThatPoints, AbstractPointer pointer, D state) {
        HeapSegBuilder hsb22;
        LinkedList<RegionAccess<D>> res = new LinkedList<RegionAccess<D>>();
        HeapRegion summary = this.heapRegions.get(pointer.address);
        HeapSegBuilder<D> hsb = new HeapSegBuilder<D>(this, state);
        HeapRegion concrete = hsb.expandNG(summary);
        SegmentWithState<D> built = hsb.build();
        hsb.msg("expanded");
        AbstractMemPointer abstractMemPointer = this.rebasePointer(pointer, concrete);
        try {
            hsb22 = new HeapSegBuilder((HeapSegment)built.segment, built.state);
            hsb22.concretizeAndDisconnectNG(summary, concrete);
            hsb22.msg("concretized and disconnected ");
            hsb22.assumeEdgeNG(fieldThatPoints, concrete);
            SegmentWithState build = hsb22.build();
            RegionAccess e = new RegionAccess(abstractMemPointer, build);
            hsb.msg("materialized " + concrete);
            res.add(e);
        }
        catch (Unreachable hsb22) {
            // empty catch block
        }
        try {
            hsb22 = new HeapSegBuilder((HeapSegment)built.segment, built.state);
            hsb22.msg("starting expandAndBendGhostEdges");
            hsb22.expandAndBendGhostEdgesNG(summary, concrete);
            hsb22.msg("expanded and bent");
            hsb22.assumeEdgeNG(fieldThatPoints, concrete);
            hsb22.msg("assumed edge");
            res.add(new RegionAccess(abstractMemPointer, hsb22.build()));
        }
        catch (Unreachable unreachable) {
            // empty catch block
        }
        return res;
    }

    private AbstractMemPointer rebasePointer(AbstractPointer pointer, HeapRegion concrete) {
        HeapRegion summary = this.heapRegions.get(pointer.address);
        SymbolicOffset offset = new SymbolicOffset(pointer.offset.add(summary.address).sub(concrete.address));
        AbstractMemPointer abstractMemPointer = new AbstractMemPointer(concrete.memId, offset);
        return abstractMemPointer;
    }

    private void checkOffset(AbstractPointer pointer, D state) {
        Range ofs = pointer.getExplicitOffset((QueryChannel)state);
    }

    private boolean responsibleFor(AbstractPointer pointer) {
        return !pointer.isAbsolute() && this.heapRegions.byAddress.contains(pointer.address);
    }

    private SegmentWithState<D> primitiveFree(Rhs.Rval arg, D state) {
        throw new UnimplementedException("not yet implemented");
    }

    HeapSegment<D> removeRegion(HeapRegion region) {
        NumVar.AddrVar rad = region.address;
        MemVar rmid = region.memId;
        HeapSegment<D> heapSegment = new HeapSegment<D>(this.heapRegions.remove(rad), this.connectors, this.allKnownRegions.remove(rmid));
        return heapSegment;
    }

    HeapSegment<D> removeRegion(MemVar mv) {
        HeapRegion region = this.heapRegions.get(mv);
        NumVar.AddrVar rad = region.address;
        HeapSegment<D> heapSegment = new HeapSegment<D>(this.heapRegions.remove(rad), this.connectors, this.allKnownRegions.remove(mv));
        return heapSegment;
    }

    @Override
    public SegmentWithState<D> tryPrimitive(RReil.PrimOp prim, D state) {
        if (prim.is("malloc", 1, 1)) {
            return this.primitiveMalloc(prim, state);
        }
        if (prim.is("free", 0, 1)) {
            return this.primitiveFree(prim.getInArg(0), state);
        }
        if (prim.is("foldRegions", 0, 0)) {
            return this.primitiveFoldRegions(state);
        }
        return null;
    }

    private SegmentWithState<D> primitiveFoldRegions(D state) {
        SegmentWithState<D> summarizeHeap = this.summarizeHeap(state);
        return summarizeHeap;
    }

    HeapSegment<D> bindRegion(HeapRegion segment) {
        return new HeapSegment<D>(this.heapRegions.bind(segment), this.connectors, this.allKnownRegions.insert(segment.memId));
    }

    HeapSegment<D> bindConnector(ConnectorId id, ConnectorData data) {
        return this.withConnectors(this.connectors.add(id, data));
    }

    HeapSegment<D> removeConnector(ConnectorId id) {
        return this.withConnectors(this.connectors.remove(id));
    }

    HeapSegment<D> withConnectors(ConnectorSet cs) {
        return new HeapSegment<D>(this.heapRegions, cs, this.allKnownRegions);
    }

    private SegmentWithState<D> primitiveMalloc(RReil.PrimOp prim, D state) {
        Rhs.Rval arg = prim.getInArg(0);
        Range sz = state.queryRange(arg);
        BigInt size = sz.getConstantOrNull();
        if (size == null) {
            assert (false) : "size " + arg + "==" + sz + " is not constant";
            return null;
        }
        MemVar regionName = MemVar.fresh();
        NumVar.AddrVar addr = NumVar.freshAddress();
        state = this.introOnChild(state, regionName, addr);
        HeapSegment<D> a = this.createRegion(addr, regionName, size);
        Lhs outArg = prim.getOutArg(0);
        state = state.assignSymbolicAddressOf(outArg, addr);
        assert (a.connectorsAreSane());
        return a.informAboutAssign(state, outArg.getRegionId(), Range.ZERO, null, Range.TOP);
    }

    private D introOnChild(D state, MemVar regionName, NumVar.AddrVar addr) {
        state = state.introduce(addr, Type.Address, Option.none());
        state = state.introduceRegion(regionName, RegionCtx.EMPTYSTICKY);
        return state;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.heapRegions.byAddress.isEmpty()) {
            builder.append(this.heapRegions.byAddress);
        }
        if (builder.toString().isEmpty()) {
            return StringHelpers.indentMultiline("Heap: ", this.connectors.toString());
        }
        return StringHelpers.indentMultiline("Heap: ", builder.toString() + '\n' + this.connectors.toString());
    }

    @Override
    public void toCompactString(StringBuilder builder, PrettyDomain childDomain) {
        builder.append("Heap (other regions: " + this.nonHeapRegions() + ")\n");
        this.heapRegions.toCompactString(builder, childDomain);
        this.connectors.toCompactString(builder, childDomain);
    }

    @Override
    public SegCompatibleState<D> makeCompatible(Segment<D> otherSegRaw, D thisState, D otherState) {
        HeapSegment other = (HeapSegment)otherSegRaw;
        HeapSegBuilder<D> first = new HeapSegBuilder<D>(this, thisState);
        HeapSegBuilder<D> second = new HeapSegBuilder<D>(other, otherState);
        return new MakeHeapCompatibleWorker<D>(first, second).makeCompatible();
    }

    @Override
    public SegmentWithState<D> summarizeHeap(D thisState) {
        HeapSegBuilder<D> builder = new HeapSegBuilder<D>(this, thisState);
        builder.summarizeHeap();
        return builder.build();
    }

    HeapPartitioning partition(D child) {
        MemVarSet nodes = this.heapRegions.regions();
        MemVarSet registers = this.nonHeapRegions();
        FiniteMap heapToRegs = AVLMap.empty();
        for (MemVar node : nodes) {
            heapToRegs = heapToRegs.bind(node, MemVarSet.empty());
        }
        for (MemVar register : registers) {
            List<P2<PathString, NumVar.AddrVar>> tgts = child.findPossiblePointerTargets(register);
            for (P2<PathString, NumVar.AddrVar> tgt : tgts) {
                NumVar.AddrVar tgtAddr = tgt._2();
                HeapRegion tgtRegion = this.heapRegions.get(tgtAddr);
                if (tgtRegion == null) continue;
                heapToRegs = heapToRegs.bind(tgtRegion.memId, heapToRegs.getOrNull((MemVar)tgtRegion.memId).insert(register));
            }
        }
        return new HeapPartitioning((AVLMap<MemVar, MemVarSet>)heapToRegs);
    }

    @Override
    public boolean connectorsAreSane() {
        return true;
    }

    @Override
    public MemVarSet getChildSupportSet() {
        MemVarSet s = MemVarSet.empty();
        for (HeapRegion x : this.heapRegions.byAddress.values()) {
            s = s.insertAll(x.getChildSupportSet());
        }
        return s.insertAll(this.connectors.getChildSupportSet());
    }

    HeapSegment<D> createRegion(NumVar.AddrVar addr, MemVar name, BigInt size) {
        return this.bindRegion(new HeapRegion(addr, name, size));
    }

    @Override
    public SegmentWithState<D> informAboutAssign(D childState, MemVar toRegion, Range toOffset, MemVar fromRegion, Range fromOffset) {
        HeapSegBuilder<D> builder = new HeapSegBuilder<D>(this, childState);
        builder.informAboutAssign(toRegion, toOffset, fromRegion, fromOffset);
        return builder.build();
    }

    ConnectorSet getEdgeNodesAttachedTo(MemVar region) {
        return this.connectors.getEdgenodesAttachedTo(region);
    }

    HeapSegment<D> bindEdgeNode(MemVar toSource, PathString pathString, MemVar toTarget, MemVar newSrcCont, MemVar newDestCont) {
        ConnectorId toId = new ConnectorId(toSource, pathString, toTarget);
        ConnectorData toData = new ConnectorData(newSrcCont, newDestCont);
        return this.bindConnector(toId, toData);
    }

    public HeapSegment<D> bendEdgenodesToSummary(MemVar concrete, MemVar summary) {
        ConnectorSet toBend = this.connectors.getConnectorComingFrom(concrete);
        ConnectorSet ens = this.connectors;
        for (Connector en : toBend) {
            assert (en.id.tgt.equals(concrete));
            ens = ens.remove(en.id);
            ens = ens.add(new ConnectorId(en.id.src, en.id.pathString, summary), en.data);
        }
        return this.withConnectors(ens);
    }

    public HeapSegment<D> addKnownRegions(MemVarSet allKnownRegions2) {
        return new HeapSegment<D>(this.heapRegions, this.connectors, this.allKnownRegions.insertAll(allKnownRegions2));
    }

    MemVarSet nonHeapRegions() {
        return this.allKnownRegions.difference(this.heapRegions.regions());
    }
}

