/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.segments;

import bindead.abstractsyntax.memderef.AbstractMemPointer;
import bindead.abstractsyntax.memderef.AbstractPointer;
import bindead.data.Linear;
import bindead.data.MemVarSet;
import bindead.data.NumVar;
import bindead.domainnetwork.combinators.RootMemoryFunctor;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.segments.SegMemState;
import bindead.domains.segments.SegMemStateBuilder;
import bindead.domains.segments.basics.RegionAccess;
import bindead.domains.segments.basics.SegCompatibleState;
import bindead.domains.segments.basics.Segment;
import bindead.domains.segments.basics.SegmentAccess;
import bindead.domains.segments.basics.SegmentWithState;
import bindead.exceptions.Unreachable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.exceptions.UnimplementedException;
import javalx.fn.Fn;
import javalx.mutablecollections.CollectionHelpers;
import javalx.persistentcollections.AVLSet;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.Test;

public class SegMem<D extends MemoryDomain<D>>
extends RootMemoryFunctor<SegMemState<D>, D, SegMem<D>> {
    public static final String NAME = "SEGMEM";
    @Deprecated
    static Map<MemVar, Integer> triggers;

    public SegMem(D child, Segment<D> ... segs) {
        this(SegMem.init(child, segs));
    }

    private SegMem(P2<SegMemState<D>, D> state) {
        this(state._1(), (MemoryDomain)state._2());
    }

    public SegMem(SegMemState<D> ctx, D child) {
        super(NAME, ctx, child);
    }

    private static <D extends MemoryDomain<D>> P2<SegMemState<D>, D> init(D child, Segment<D> ... segs) {
        SegMemState<D> state = new SegMemState<D>(segs, MemVarSet.empty());
        triggers = new HashMap<MemVar, Integer>();
        child = state.initialize(triggers, child);
        return P2.tuple2(state, child);
    }

    @Override
    public SegMem<D> build(SegMemState<D> state, D childState) {
        SegMem.checkSupport(state, childState);
        assert (state.edgenodesAreSane());
        return new SegMem<D>(state, childState);
    }

    private static <D extends MemoryDomain<D>> void checkSupport(SegMemState<D> state, D childState) {
        MemVarSet supp1 = state.getChildSupportSet();
        MemVarSet supp2 = childState.getSupportSet();
        MemVarSet onlyInState = supp1.difference(supp2);
        MemVarSet onlyInChild = supp2.difference(supp1);
        assert (SegMem.sameAs(supp1, supp2)) : "state has " + onlyInState + " and child has " + onlyInChild + " exclusively";
    }

    private static boolean sameAs(MemVarSet supp1, MemVarSet supp2) {
        for (MemVar t : supp1) {
            if (supp2.contains(t) || t.getName().equals("stack") || t.getName().equals("sp")) continue;
            return false;
        }
        for (MemVar t : supp2) {
            if (supp1.contains(t) || t.getName().equals("stack") || t.getName().equals("sp")) continue;
            return false;
        }
        return true;
    }

    @Override
    public P3<SegMemState<D>, D, D> makeCompatible(SegMem<D> newState, boolean isWideningPoint) {
        if (isWideningPoint) {
            newState = super.summarizeHeap();
        }
        int numberOfSegments = ((SegMemState)this.state).size();
        assert (numberOfSegments == ((SegMemState)newState.state).size());
        SegMemState rstate = (SegMemState)this.state;
        MemoryDomain child = (MemoryDomain)this.childState;
        MemoryDomain otherChild = (MemoryDomain)newState.childState;
        for (int i = 0; i < numberOfSegments; ++i) {
            SegCompatibleState<MemoryDomain> triple = ((SegMemState)this.state).get(i).makeCompatible(((SegMemState)newState.state).get(i), child, otherChild);
            rstate = rstate.setSegmentAt(i, triple.segment);
            child = triple.leftState;
            otherChild = triple.rightState;
        }
        return P3.tuple3(rstate, child, otherChild);
    }

    private SegMem<D> summarizeHeap() {
        SegMemStateBuilder builder = new SegMemStateBuilder(this);
        builder.summarizeHeap();
        return this.build(builder);
    }

    private SegMem<D> build(SegMemStateBuilder<D> builder) {
        return this.build(builder.build(), builder.childState);
    }

    @Override
    public SegMem<D> eval(RReil.PrimOp prim) {
        if (prim.is("coredump", 0, 0)) {
            StringBuilder builder = new StringBuilder();
            this.toCompactString(builder);
            System.out.println(builder.toString());
            return this;
        }
        SegMemStateBuilder builder = new SegMemStateBuilder(this);
        builder.evalPrimop(prim);
        return this.build(builder);
    }

    @Override
    public SegMem<D> eval(RReil.Assign stmt) {
        SegMemStateBuilder builder = new SegMemStateBuilder(this);
        Integer triggerIdx = triggers.get(stmt.getLhs().getRegionId());
        builder.evalAssign(stmt, triggerIdx);
        return this.build(builder);
    }

    @Override
    public SegMem<D> eval(RReil.Load stmt) {
        List<SegmentAccess<D>> sources = this.findPointerTargets(stmt.getReadAddress());
        if (sources.isEmpty()) {
            return this.evalLoadWithNoAccess(stmt);
        }
        SegmentAccess<D> first = sources.remove(0);
        SegMem<SegMem<D>> current = this.evalLoadOnAccess(stmt, first);
        for (SegmentAccess<D> tuple : sources) {
            SegMem<D> result = this.evalLoadOnAccess(stmt, tuple);
            current = current.join(result);
        }
        return current;
    }

    private SegMem<D> evalLoadWithNoAccess(RReil.Load stmt) {
        SegMemStateBuilder builder = new SegMemStateBuilder(this);
        builder.evalLoadTop(stmt);
        return this.build(builder);
    }

    private SegMem<D> evalLoadOnAccess(RReil.Load stmt, SegmentAccess<D> access) {
        SegMemStateBuilder builder = new SegMemStateBuilder(access.state);
        builder.evalLoadFromLocation(stmt, access.location);
        return this.build(builder);
    }

    @Override
    public SegMem<D> eval(RReil.Store stmt) {
        List<SegmentAccess<D>> targets = this.findPointerTargets(stmt.getWriteAddress());
        if (targets.isEmpty()) {
            return this;
        }
        SegmentAccess<D> segmentAccess = targets.remove(0);
        SegMem<SegMem<D>> current = this.evalStoreOnAccess(stmt, segmentAccess);
        for (SegmentAccess<D> tuple : targets) {
            current = current.join(this.evalStoreOnAccess(stmt, tuple));
        }
        return current;
    }

    private SegMem<D> evalStoreOnAccess(RReil.Store stmt, SegmentAccess<D> segmentAccess) {
        SegMemStateBuilder builder = new SegMemStateBuilder(segmentAccess.state);
        builder.evalStore(segmentAccess.location, stmt);
        return this.build(builder);
    }

    private List<SegmentAccess<D>> findPointerTargets(Rhs.Lin value) {
        try {
            SegMemStateBuilder builder = new SegMemStateBuilder(this);
            builder.introduceRegister(value);
            Object newChildState = builder.childState;
            P3 newDereferenced = newChildState.findPointerTargets(value);
            AVLSet<NumVar.AddrVar> addresses = newDereferenced._1();
            MemoryDomain child = (MemoryDomain)newDereferenced._2();
            Linear offset = newDereferenced._3().getLinearTerm();
            List<SegmentAccess<D>> targets = this.dereference(value, AbstractPointer.absolute(offset), child);
            for (NumVar.AddrVar addr : addresses) {
                List<SegmentAccess<MemoryDomain>> dereferenced = this.dereference(value, AbstractPointer.relativeTo(offset, addr), child);
                targets.addAll(dereferenced);
            }
            return targets;
        }
        catch (Unreachable _) {
            return new LinkedList<SegmentAccess<D>>();
        }
    }

    @Override
    public List<P2<RReilAddr, SegMem<D>>> eval(RReil.Branch branch, ProgramPoint current, ProgramPoint next) {
        Rhs.Lin target = branch.getTarget();
        LinkedList<P2<RReilAddr, SegMem<D>>> result = new LinkedList<P2<RReilAddr, SegMem<D>>>();
        List<SegmentAccess<D>> pointerTargets = this.findPointerTargets(target);
        for (SegmentAccess<D> targets : pointerTargets) {
            List<P2<RReilAddr, SegMem<D>>> withJumpsResolved = this.resolveJumpTargets(target, targets.location);
            List withJumpsExecuted = super.evalJumpTargets(current, next, withJumpsResolved);
            result.addAll(withJumpsExecuted);
        }
        return result;
    }

    private List<P2<RReilAddr, SegMem<D>>> resolveJumpTargets(Rhs.Lin target, AbstractMemPointer ptr) {
        for (int codeSegmentIndex = 0; codeSegmentIndex < ((SegMemState)this.state).size(); ++codeSegmentIndex) {
            Segment<MemoryDomain> segment = ((SegMemState)this.state).get(codeSegmentIndex);
            List<P2<RReilAddr, SegmentWithState<D>>> result = segment.resolveJump(target, ptr, (MemoryDomain)this.childState);
            if (result == null) continue;
            return this.mutateStateAt(result, codeSegmentIndex);
        }
        return Collections.emptyList();
    }

    private List<P2<RReilAddr, SegMem<D>>> mutateStateAt(List<P2<RReilAddr, SegmentWithState<D>>> addressStates, final int index) {
        return CollectionHelpers.map(addressStates, new Fn<P2<RReilAddr, SegmentWithState<D>>, P2<RReilAddr, SegMem<D>>>(){

            @Override
            public P2<RReilAddr, SegMem<D>> apply(P2<RReilAddr, SegmentWithState<D>> a) {
                return P2.tuple2(a._1(), SegMem.this.build(((SegMemState)SegMem.this.state).setSegmentAt(index, a._2().segment), a._2().state));
            }
        });
    }

    private List<P2<RReilAddr, SegMem<D>>> evalJumpTargets(ProgramPoint current, ProgramPoint next, List<P2<RReilAddr, SegMem<D>>> resolvedJumps) {
        LinkedList<P2<RReilAddr, SegMem<D>>> finalResult = new LinkedList<P2<RReilAddr, SegMem<D>>>();
        for (P2<RReilAddr, SegMem<D>> resolvedTarget : resolvedJumps) {
            SegMemState resolvedState = (SegMemState)resolvedTarget._2().state;
            for (int stackSegmentIndex = 0; stackSegmentIndex < resolvedState.size(); ++stackSegmentIndex) {
                Segment<MemoryDomain> segment = resolvedState.get(stackSegmentIndex);
                SegmentWithState<MemoryDomain> finalSegment = segment.evalJump(resolvedTarget._1(), (MemoryDomain)this.childState, current, next);
                if (finalSegment == null) continue;
                SegMemState finalState = resolvedState.setSegmentAt(stackSegmentIndex, finalSegment.segment);
                finalResult.add(P2.tuple2(resolvedTarget._1(), this.build(finalState, finalSegment.state)));
            }
        }
        return finalResult;
    }

    @Override
    public SegMem<D> eval(Test test) throws Unreachable {
        SegMemStateBuilder builder = new SegMemStateBuilder(this);
        builder.evalTest(test);
        return this.build(builder);
    }

    @Override
    public SegMem<D> introduceRegion(MemVar region, RegionCtx ctx) {
        SegMemStateBuilder builder = new SegMemStateBuilder(this);
        builder.introduceRegion(region, ctx);
        return this.build(builder);
    }

    private List<SegmentAccess<D>> dereference(Rhs.Lin pointerValue, AbstractPointer target, D child) {
        LinkedList<SegmentAccess<D>> result = new LinkedList<SegmentAccess<D>>();
        for (int i = 0; i < ((SegMemState)this.state).size(); ++i) {
            Segment<D> segment = ((SegMemState)this.state).get(i);
            List res = segment.dereference(pointerValue, target, child);
            if (res == null) continue;
            for (RegionAccess deref : res) {
                SegMemState newstate = ((SegMemState)this.state).setSegmentAt(i, deref.segstate.segment);
                SegMem built = this.build(newstate, deref.segstate.state);
                result.add(new SegmentAccess(deref.location, built));
            }
        }
        return result;
    }

    @Override
    public void memVarToCompactString(StringBuilder builder, MemVar var) {
        throw new UnimplementedException();
    }

    @Override
    public void toCompactString(StringBuilder builder) {
        List cs = ((MemoryDomain)this.childState).enumerateAlternatives();
        for (int i = 0; i < cs.size(); ++i) {
            MemoryDomain c = (MemoryDomain)cs.get(i);
            builder.append("Alternative " + i + ":\n");
            ((SegMemState)this.state).toCompactString(this.name, builder, c);
            c.toCompactString(builder);
            builder.append('\n');
        }
    }
}

