/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.root;

import bindead.data.NumVar;
import bindead.domainnetwork.combinators.RootMemoryFunctor;
import bindead.domainnetwork.interfaces.MemoryDomain;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.fields.messages.ReadFromUnknownPointerInfo;
import bindead.domains.root.RootState;
import bindead.domains.root.RootStateBuilder;
import bindead.domains.segments.warnings.PrimitiveNotFound;
import bindead.exceptions.Unreachable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.data.products.P3;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import rreil.RReilGrammarException;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.Test;
import rreil.lang.util.RvarExtractor;
import rreil.lang.util.Type;

public class Root<D extends MemoryDomain<D>>
extends RootMemoryFunctor<RootState, D, Root<D>> {
    public static final String NAME = "ROOT";

    public Root(D child) {
        this(RootState.EMPTY, child);
    }

    private Root(RootState ctx, D child) {
        super(NAME, ctx, child);
    }

    @Override
    public Root<D> build(RootState state, D childState) {
        return new Root<D>(state, childState);
    }

    @Override
    public P3<RootState, D, D> makeCompatible(Root<D> other, boolean isWideningPoint) {
        if (this == other) {
            return P3.tuple3(this.state, this.childState, this.childState);
        }
        RootStateBuilder fst = new RootStateBuilder((RootState)this.state);
        RootStateBuilder snd = new RootStateBuilder((RootState)other.state);
        fst.makeCompatible(snd);
        MemoryDomain newChildStateOfFst = fst.applyChildOps((MemoryDomain)this.childState);
        MemoryDomain newChildStateOfSnd = snd.applyChildOps((MemoryDomain)other.childState);
        return P3.tuple3(fst.build(), newChildStateOfFst, newChildStateOfSnd);
    }

    @Override
    public Root<D> eval(RReil.Assign assign) {
        RootStateBuilder builder = new RootStateBuilder((RootState)this.state);
        Lhs lhs = assign.getLhs();
        builder.addRegister(lhs.getRegionId());
        Rhs rhs = assign.getRhs();
        for (Rhs.Rvar var : RvarExtractor.fromRhs(rhs)) {
            builder.addRegister(var.getRegionId());
        }
        MemoryDomain newChildState = builder.applyChildOps((MemoryDomain)this.childState);
        newChildState = newChildState.evalAssign(lhs, rhs);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Root<D> eval(RReil.Load load) {
        throw new RReilGrammarException();
    }

    @Override
    public Root<D> eval(RReil.Store store) {
        throw new RReilGrammarException();
    }

    @Override
    public Root<D> eval(Test test) {
        RootStateBuilder builder = new RootStateBuilder((RootState)this.state);
        for (Rhs.Rvar var : RvarExtractor.fromRhs(test.getComparison())) {
            builder.addRegister(var.getRegionId());
        }
        MemoryDomain newChildState = builder.applyChildOps((MemoryDomain)this.childState);
        newChildState = newChildState.eval(test);
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public List<P2<RReilAddr, Root<D>>> eval(RReil.Branch branch, ProgramPoint current, ProgramPoint next) {
        Range targets = ((MemoryDomain)this.childState).queryRange(branch.getTarget());
        if (targets == null) {
            targets = Range.from(Interval.top());
        }
        Root<MemoryDomain> thisState = this.build((RootState)this.state, (D)((MemoryDomain)this.childState));
        if (targets.isConstant()) {
            P2<RReilAddr, Root<MemoryDomain>> singleTarget = P2.tuple2(RReilAddr.valueOf(targets.getConstantOrNull()), thisState);
            return Collections.singletonList(singleTarget);
        }
        int maxTargets = 100;
        BigInt r = targets.numberOfDiscreteValues();
        if (targets.isFinite() && r.isLessThan(BigInt.of(maxTargets))) {
            LinkedList<P2<RReilAddr, Root<D>>> result = new LinkedList<P2<RReilAddr, Root<D>>>();
            for (BigInt value : targets) {
                result.add(P2.tuple2(RReilAddr.valueOf(value), thisState));
            }
            return result;
        }
        this.getContext().addWarning(new ReadFromUnknownPointerInfo(targets));
        throw new Unreachable();
    }

    @Override
    public Root<D> eval(RReil.PrimOp prim) {
        RootStateBuilder builder = new RootStateBuilder((RootState)this.state);
        if (prim.is("currentStackFrameAddress", 1, 0)) {
            NumVar symbolicAddress = builder.addressOf(MemVar.getVarOrFresh("stack"));
            MemoryDomain newChildState = builder.applyChildOps((MemoryDomain)this.childState);
            newChildState = newChildState.assignSymbolicAddressOf(prim.getOutArgs().get(0), symbolicAddress);
            return this.build(builder.build(), (D)newChildState);
        }
        if (prim.is("fixAtConstantAddress", 0, 1)) {
            MemVar region = null;
            Rhs rval = prim.getInArgs().get(0);
            if (rval instanceof Rhs.Rvar) {
                region = ((Rhs.Rvar)rval).getRegionId();
            }
            if (region != null && builder.contexts.contains(region)) {
                RegionCtx rCtx = builder.contexts.getOrNull(region);
                builder.addSegmentCtx(rCtx.getSegment().get());
                return this.build(builder.build(), (D)((MemoryDomain)this.childState));
            }
        } else if (prim.is("addressOf", 1, 1)) {
            MemVar region = null;
            Rhs rval = prim.getInArgs().get(0);
            if (rval instanceof Rhs.Rvar) {
                region = ((Rhs.Rvar)rval).getRegionId();
            }
            if (region != null) {
                NumVar symbolicAddress = builder.addressOf(region);
                MemoryDomain newChildState = builder.applyChildOps((MemoryDomain)this.childState);
                newChildState = newChildState.assignSymbolicAddressOf(prim.getOutArgs().get(0), symbolicAddress);
                return this.build(builder.build(), (D)newChildState);
            }
        } else {
            if (prim.is("addRegisters", 0, Integer.MAX_VALUE)) {
                MemoryDomain newChildState = (MemoryDomain)this.childState;
                for (int i = 0; i < prim.getInArgs().size(); ++i) {
                    Rhs.Rvar variable = (Rhs.Rvar)prim.getInArg(i);
                    MemVar id = variable.getRegionId();
                    builder.addRegister(id);
                    newChildState = newChildState.introduceRegion(id, RegionCtx.EMPTYSTICKY);
                }
                return this.build(builder.build(), (D)newChildState);
            }
            this.getContext().addWarning(new PrimitiveNotFound(prim));
            throw new Unreachable();
        }
        return null;
    }

    @Override
    public Root<D> introduceRegion(MemVar region, RegionCtx regionCtx) {
        RootStateBuilder builder = new RootStateBuilder((RootState)this.state);
        Object newChildState = ((MemoryDomain)this.childState).introduceRegion(region, regionCtx);
        if (regionCtx.isAddressable()) {
            NumVar.AddrVar addressVar = NumVar.freshAddress();
            Option<BigInt> concreteAddress = regionCtx.getAddress();
            if (concreteAddress.isSome()) {
                builder.concreteAddresses = builder.concreteAddresses.bind((Object)concreteAddress.get(), (Object)region);
            }
            newChildState = newChildState.introduce(addressVar, Type.Address, concreteAddress);
            builder.setAddressOf(region, addressVar);
        }
        builder.introduce(region, regionCtx);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public void memVarToCompactString(StringBuilder builder, MemVar var) {
        throw new UnimplementedException();
    }
}

