/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.abstractsyntax.finite.Finite;
import bindead.abstractsyntax.finite.FiniteExprVisitor;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.domainnetwork.channels.WarningsContainer;
import bindead.domains.pointsto.HyperPointsToSet;
import bindead.domains.pointsto.PointerAlignmentWarning;
import bindead.domains.pointsto.PointsToProperties;
import bindead.domains.pointsto.PointsToSet;
import bindead.domains.pointsto.PointsToState;
import javalx.numeric.BigInt;

class RhsTranslator
implements FiniteExprVisitor<HyperPointsToSet, Void> {
    private final PointsToState state;
    private final WarningsContainer warnings;
    private final FiniteFactory fin = FiniteFactory.getInstance();
    private final boolean DEBUG;
    private final int lhsSize;
    private static final BigInt $PointerAlignmentMask32Bit = BigInt.of("fffffff0", 16);
    private static final BigInt $PointerAlignmentMask64Bit = BigInt.of("fffffffffffffff0", 16);
    private static final BigInt $PointerAlignmentMaskSigned = BigInt.of(-16L);

    RhsTranslator(int lhsSize, PointsToState pb, WarningsContainer w) {
        this.DEBUG = PointsToProperties.INSTANCE.debugOther.isTrue();
        this.lhsSize = lhsSize;
        this.state = pb;
        this.warnings = w;
    }

    HyperPointsToSet run(Finite.Rhs rhs) {
        return rhs.accept(this, null);
    }

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("\nRhsTranslator: " + s);
        }
    }

    @Override
    public HyperPointsToSet visit(Finite.Bin expr, Void data) {
        HyperPointsToSet l = this.visit(expr.getLeft(), data);
        HyperPointsToSet r = this.visit(expr.getRight(), data);
        if (l.isScalar() && r.isScalar()) {
            l.offset = expr;
            return l;
        }
        switch (expr.getOp()) {
            case Add: {
                l.add(r);
                return l;
            }
            case Sub: {
                l.sub(r);
                return l;
            }
            case And: {
                BigInt c;
                Linear rightLin = expr.getRight().getLinearTerm();
                if (!rightLin.isConstantOnly() || !RhsTranslator.isPointerAlignmentMask(c = rightLin.getConstant())) break;
                this.warnings.addWarning(new PointerAlignmentWarning(expr.getLeft(), expr.getRight()));
                return l;
            }
        }
        this.msg("operation " + expr.getOp() + " not supported yet");
        l.setToTop();
        return l;
    }

    private static boolean isPointerAlignmentMask(BigInt c) {
        if (c == null) {
            return false;
        }
        return c.isEqualTo($PointerAlignmentMask32Bit) || c.isEqualTo($PointerAlignmentMask64Bit) || c.isEqualTo($PointerAlignmentMaskSigned);
    }

    @Override
    public HyperPointsToSet visit(Finite.Cmp expr, Void data) {
        HyperPointsToSet l = this.visit(expr.getLeft(), data);
        HyperPointsToSet r = this.visit(expr.getRight(), data);
        if (l.isScalar() && r.isScalar()) {
            l.offset = this.fin.comparison((Finite.Rlin)l.offset, expr.getOp(), (Finite.Rlin)r.offset);
        } else {
            l.setToTop();
        }
        return l;
    }

    @Override
    public HyperPointsToSet visit(Finite.SignExtend expr, Void data) {
        HyperPointsToSet h = this.visit(expr.getExpr(), data);
        if (this.isPtsAgnostic(h, expr.getSize())) {
            h.offset = this.fin.signExtend((Finite.Rlin)h.offset);
        } else {
            h.setToTop();
        }
        return h;
    }

    @Override
    public HyperPointsToSet visit(Finite.Convert expr, Void data) {
        Finite.Rlin linExpr = expr.getExpr();
        HyperPointsToSet h = this.visit(linExpr, data);
        if (this.isPtsAgnostic(h, expr.getSize())) {
            h.offset = this.fin.convert((Finite.Rlin)h.offset);
        } else {
            h.setToTop();
        }
        return h;
    }

    private boolean isPtsAgnostic(HyperPointsToSet h, int rhsSize) {
        return h.isScalar() || rhsSize <= this.lhsSize;
    }

    @Override
    public HyperPointsToSet visit(Finite.Rlin rlin, Void data) {
        return this.visitLinear(rlin.getLinearTerm(), rlin.getSize());
    }

    HyperPointsToSet visitLinear(Linear linearTerm, int size) {
        HyperPointsToSet result = new HyperPointsToSet(size);
        result.addOffset(size, linearTerm.getConstant());
        for (Linear.Term t : linearTerm.getTerms()) {
            result.add(this.visitVar(size, t.getId()).mul(t.getCoeff()));
        }
        return result;
    }

    HyperPointsToSet visitVar(int size, NumVar termVar) {
        HyperPointsToSet result = new HyperPointsToSet(size);
        if (termVar.isAddress()) {
            result.addCoefficient((NumVar.AddrVar)termVar, Linear.ONE);
            result.addSumOfFlags(Linear.ONE);
        } else {
            PointsToSet pts = this.state.getPts(termVar);
            result.addOffset(this.fin.linear(size, Linear.linear(termVar)));
            if (!pts.sumOfFlags.isConstantZero()) {
                result.addSumOfFlags(pts.sumOfFlags.getLinear());
            }
            for (PointsToSet.PointsToEntry entry : pts) {
                result.addCoefficient(entry.address, Linear.linear(entry.flag));
            }
        }
        return result;
    }

    @Override
    public HyperPointsToSet visit(Finite.FiniteRangeRhs range, Void data) {
        return new HyperPointsToSet(range);
    }

    public String toString() {
        return "RhsTranslator(...)";
    }
}

