/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.pointsto;

import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domains.pointsto.PointsToSet;
import java.util.Iterator;
import javalx.data.Option;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.FiniteMap;
import javalx.persistentcollections.ThreeWaySplit;

class PointsToMap
implements Iterable<PointsToSet> {
    final AVLMap<NumVar, PointsToSet> pointsToMap;

    PointsToMap() {
        this.pointsToMap = AVLMap.empty();
    }

    PointsToMap(AVLMap<NumVar, PointsToSet> ptm) {
        this.pointsToMap = ptm;
    }

    @Override
    public Iterator<PointsToSet> iterator() {
        return this.pointsToMap.values().iterator();
    }

    boolean contains(NumVar key) {
        return this.pointsToMap.contains(key);
    }

    Option<PointsToSet> get(NumVar key) {
        return this.pointsToMap.get(key);
    }

    PointsToMap bind(PointsToSet pts) {
        return new PointsToMap((AVLMap<NumVar, PointsToSet>)this.pointsToMap.bind((Object)pts.var, (Object)pts));
    }

    PointsToMap remove(NumVar key) {
        return new PointsToMap((AVLMap<NumVar, PointsToSet>)this.pointsToMap.remove((Object)key));
    }

    ThreeWaySplit<PointsToMap> split(PointsToMap other) {
        ThreeWaySplit<AVLMap<NumVar, PointsToSet>> split = this.pointsToMap.split(other.pointsToMap);
        return ThreeWaySplit.make(new PointsToMap(split.onlyInFirst()), new PointsToMap(split.inBothButDiffering()), new PointsToMap(split.onlyInSecond()));
    }

    public boolean isEmpty() {
        return this.pointsToMap.isEmpty();
    }

    public VarSet getNonScalars() {
        VarSet nons = VarSet.empty();
        for (PointsToSet pts : this.pointsToMap.values()) {
            if (!pts.isScalar()) {
                nons = nons.add(pts.var);
            }
            nons = nons.union(pts.localVars());
        }
        return nons;
    }

    public int pointersCount() {
        return this.getNonScalars().size();
    }

    public PointsToMap removeEntry(NumVar src, NumVar.AddrVar tgt) {
        PointsToSet pts = this.pointsToMap.get(src).get();
        pts = pts.remove(tgt);
        FiniteMap m2 = this.pointsToMap.bind((Object)src, (Object)pts);
        return new PointsToMap((AVLMap<NumVar, PointsToSet>)m2);
    }

    VarSet getSupport() {
        VarSet supp = VarSet.empty();
        for (NumVar v : this.pointsToMap.keys()) {
            supp = supp.add(v);
        }
        return supp;
    }

    public String toString() {
        return this.pointsToMap.toString();
    }
}

