/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.gauge;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.util.ZenoExprSimplifier;
import bindead.abstractsyntax.zeno.util.ZenoTestHelper;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.QueryChannel;
import bindead.domainnetwork.combinators.ZenoFunctor;
import bindead.domainnetwork.interfaces.ZenoDomain;
import bindead.domains.gauge.GaugeProperties;
import bindead.domains.gauge.GaugeState;
import bindead.domains.gauge.GaugeStateBuilder;
import bindead.exceptions.Unreachable;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import rreil.lang.util.Type;

public class Gauge<D extends ZenoDomain<D>>
extends ZenoFunctor<GaugeState, D, Gauge<D>> {
    private static final boolean DEBUGBINARIES = GaugeProperties.INSTANCE.debugBinaryOperations.isTrue();
    private static final boolean DEBUGSUBSETOREQUAL = GaugeProperties.INSTANCE.debugSubsetOrEqual.isTrue();
    private static final boolean DEBUGWIDENING = GaugeProperties.INSTANCE.debugWidening.isTrue();
    private static final boolean DEBUGASSIGN = GaugeProperties.INSTANCE.debugAssignments.isTrue();
    private static final boolean DEBUGTESTS = GaugeProperties.INSTANCE.debugTests.isTrue();
    public static final String NAME = "GAUGE";

    public Gauge(D childState) {
        this(GaugeState.EMPTY, childState);
    }

    private Gauge(GaugeState state, D childState) {
        super(NAME, state, childState);
    }

    @Override
    public Gauge<D> join(Gauge<D> other) {
        GaugeStateBuilder fst = ((GaugeState)this.state).getBuilder();
        GaugeStateBuilder snd = ((GaugeState)other.state).getBuilder();
        fst.join((ZenoDomain)this.childState, snd);
        return this.build(fst.build(), (D)((ZenoDomain)((ZenoDomain)this.childState).join(other.childState)));
    }

    @Override
    public Gauge<D> widen(Gauge<D> other) {
        GaugeStateBuilder fst = ((GaugeState)this.state).getBuilder();
        GaugeStateBuilder snd = ((GaugeState)other.state).getBuilder();
        if (DEBUGWIDENING) {
            System.out.println(this.name + ":");
            System.out.println("  widening@" + other.getContext().getLocation());
            System.out.println("  this: " + this.state);
            System.out.println("  other: " + other.state);
        }
        fst.widen((ZenoDomain)this.childState, snd, (ZenoDomain)other.childState);
        if (DEBUGWIDENING) {
            System.out.println("  result: " + fst.build().toString());
        }
        return this.build(fst.build(), (D)((ZenoDomain)((ZenoDomain)this.childState).widen(other.childState)));
    }

    @Override
    public boolean subsetOrEqual(Gauge<D> other) {
        GaugeStateBuilder fst = ((GaugeState)this.state).getBuilder();
        GaugeStateBuilder snd = ((GaugeState)other.state).getBuilder();
        if (DEBUGSUBSETOREQUAL) {
            System.out.println(this.name + ":");
            System.out.println("  subsumption test");
            System.out.println("  this: " + this.state);
            System.out.println("  other: " + other);
            System.out.println("  result: " + fst.subsetOrEqualTo(snd));
        }
        return fst.subsetOrEqualTo(snd);
    }

    @Override
    public Gauge<D> build(GaugeState state, D childState) {
        return new Gauge<D>(state, childState);
    }

    @Override
    public Gauge<D> eval(Zeno.Assign stmt) {
        stmt = ZenoExprSimplifier.run(stmt, (QueryChannel)((Object)this.childState));
        GaugeStateBuilder builder = ((GaugeState)this.state).getBuilder();
        builder.assign((ZenoDomain)this.childState, stmt);
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        newChildState = newChildState.eval(stmt);
        if (DEBUGASSIGN) {
            System.out.println(this.name + ":");
            System.out.println("  assign: " + stmt);
            System.out.println("  this: " + this.state);
            System.out.println("  after: " + builder.build().toString());
        }
        return this.build(builder.build(), (D)newChildState);
    }

    @Override
    public Gauge<D> eval(Zeno.Test test) throws Unreachable {
        if (DEBUGTESTS) {
            System.out.println(this.name + ":");
            System.out.println("  evaluating test: " + test);
            System.out.println("  this: " + this.state);
        }
        if (ZenoTestHelper.isTautologyReportUnreachable(test)) {
            return this;
        }
        if (test.getOperator().equals((Object)Zeno.ZenoTestOp.NotEqualToZero)) {
            ZenoDomain lessThanMinusOne;
            P2<Zeno.Test, Zeno.Test> tuple = test.splitEquality();
            Gauge childTested = this.build((GaugeState)this.state, ((ZenoDomain)this.childState).eval(test));
            try {
                lessThanMinusOne = childTested.eval(tuple._1());
            }
            catch (Unreachable u) {
                ZenoDomain greaterThanOne = childTested.eval(tuple._2());
                return greaterThanOne;
            }
            try {
                ZenoDomain greaterThanOne = childTested.eval(tuple._2());
                return ((Gauge)lessThanMinusOne).join((Gauge<D>)greaterThanOne);
            }
            catch (Unreachable u) {
                return lessThanMinusOne;
            }
        }
        if (test.getOperator().equals((Object)Zeno.ZenoTestOp.EqualToZero)) {
            ZenoDomain geqZero;
            P2<Zeno.Test, Zeno.Test> tuple = test.splitEquality();
            Gauge childTested = this.build((GaugeState)this.state, ((ZenoDomain)this.childState).eval(test));
            try {
                geqZero = childTested.eval(tuple._1());
            }
            catch (Unreachable u) {
                ZenoDomain leqZero = childTested.eval(tuple._2());
                return leqZero;
            }
            try {
                ZenoDomain leqZero = childTested.eval(tuple._2());
                return ((Gauge)geqZero).join((Gauge<D>)leqZero);
            }
            catch (Unreachable u) {
                return geqZero;
            }
        }
        GaugeStateBuilder builder = ((GaugeState)this.state).getBuilder();
        Object newChildState = ((ZenoDomain)this.childState).eval(test);
        newChildState = builder.reduce(newChildState, test);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Gauge<D> project(VarSet vars) {
        GaugeStateBuilder builder = ((GaugeState)this.state).getBuilder();
        for (NumVar variable : vars) {
            builder.project((ZenoDomain)this.childState, variable);
        }
        Object newChildState = ((ZenoDomain)this.childState).project(vars);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Gauge<D> substitute(NumVar x, NumVar y) {
        GaugeStateBuilder builder = ((GaugeState)this.state).getBuilder();
        builder.substitute(x, y);
        Object newChildState = ((ZenoDomain)this.childState).substitute(x, y);
        return this.build(builder.build(), newChildState);
    }

    @Override
    public Gauge<D> introduce(NumVar variable, Type type, Option<BigInt> value) {
        GaugeStateBuilder builder = ((GaugeState)this.state).getBuilder();
        builder.introduce(variable, value);
        ZenoDomain newChildState = builder.applyChildOps((ZenoDomain)this.childState);
        newChildState = newChildState.introduce(variable, type, value);
        return this.build(builder.build(), (D)newChildState);
    }
}

