/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.fields;

import bindead.data.MemVarSet;
import bindead.data.VarSet;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.interfaces.ContentCtx;
import bindead.domainnetwork.interfaces.RegionCtx;
import bindead.domains.fields.Region;
import bindead.domains.fields.VariableCtx;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.OverlappingRanges;
import rreil.lang.MemVar;

class RegionMap {
    final AVLMap<MemVar, Region> map;

    private RegionMap(AVLMap<MemVar, Region> map) {
        this.map = map;
    }

    private RegionCtx getContext(MemVar varId) {
        return this.map.get((MemVar)varId).get().context;
    }

    Option<ContentCtx> getSegment(MemVar varId) {
        return this.getContext(varId).getSegment();
    }

    static RegionMap empty() {
        return new RegionMap(AVLMap.empty());
    }

    RegionMap remove(MemVar region, FiniteRange range) {
        Region fields = this.map.get(region).get();
        return this.bind(region, fields.remove(range));
    }

    Option<VariableCtx> get(MemVar varId, FiniteRange range) {
        Option<Region> fields = this.map.get(varId);
        if (fields.isSome()) {
            return fields.get().fields.get(range);
        }
        return Option.none();
    }

    OverlappingRanges<VariableCtx> searchOverlaps(MemVar region, Interval range) {
        Region tree = this.map.get(region).getOrNull();
        if (tree == null) {
            return new OverlappingRanges<VariableCtx>();
        }
        return tree.fields.searchOverlaps(range);
    }

    boolean isEmpty() {
        return this.map.isEmpty();
    }

    Region get(MemVar regionId) {
        Region option = this.getOrNull(regionId);
        assert (option != null) : "not containing " + regionId;
        return option;
    }

    Region getOrNull(MemVar regionId) {
        return this.map.get(regionId).getOrNull();
    }

    boolean contains(MemVar regionId) {
        return this.map.contains(regionId);
    }

    RegionMap bind(MemVar regionId, Region fields) {
        return new RegionMap((AVLMap<MemVar, Region>)this.map.bind((Object)regionId, (Object)fields));
    }

    RegionMap remove(MemVar regionId) {
        return new RegionMap((AVLMap<MemVar, Region>)this.map.remove((Object)regionId));
    }

    ThreeWaySplit<RegionMap> split(RegionMap other) {
        ThreeWaySplit<AVLMap<MemVar, Region>> split = this.map.split(other.map);
        return ThreeWaySplit.make(new RegionMap(split.onlyInFirst()), new RegionMap(split.inBothButDiffering()), new RegionMap(split.onlyInSecond()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        SortedSet<MemVar> sorted = StringHelpers.sortLexically(this.map.keys());
        Iterator iterator = sorted.iterator();
        builder.append('{');
        while (iterator.hasNext()) {
            MemVar key = (MemVar)iterator.next();
            Region value = this.map.getOrNull(key);
            builder.append(key);
            builder.append('=');
            builder.append(value);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    int size() {
        return this.map.size();
    }

    public MemVarSet keys() {
        return MemVarSet.from(this.map.keys());
    }

    public void appendInfo(StringBuilder builder, PrettyDomain childDomain) {
        MemVar regionVariable;
        HashSet<P2<MemVar, Region>> empties = new HashSet<P2<MemVar, Region>>();
        HashSet<P2<MemVar, Region>> nonEmpties = new HashSet<P2<MemVar, Region>>();
        for (P2<MemVar, Region> p2 : this.map) {
            Region region = p2._2();
            if (region.isEmpty()) {
                empties.add(p2);
                continue;
            }
            nonEmpties.add(p2);
        }
        if (!empties.isEmpty()) {
            builder.append("    ");
            for (P2<MemVar, Region> p2 : empties) {
                regionVariable = p2._1();
                builder.append(regionVariable + ", ");
            }
            builder.setLength(builder.length() - 2);
            builder.append(" : {}");
            builder.append("\n");
        }
        for (P2<MemVar, Region> p2 : nonEmpties) {
            regionVariable = p2._1();
            Region region = p2._2();
            builder.append("    " + regionVariable + " : ");
            region.appendInfo(builder, childDomain);
            builder.append("\n");
        }
    }

    VarSet contentVars(MemVar s) {
        VarSet ss = VarSet.empty();
        for (P2<FiniteRange, VariableCtx> p2 : this.get((MemVar)s).fields) {
            ss = ss.add(p2._2().getVariable());
        }
        return ss;
    }
}

