/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.congruences;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarPair;
import bindead.data.VarSet;
import bindead.domainnetwork.channels.SetOfEquations;
import bindead.domainnetwork.combinators.ZenoStateBuilder;
import bindead.domains.congruences.CongruenceState;
import bindead.exceptions.DomainStateException;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Congruence;
import javalx.persistentcollections.AVLMap;
import javalx.persistentcollections.ThreeWaySplit;

class CongruenceStateBuilder
extends ZenoStateBuilder {
    AVLMap<NumVar, Congruence> state;

    public CongruenceStateBuilder(CongruenceState state) {
        this.state = state.congruences;
    }

    public CongruenceState build() {
        return new CongruenceState(this.state);
    }

    public void remove(NumVar lhs) {
        this.state = this.state.remove((Object)lhs);
    }

    public void substituteInCongruences(NumVar x, NumVar y) {
        Option<Congruence> congruenceOfXOption = this.state.get(x);
        if (congruenceOfXOption.isNone()) {
            throw new DomainStateException.VariableSupportSetException();
        }
        this.state = this.state.remove((Object)x);
        this.state = this.state.bind((Object)y, (Object)congruenceOfXOption.get());
    }

    public void expand(FoldMap pairs) {
        for (VarPair vp : pairs) {
            Option<Congruence> valueOfPermanentOption = this.state.get((NumVar)vp.getPermanent());
            if (valueOfPermanentOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            Congruence valueOfPermanent = valueOfPermanentOption.get();
            this.state = this.state.bind(vp.getEphemeral(), (Object)valueOfPermanent);
        }
    }

    public void fold(FoldMap pairs) {
        for (VarPair pair : pairs) {
            NumVar permanent = (NumVar)pair.getPermanent();
            NumVar ephemeral = (NumVar)pair.getEphemeral();
            Option<Congruence> valueOfPermanentOption = this.state.get(permanent);
            if (valueOfPermanentOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            Congruence valueOfPermanent = valueOfPermanentOption.get();
            Option<Congruence> valueOfEphemeralOption = this.state.get(ephemeral);
            if (valueOfEphemeralOption.isNone()) {
                throw new DomainStateException.VariableSupportSetException();
            }
            Congruence valueOfEphemeral = valueOfEphemeralOption.get();
            Congruence joinedCongruence = valueOfPermanent.join(valueOfEphemeral);
            this.getChildOps().addScale(permanent, valueOfPermanent, joinedCongruence);
            this.getChildOps().addScale(ephemeral, valueOfEphemeral, joinedCongruence);
            this.state = this.state.remove((Object)ephemeral);
            this.state = this.state.bind((Object)permanent, (Object)joinedCongruence);
        }
    }

    public void copyAndPaste(VarSet vars, CongruenceState ctx) {
        for (NumVar var : vars) {
            Congruence value = ctx.congruences.get(var).getOrNull();
            if (value == null) {
                throw new DomainStateException.VariableSupportSetException();
            }
            this.state = this.state.bind((Object)var, (Object)value);
        }
    }

    public void makeCompatible(CongruenceStateBuilder other) {
        Congruence newCongruence;
        Congruence c2;
        Congruence c1;
        NumVar var;
        ThreeWaySplit<AVLMap<NumVar, Congruence>> split = this.state.split(other.state);
        for (P2<NumVar, Congruence> p2 : split.inBothButDiffering()) {
            var = p2._1();
            c1 = this.state.get(var).get();
            c2 = other.state.get(var).get();
            newCongruence = c1.join(c2);
            this.getChildOps().addScale(var, c1, newCongruence);
            other.getChildOps().addScale(var, c2, newCongruence);
        }
        for (P2<NumVar, Congruence> p2 : split.onlyInFirst()) {
            assert (false) : "This code should not be reachable as the variable set is made compatible in parent domains.";
            var = p2._1();
            c1 = this.state.get(var).get();
            c2 = Congruence.ONE;
            newCongruence = c1.join(c2);
            this.getChildOps().addScale(var, c1, newCongruence);
            other.getChildOps().addIntro(var);
        }
        for (P2<NumVar, Congruence> p2 : split.onlyInSecond()) {
            assert (false) : "This code should not be reachable as the variable set is made compatible in parent domains.";
            var = p2._1();
            c1 = Congruence.ONE;
            c2 = other.state.get(var).get();
            newCongruence = c1.join(c2);
            this.getChildOps().addIntro(var);
            other.getChildOps().addScale(var, c2, newCongruence);
        }
    }

    public void reduceFromNewEqualities(SetOfEquations newEqualities) {
        for (Linear equality : newEqualities) {
            NumVar var = equality.getKey();
            assert (equality.getCoeff(var).isOne());
            assert (equality.isSingleTerm());
            BigInt constantInChild = equality.getConstant().negate();
            Congruence oldCongruence = this.state.get(var).get();
            BigInt constant = constantInChild.mul(oldCongruence.getScale()).add(oldCongruence.getOffset());
            Congruence newCongruence = new Congruence(BigInt.ZERO, constant);
            this.state = this.state.bind((Object)var, (Object)newCongruence);
            this.getChildOps().addAssignment(new Zeno.Assign(new Zeno.Lhs(var), new Zeno.Rlin(Linear.linear(constant), BigInt.ONE)));
        }
    }

    public Linear inlineIntoLinear(Linear con, Linear.Divisor d) {
        return CongruenceState.inlineIntoLinear(con, d, this.state);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Childops: ");
        builder.append(this.getChildOps());
        builder.append("\n");
        builder.append(this.build());
        return builder.toString();
    }
}

