/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.congruences;

import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.debug.PrettyDomain;
import bindead.debug.StringHelpers;
import bindead.domainnetwork.interfaces.FunctorState;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Iterator;
import java.util.SortedSet;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Congruence;
import javalx.persistentcollections.AVLMap;

public class CongruenceState
extends FunctorState {
    public static final CongruenceState EMPTY = new CongruenceState(AVLMap.empty());
    protected final AVLMap<NumVar, Congruence> congruences;

    public CongruenceState(AVLMap<NumVar, Congruence> congruence) {
        this.congruences = congruence;
    }

    public Linear inlineIntoLinear(Linear con, Linear.Divisor d) {
        return CongruenceState.inlineIntoLinear(con, d, this.congruences);
    }

    public static Linear inlineIntoLinear(Linear linear, Linear.Divisor d, AVLMap<NumVar, Congruence> congruences) {
        Linear result = linear;
        for (NumVar x : linear.getVars()) {
            Option<Congruence> c = congruences.get(x);
            if (!c.isSome()) continue;
            Congruence congruence = c.get();
            BigInt coeff = result.getCoeff(x);
            result = result.dropTerm(x);
            result = result.add(congruence.getOffset().mul(coeff));
            if (congruence.getScale().isZero()) continue;
            result = result.addTerm(coeff.mul(congruence.getScale()), x);
        }
        if (d != null) {
            result = result.lowestForm(d);
        }
        return result;
    }

    @Override
    public XMLBuilder toXML(XMLBuilder builder) {
        builder = builder.e("CONGRUENCES");
        for (P2<NumVar, Congruence> p2 : this.congruences) {
            Congruence value = p2._2();
            builder = builder.e("Entry").a("type", "congruence").e("Variable").t(p2._1().toString()).up().e("Value").e("multiplier").t(value.getScale().toString()).up().e("offset").t(value.getOffset().toString()).up().up().up();
        }
        return builder.up();
    }

    public String toString() {
        return "#" + this.congruences.size() + " " + this.contentToString();
    }

    private String contentToString() {
        SortedSet<NumVar> sorted = StringHelpers.sortLexically(this.congruences.keys());
        Iterator iterator = sorted.iterator();
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        while (iterator.hasNext()) {
            NumVar key = (NumVar)iterator.next();
            Congruence value = this.congruences.getOrNull(key);
            builder.append(key);
            if (value.isConstantOnly()) {
                builder.append("=");
                builder.append(value.getOffset());
            } else {
                builder.append(value);
            }
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append('}').toString();
    }

    @Override
    public void toCompactString(String domainName, StringBuilder builder, PrettyDomain childDomain) {
    }

    public void appendVar(NumVar var, StringBuilder builder, PrettyDomain childDomain) {
        Congruence value = this.congruences.getOrNull(var);
        if (value.isConstantOnly()) {
            builder.append(value.getOffset());
        } else {
            childDomain.varToCompactString(builder, var);
            if (!value.getScale().isOne() || !value.getOffset().isZero()) {
                builder.append(value);
            }
        }
    }
}

