/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.apron;

import apron.Abstract1;
import apron.ApronException;
import apron.Coeff;
import apron.Lincons0;
import apron.Linterm0;
import apron.MpqScalar;
import apron.Scalar;
import bindead.data.NumVar;
import bindead.domains.apron.Marshaller;
import bindead.domains.apron.OctagonsMatrix;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.persistentcollections.BiMap;

class OctagonsMatrixPrinter {
    final OctagonsMatrix data;
    protected final BiMap<NumVar, String> variablesMapping;
    final String[] names;

    OctagonsMatrixPrinter(Abstract1 state, BiMap<NumVar, String> varMapping) throws ApronException {
        Lincons0[] lincons;
        this.variablesMapping = varMapping;
        this.names = state.getEnvironment().getVars();
        assert (this.names != null);
        int dim = state.getEnvironment().getVars().length;
        this.data = new OctagonsMatrix(dim);
        for (Lincons0 t : lincons = state.getAbstract0Ref().toLincons(state.getCreationManager())) {
            this.setLim(t);
        }
    }

    private void removeAddresses() {
        for (int i = 0; i < this.data.dim; ++i) {
            if (!this.isAddress(i)) continue;
            this.data.removeVarFromEquations(i);
        }
    }

    private boolean isAddress(int i) {
        String n = this.names[i];
        NumVar v = this.variablesMapping.getKey(n).get();
        return v instanceof NumVar.AddrVar;
    }

    private void removeScalars() {
        for (int i = 0; i < this.data.dim; ++i) {
            if (!this.data.isConstant(i)) continue;
            this.data.removeVarFromEquations(i);
        }
    }

    private String showInequality(String p, int i, String p1, int j, Bound content) {
        return p + this.showVar(i) + " " + p1 + " " + this.showVar(j) + " >= " + content.negate() + "; ";
    }

    private String showVar(int x) {
        String n = this.names[x];
        NumVar v = this.variablesMapping.getKey(n).get();
        return v.toString();
    }

    void setLim(Lincons0 t) {
        BigInt ofs = OctagonsMatrixPrinter.getOffsetOf(t);
        if (ofs != null) {
            int idx2;
            Linterm0[] terms = t.getLinterms();
            int idx1 = this.indexOf(terms[0]);
            if (terms.length == 1) {
                idx2 = this.data.indexOfZero();
            } else {
                assert (terms.length == 2);
                idx2 = this.indexOf(terms[1]);
            }
            this.data.setLim(idx1, idx2, ofs);
        }
    }

    private static BigInt getOffsetOf(Lincons0 t) {
        Coeff cst = t.getCst();
        return cst.isScalar() ? Marshaller.fromApronScalarRoundDown((Scalar)cst) : null;
    }

    private int indexOf(Linterm0 linterm) {
        int sgn = ((MpqScalar)linterm.coeff).cmp(0);
        if (sgn > 0) {
            return this.data.posIdx(linterm.dim);
        }
        return this.data.negIdx(linterm.dim);
    }

    private StringBuilder reduceAndPrintEqualities() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.data.dim; ++i) {
            for (int j = i + 1; j < this.data.dim; ++j) {
                Bound pp = this.data.ppBound(i, j);
                Bound nn = this.data.nnBound(i, j);
                if (pp.isFinite() && nn.isFinite() && pp.isEqualTo(nn.negate())) {
                    if (!this.data.isConstant(i) && !this.data.isConstant(j)) {
                        builder.append(this.equality(i, j, nn, " - "));
                    }
                    this.data.removeVarFromEquations(i);
                }
                Bound np = this.data.npBound(i, j);
                Bound pn = this.data.pnBound(i, j);
                if (!np.isFinite() || !pn.isFinite() || !np.isEqualTo(pn.negate())) continue;
                if (!this.data.isConstant(i) && !this.data.isConstant(j)) {
                    builder.append(this.equality(i, j, pn, " + "));
                }
                this.data.removeVarFromEquations(i);
            }
        }
        return builder;
    }

    private String equality(int i, int j, Bound constant, String operator) {
        if (constant.isZero()) {
            if (operator.equals("+")) {
                return this.showVar(j) + " == " + operator + this.showVar(i) + ", ";
            }
            return this.showVar(j) + " == " + this.showVar(i) + ", ";
        }
        return this.showVar(j) + " == " + constant + operator + this.showVar(i) + ", ";
    }

    private StringBuilder printBinaryRelations() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.data.dim; ++i) {
            for (int j = i + 1; j < this.data.dim; ++j) {
                Bound content4;
                Bound content3;
                Bound content2;
                Bound content1 = this.data.ppBound(i, j);
                if (content1.isFinite()) {
                    builder.append(this.showInequality(" ", i, "+", j, content1));
                }
                if ((content2 = this.data.nnBound(i, j)).isFinite()) {
                    builder.append(this.showInequality("-", i, "-", j, content2));
                }
                if ((content3 = this.data.pnBound(i, j)).isFinite()) {
                    builder.append(this.showInequality(" ", i, "-", j, content3));
                }
                if (!(content4 = this.data.npBound(i, j)).isFinite()) continue;
                builder.append(this.showInequality("-", i, "+", j, content4));
            }
        }
        return builder;
    }

    private void unrequire() {
        for (int i = 0; i < this.data.dim; ++i) {
            for (int j = 0; j < this.data.dim; ++j) {
                Bound ijnp;
                Bound iu = this.data.nnBound(i, -1);
                Bound il = this.data.pnBound(i, -1).negate();
                Bound ju = this.data.nnBound(j, -1);
                Bound jl = this.data.pnBound(j, -1).negate();
                Bound iju = this.data.nnBound(i, j);
                Bound ijl = this.data.ppBound(i, j).negate();
                if (ju.add(iu).isLessThanOrEqualTo(iju)) {
                    this.data.setLim(this.data.negIdx(i), this.data.negIdx(j), Bound.NEGINF);
                }
                if (ijl.isLessThanOrEqualTo(jl.add(il))) {
                    this.data.setLim(this.data.posIdx(i), this.data.posIdx(j), Bound.NEGINF);
                }
                if (!(ijnp = this.data.npBound(i, j).negate()).isLessThanOrEqualTo(jl.sub(iu))) continue;
                this.data.setLim(this.data.negIdx(i), this.data.posIdx(j), Bound.NEGINF);
            }
        }
    }

    public String printMinimalContraints() {
        StringBuilder builder = new StringBuilder();
        this.removeAddresses();
        StringBuilder equalitiesBuilder = this.reduceAndPrintEqualities();
        this.unrequire();
        this.removeScalars();
        StringBuilder binariesBuilder = this.printBinaryRelations();
        if (equalitiesBuilder.length() > 0 || binariesBuilder.length() > 0) {
            if (equalitiesBuilder.length() > 0) {
                builder.append('{');
                builder.append((CharSequence)equalitiesBuilder);
                builder.append('}');
                if (binariesBuilder.length() > 0) {
                    builder.append('\n');
                }
            }
            if (binariesBuilder.length() > 0) {
                builder.append('{');
                builder.append((CharSequence)binariesBuilder);
                builder.append("}");
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.data.toString();
    }
}

