/*
 * Decompiled with CFR 0.152.
 */
package bindead.domains.affine;

import bindead.data.Linear;
import bindead.data.NumVar;
import javalx.numeric.BigInt;

public class Substitution
implements Comparable<Substitution> {
    private final NumVar var;
    private final Linear expr;
    private final BigInt fac;

    public Substitution(NumVar var, Linear expr, BigInt fac) {
        this.var = var;
        if (fac.isZero()) {
            throw new IllegalArgumentException("Using a zero factor is not defined.");
        }
        if (fac.isPositive()) {
            this.fac = fac;
            this.expr = expr;
        } else {
            this.fac = fac.negate();
            this.expr = expr.negate();
        }
    }

    public static Substitution invertingSubstitution(Linear linear, BigInt fac, NumVar var) {
        Linear.Term[] terms = linear.getTerms();
        Linear.Term[] newTs = new Linear.Term[terms.length];
        BigInt prevFac = null;
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].getId() != var) {
                newTs[i] = terms[i];
                continue;
            }
            prevFac = terms[i].getCoeff();
            newTs[i] = Linear.term(fac.negate(), var);
        }
        assert (prevFac != null);
        return new Substitution(var, Linear.linear(linear.getConstant(), newTs), prevFac.negate());
    }

    public NumVar getVar() {
        return this.var;
    }

    public Linear getExpr() {
        return this.expr;
    }

    public BigInt getFac() {
        return this.fac;
    }

    public boolean isSimple() {
        if (!this.expr.isSingleTerm()) {
            return false;
        }
        if (!this.expr.getConstant().isZero()) {
            return false;
        }
        NumVar key = this.expr.getKey();
        BigInt kCoeff = this.expr.getCoeff(key);
        return kCoeff.isEqualTo(this.fac);
    }

    public boolean isInvertible() {
        return !this.expr.getCoeff(this.var).isZero();
    }

    public Substitution applySubst(Substitution subst) {
        Linear.Divisor d = new Linear.Divisor(this.fac);
        Linear newRhs = this.expr.applySubstitution(subst).lowestForm(d);
        return new Substitution(this.var, newRhs, d.get());
    }

    @Override
    public int compareTo(Substitution o) {
        int cmp = this.var.compareTo(o.var);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.fac.compareTo(o.fac);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.expr.compareTo(o.expr);
        return cmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fac == null ? 0 : this.fac.hashCode());
        result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
        result = 31 * result + (this.var == null ? 0 : this.var.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Substitution)) {
            return false;
        }
        Substitution other = (Substitution)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        if (this.fac.isOne()) {
            return "[" + this.var + "\\" + this.expr + "]";
        }
        return "[" + this.var + "\\ (" + this.expr + ") / " + this.fac + "]";
    }
}

