/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms.data;

import bindead.analyses.algorithms.data.CallString;
import bindead.domainnetwork.interfaces.ProgramPoint;
import javalx.data.Option;
import rreil.lang.RReilAddr;

public class ProgramCtx
implements ProgramPoint {
    private final CallString callString;
    private final RReilAddr address;

    public ProgramCtx(CallString callString, RReilAddr address) {
        this.callString = callString;
        this.address = address;
    }

    public CallString getCallString() {
        return this.callString;
    }

    @Override
    public RReilAddr getAddress() {
        return this.address;
    }

    @Override
    public ProgramPoint withAddress(RReilAddr newAddress) {
        return new ProgramCtx(this.callString, newAddress);
    }

    @Override
    public int compareTo(ProgramPoint other) {
        int cmp = this.getAddress().compareTo(other.getAddress());
        if (!(other instanceof ProgramCtx)) {
            return cmp;
        }
        ProgramCtx otherPoint = (ProgramCtx)other;
        return cmp != 0 ? cmp : this.getCallString().size() - otherPoint.getCallString().size();
    }

    public static Option<ProgramPoint> none() {
        return ProgramPoint.nowhere;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.callString == null ? 0 : this.callString.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgramCtx)) {
            return false;
        }
        ProgramCtx other = (ProgramCtx)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        if (!this.callString.isRoot()) {
            builder.append(this.callString + ", ");
        }
        builder.append(this.address.toShortString());
        builder.append(")");
        return builder.toString();
    }
}

