/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses.algorithms;

import bindead.analyses.Analysis;
import bindead.analyses.BinaryCodeCache;
import bindead.analyses.ProgressReporter;
import bindead.analyses.RReilCodeCache;
import bindead.analyses.algorithms.AnalysisProperties;
import bindead.analyses.algorithms.RecursiveDisassemblerEvaluator;
import bindead.analyses.algorithms.data.CallString;
import bindead.analyses.algorithms.data.Flows;
import bindead.analyses.algorithms.data.ProgramCtx;
import bindead.analyses.algorithms.data.TransitionSystem;
import bindead.analyses.algorithms.data.Worklist;
import bindead.analyses.warnings.WarningsMap;
import bindead.debug.AnalysisDebugger;
import bindead.domainnetwork.interfaces.ProgramPoint;
import bindead.domainnetwork.interfaces.RootDomain;
import bindead.environment.AnalysisEnvironment;
import bindead.exceptions.AnalysisException;
import bindead.exceptions.CallStringAnalysisException;
import bindead.exceptions.DomainStateException;
import bindead.exceptions.UnknownCodeAddressException;
import binparse.Binary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.mutablecollections.CollectionHelpers;
import rreil.disassembler.BlockOfInstructions;
import rreil.disassembler.Instruction;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;

public class RecursiveDisassembler<D extends RootDomain<D>>
extends Analysis<D> {
    private final WarningsMap warningsMap;
    private final TransitionSystem transitions;
    private final BinaryCodeCache binaryCode;
    private final RReilCodeCache rreilCode;
    private RecursiveDisassemblerEvaluator<D> evaluator;
    private final boolean DEBUGWARNINGS;
    private final boolean DEBUGEVAL;
    private final boolean DEBUGOTHER;
    private final boolean DISASSEMBLEBLOCKS;
    private final boolean IGNORENONEXISTENTCODE;
    private final AnalysisDebugger debugger;
    private final ProgressReporter progressReporter;

    public RecursiveDisassembler(AnalysisEnvironment environment, Binary binary) {
        super(environment);
        this.DEBUGWARNINGS = AnalysisProperties.INSTANCE.debugWarnings.isTrue();
        this.DEBUGEVAL = AnalysisProperties.INSTANCE.debugAssignments.isTrue();
        this.DEBUGOTHER = AnalysisProperties.INSTANCE.debugOther.isTrue();
        this.DISASSEMBLEBLOCKS = AnalysisProperties.INSTANCE.disassembleBlockWise.isTrue();
        this.IGNORENONEXISTENTCODE = AnalysisProperties.INSTANCE.ignoreNonExistentJumpTargets.isTrue();
        this.transitions = new TransitionSystem();
        this.warningsMap = new WarningsMap();
        this.binaryCode = new BinaryCodeCache(binary, this.getPlatform().getDisassembler(), this.warningsMap);
        this.rreilCode = new RReilCodeCache(binary);
        this.debugger = new AnalysisDebugger(this.binaryCode, this.rreilCode);
        this.progressReporter = new ProgressReporter(this.getWarnings());
    }

    @Override
    public BinaryCodeCache getBinaryCode() {
        return this.binaryCode;
    }

    @Override
    public RReilCodeCache getRReilCode() {
        return this.rreilCode;
    }

    @Override
    public TransitionSystem getTransitionSystem() {
        return this.transitions;
    }

    @Override
    public Option<D> getState(CallString callString, RReilAddr address) {
        return Option.none();
    }

    @Override
    public WarningsMap getWarnings() {
        return this.warningsMap;
    }

    @Override
    public ProgressReporter getProgressMonitoring() {
        return this.progressReporter;
    }

    @Override
    public void runFrom(RReilAddr startPoint) {
        assert (startPoint.offset() == 0);
        ProgramCtx entry = new ProgramCtx(CallString.root(), startPoint);
        this.processWorklist(entry);
        this.debugger.printCode();
    }

    private void processWorklist(ProgramCtx entry) {
        HashSet<RReilAddr> visited = new HashSet<RReilAddr>();
        Worklist<ProgramCtx> worklist = new Worklist<ProgramCtx>();
        worklist.enqueue(entry);
        while (!worklist.isEmpty()) {
            if (this.DEBUGOTHER) {
                System.out.println("\nOld:" + worklist);
            }
            ProgramCtx currentPoint = (ProgramCtx)worklist.dequeue();
            if (this.DEBUGOTHER) {
                System.out.println("CurrentElement: " + currentPoint);
            }
            List<ProgramCtx> successors = this.resolveSuccesorsWrapper(currentPoint);
            for (ProgramCtx successor : CollectionHelpers.reversedIterable(successors)) {
                if (visited.contains(successor.getAddress())) continue;
                visited.add(successor.getAddress());
                worklist.enqueue(successor);
            }
            if (!this.DEBUGOTHER) continue;
            System.out.println("Successors: " + successors);
            System.out.println("New:" + worklist);
        }
    }

    private List<ProgramCtx> resolveSuccesorsWrapper(ProgramCtx point) {
        try {
            if (Thread.interrupted()) {
                throw new InterruptedException("Analysis was stopped by user.");
            }
            return this.resolveSuccesors(point);
        }
        catch (CallStringAnalysisException cause) {
            try {
                this.debugger.printInstruction(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGEVAL) {
                System.out.println();
            }
            throw cause;
        }
        catch (RuntimeException cause) {
            try {
                this.debugger.printInstruction(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGEVAL) {
                System.out.println("\nBAM!\n" + cause + "\n");
            }
            this.debugger.printCode();
            throw cause;
        }
        catch (Error cause) {
            try {
                this.debugger.printInstruction(point);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.DEBUGEVAL) {
                System.out.println("\nBAM!\n" + cause + "\n");
            }
            this.debugger.printCode();
            throw cause;
        }
        catch (Throwable cause) {
            throw new CallStringAnalysisException(cause, this, point.getCallString(), point.getAddress());
        }
    }

    private List<ProgramCtx> resolveSuccesors(ProgramCtx currentProgramPoint) {
        P2<RReil, RReilAddr> pair;
        RReilAddr currentAddress = currentProgramPoint.getAddress();
        try {
            pair = this.getInstruction(currentAddress);
        }
        catch (UnknownCodeAddressException e) {
            if (this.IGNORENONEXISTENTCODE) {
                return Collections.emptyList();
            }
            throw e;
        }
        RReil currentRReilInstruction = pair._1();
        RReilAddr nextAddress = pair._2();
        this.debugBeforeEval(currentRReilInstruction, currentProgramPoint);
        this.debugger.printInstruction(currentProgramPoint);
        this.progressReporter.evaluatingInstruction(currentRReilInstruction);
        RecursiveDisassemblerEvaluator<D> evaluator = this.getEvaluator();
        P2<ProgramCtx, RReilAddr> ctx = P2.tuple2(currentProgramPoint, nextAddress);
        Flows successors = (Flows)currentRReilInstruction.accept(evaluator, ctx);
        ArrayList loggedSuccessors = new ArrayList();
        ArrayList<ProgramCtx> queue = new ArrayList<ProgramCtx>();
        CallString currentCallString = currentProgramPoint.getCallString();
        for (Flows.Successor successor : successors) {
            loggedSuccessors.add(new P2(successor, true));
            switch (successor.getType()) {
                case Call: {
                    CallString.Transition callTransition = new CallString.Transition(currentAddress, successor.getAddress());
                    CallString calleeCallString = currentCallString.push(callTransition);
                    ProgramCtx to = new ProgramCtx(calleeCallString, successor.getAddress());
                    this.transitions.addCallTransition(currentProgramPoint, to, nextAddress);
                    this.updateWorklist(to, queue);
                    break;
                }
                case Return: {
                    if (currentCallString.isRoot()) break;
                    CallString callerCallString = currentCallString.unsafePop();
                    ProgramCtx to = new ProgramCtx(callerCallString, successor.getAddress());
                    this.transitions.addReturnTransition(currentProgramPoint, to);
                    this.updateWorklist(to, queue);
                    break;
                }
                case Next: 
                case Jump: {
                    ProgramCtx to = new ProgramCtx(currentCallString, successor.getAddress());
                    this.transitions.addLocalTransition(currentCallString, currentProgramPoint, to);
                    this.updateWorklist(to, queue);
                    break;
                }
                case Halt: {
                    break;
                }
                case Error: {
                    throw new AnalysisException();
                }
            }
        }
        this.debugger.printSuccessors(loggedSuccessors);
        this.debugAfterEval(currentRReilInstruction, currentProgramPoint, successors);
        this.debugger.printWarnings(currentProgramPoint, this.getWarnings());
        this.debugger.printSeparator();
        if (successors.isEmpty()) {
            throw new DomainStateException.InvariantViolationException("No successors inferred after evaluating last instruction.");
        }
        return queue;
    }

    protected void updateWorklist(ProgramCtx to, List<ProgramCtx> queue) {
        block2: {
            try {
                this.disassemble(to.getAddress());
            }
            catch (UnknownCodeAddressException e) {
                if (this.IGNORENONEXISTENTCODE) break block2;
                throw e;
            }
        }
        queue.add(to);
    }

    private P2<RReil, RReilAddr> getInstruction(RReilAddr address) {
        RReilAddr nextInstructionAddress;
        Option<RReilAddr> nextInstructionOption;
        if (!this.binaryCode.hasInstruction(address.base())) {
            this.disassemble(address);
        }
        if ((nextInstructionOption = this.rreilCode.getNextInstructionAddressWithSameBase(address)).isSome()) {
            nextInstructionAddress = nextInstructionOption.get();
        } else {
            long nextNativeAddress = this.binaryCode.getNextDisassemblyAddress(address.base());
            nextInstructionAddress = RReilAddr.valueOf(nextNativeAddress);
        }
        RReil rreilInsn = this.rreilCode.getInstruction(address);
        return P2.tuple2(rreilInsn, nextInstructionAddress);
    }

    private void disassemble(RReilAddr address) {
        if (this.DISASSEMBLEBLOCKS) {
            this.disassembleBlock(address);
        } else {
            this.disassembleOne(address);
        }
    }

    private void disassembleOne(RReilAddr address) {
        Instruction insn = this.binaryCode.decodeInstruction(address.base());
        for (LowLevelRReil stmt : insn.toRReilInstructions()) {
            this.rreilCode.addInstruction(stmt.toRReil());
        }
    }

    private void disassembleBlock(RReilAddr address) {
        BlockOfInstructions block = this.binaryCode.decodeBlock(address.base());
        for (LowLevelRReil stmt : block.toRReilInstructions()) {
            this.rreilCode.addInstruction(stmt.toRReil());
        }
    }

    protected RecursiveDisassemblerEvaluator<D> getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new RecursiveDisassemblerEvaluator(this.warningsMap);
        }
        return this.evaluator;
    }

    private void debugBeforeEval(RReil stmt, ProgramPoint point) {
        if (this.debugHooks != null) {
            this.debugHooks.beforeEval(stmt, point, null, this);
        }
    }

    private void debugAfterEval(RReil stmt, ProgramPoint point, Flows<D> flow) {
        if (this.debugHooks != null) {
            for (Flows.Successor<D> successor : flow) {
                this.debugHooks.afterEval(stmt, point, successor.getAddress(), successor.getState(), this);
            }
        }
    }
}

