/*
 * Decompiled with CFR 0.152.
 */
package bindead.analyses;

import bindead.debug.StringHelpers;
import binparse.Binary;
import binparse.Symbol;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import javalx.data.Option;
import javalx.numeric.BigInt;
import rreil.lang.AssemblerParseable;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class RReilCodeCache
implements AssemblerParseable {
    private final NavigableMap<RReilAddr, RReil> instructions = new TreeMap<RReilAddr, RReil>();
    private final Option<Binary> binary;

    public RReilCodeCache() {
        this(null);
    }

    public RReilCodeCache(Binary binary) {
        this.binary = Option.fromNullable(binary);
    }

    public SortedMap<RReilAddr, RReil> getInstructions() {
        return this.instructions;
    }

    public RReil getInstruction(RReilAddr address) {
        if (!this.hasInstruction(address)) {
            throw new IllegalArgumentException("Instruction for address " + address + " not found.");
        }
        return (RReil)this.instructions.get(address);
    }

    public boolean hasInstruction(RReilAddr address) {
        return this.instructions.containsKey(address);
    }

    public Option<RReilAddr> getNextInstructionAddressWithSameBase(RReilAddr address) {
        RReilAddr nextInstruction = this.instructions.higherKey(address);
        if (nextInstruction != null && nextInstruction.base() == address.base()) {
            return Option.some(nextInstruction);
        }
        return Option.none();
    }

    public void addInstruction(RReil insn) {
        this.instructions.put(insn.getRReilAddress(), insn);
    }

    public int instructionsCount() {
        return this.instructions.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.instructions.entrySet()) {
            String label;
            RReilAddr address = (RReilAddr)entry.getKey();
            RReil instruction = (RReil)entry.getValue();
            if (address.offset() == 0 && !(label = this.getLabel(instruction.getRReilAddress())).isEmpty()) {
                builder.append(label + ":\n");
            }
            String instructionString = this.toRichInstructionString(instruction);
            builder.append(address + ": " + instructionString + "\n");
        }
        return builder.toString();
    }

    public String toDisassemblyString() {
        boolean showBlockSeparator = this.haveSubAddresses();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.instructions.entrySet()) {
            RReilAddr address = (RReilAddr)entry.getKey();
            RReil instruction = (RReil)entry.getValue();
            String insnString = address + ":  " + this.toRichInstructionString(instruction);
            if (address.offset() == 0) {
                String currentLabel = this.getLabel(address);
                if (!currentLabel.isEmpty()) {
                    builder.append("\n" + currentLabel + ":\n");
                }
                if (showBlockSeparator) {
                    builder.append(StringHelpers.repeatString("-", insnString.length()) + "\n");
                }
            }
            builder.append(insnString + "\n");
        }
        return builder.toString();
    }

    private boolean haveSubAddresses() {
        for (RReilAddr address : this.instructions.keySet()) {
            if (address.offset() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toAssemblerString() {
        StringBuilder builder = new StringBuilder();
        for (RReil instruction : this.instructions.values()) {
            if (instruction.getRReilAddress().base() == 0L) {
                builder.append("\"");
                builder.append(" // -- next native instruction --");
                builder.append("\",\n");
            }
            builder.append("\"");
            builder.append(instruction.toAssemblerString());
            builder.append("\",\n");
        }
        return builder.toString();
    }

    public String toRichInstructionString(RReil instruction) {
        return this.appendLabelForJumps(instruction);
    }

    private static Option<RReilAddr> toLiteralAddress(Rhs.Lin target) {
        Rhs.Rval rval;
        if (target instanceof Rhs.LinRval && (rval = ((Rhs.LinRval)target).getRval()) instanceof Rhs.Rlit) {
            BigInt value = ((Rhs.Rlit)rval).getValue();
            return Option.some(RReilAddr.valueOf(value));
        }
        return Option.none();
    }

    private String appendLabelForJumps(RReil instruction) {
        if (instruction.isBranch() && !instruction.isIndirectBranch()) {
            String targetLabel;
            RReil.Branch branch;
            Option<RReilAddr> target;
            if (instruction instanceof RReil.BranchToNative) {
                String targetLabel2;
                RReil.BranchToNative branch2 = (RReil.BranchToNative)instruction;
                Option<RReilAddr> target2 = RReilCodeCache.toLiteralAddress(branch2.getTarget());
                if (target2.isSome() && !(targetLabel2 = this.getLabel(target2.get())).isEmpty()) {
                    return instruction + " <" + targetLabel2 + ">";
                }
            } else if (instruction instanceof RReil.Branch && (target = RReilCodeCache.toLiteralAddress((branch = (RReil.Branch)instruction).getTarget())).isSome() && !(targetLabel = this.getLabel(target.get())).isEmpty()) {
                return instruction + " <" + targetLabel + ">";
            }
        }
        return instruction.toString();
    }

    public String getLabel(RReilAddr address) {
        if (this.binary.isNone()) {
            return "";
        }
        Option<Symbol> symbol = this.binary.get().getSymbol(address.base());
        if (symbol.isNone()) {
            return "";
        }
        return symbol.get().getName().getOrElse("");
    }

    public Option<Long> getAddressForLabel(String label) {
        if (this.binary.isNone()) {
            return Option.none();
        }
        Option<Symbol> symbol = this.binary.get().getSymbol(label);
        if (symbol.isNone()) {
            return Option.none();
        }
        return Option.some(symbol.get().getAddress());
    }
}

