/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.zeno.util;

import bindead.abstractsyntax.zeno.Zeno;
import bindead.abstractsyntax.zeno.ZenoRhsVisitorSkeleton;
import bindead.data.Linear;
import bindead.domainnetwork.channels.QueryChannel;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;

public class ZenoExprSimplifier
extends ZenoRhsVisitorSkeleton<Zeno.Rhs, QueryChannel> {
    private static final ZenoExprSimplifier visitor = new ZenoExprSimplifier();

    public static Zeno.Assign run(Zeno.Assign stmt, QueryChannel channel) {
        Zeno.Rhs newRhs = stmt.getRhs().accept(visitor, channel);
        if (newRhs == null) {
            newRhs = new Zeno.Rlin(Linear.linear(Bound.ONE));
        }
        if (newRhs != stmt.getRhs()) {
            return new Zeno.Assign(stmt.getLhs(), newRhs);
        }
        return stmt;
    }

    @Override
    public Zeno.Rhs visit(Zeno.Bin expr, QueryChannel channel) {
        BigInt l = expr.getLeft().getConstantOrNull();
        BigInt r = expr.getRight().getConstantOrNull();
        if (l != null && r != null) {
            switch (expr.getOp()) {
                case Div: {
                    if (r.isZero()) {
                        return new Zeno.Rlin(Linear.linear(Bound.ZERO));
                    }
                    return new Zeno.Rlin(Linear.linear(l.div(r)));
                }
                case Shl: {
                    return new Zeno.Rlin(Linear.linear(l.shl(r)));
                }
                case Shr: {
                    return new Zeno.Rlin(Linear.linear(l.shr(r)));
                }
                case Mod: {
                    return new Zeno.Rlin(Linear.linear(l.mod(r)));
                }
            }
        }
        if (l != null || r != null) {
            BigInt divisor;
            Linear linear;
            BigInt constVal;
            if (l != null) {
                constVal = l;
                linear = expr.getRight().getLinearTerm();
                divisor = expr.getRight().getDivisor();
            } else {
                constVal = r;
                linear = expr.getLeft().getLinearTerm();
                divisor = expr.getLeft().getDivisor();
            }
            switch (expr.getOp()) {
                case Mul: {
                    return new Zeno.Rlin(linear.smul(constVal), divisor);
                }
            }
        }
        return expr;
    }

    @Override
    public Zeno.Rhs visit(Zeno.Rlin expr, QueryChannel channel) {
        return expr;
    }

    @Override
    public Zeno.Rhs visit(Zeno.RangeRhs expr, QueryChannel channel) {
        if (expr.getRange().isConstant()) {
            return new Zeno.Rlin(Linear.linear(expr.getRange().convexHull().low().asInteger()));
        }
        return expr;
    }
}

