/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.zeno;

import bindead.abstractsyntax.zeno.ZenoFactory;
import bindead.abstractsyntax.zeno.ZenoVisitor;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domains.affine.Substitution;
import bindead.exceptions.DomainStateException;
import com.jamesmurty.utils.XMLBuilder;
import javalx.data.products.P2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import javalx.xml.XmlPrintable;

public abstract class Zeno {
    public abstract <R, T> R accept(ZenoVisitor<R, T> var1, T var2);

    public abstract String toString();

    public static final class RangeRhs
    extends Rhs {
        private final Range range;

        public RangeRhs(Range range) {
            this.range = range;
        }

        public RangeRhs(Interval range) {
            this.range = Range.from(range);
        }

        public Range getRange() {
            return this.range;
        }

        @Override
        public VarSet getVars() {
            return VarSet.empty();
        }

        @Override
        public <R, T> R accept(ZenoVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String toString() {
            return this.range.toString();
        }
    }

    public static final class Rlin
    extends Rhs
    implements Comparable<Rlin> {
        private final Linear linearTerm;
        private final BigInt divisor;

        public Rlin(Linear linearTerm) {
            this.linearTerm = linearTerm;
            this.divisor = Bound.ONE;
        }

        public Rlin(Linear linearTerm, BigInt divisor) {
            assert (!divisor.isZero());
            if (!divisor.isNegative()) {
                this.linearTerm = linearTerm;
                this.divisor = divisor;
            } else {
                this.linearTerm = linearTerm.negate();
                this.divisor = divisor.negate();
            }
        }

        @Override
        public <R, T> R accept(ZenoVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public Linear getLinearTerm() {
            return this.linearTerm;
        }

        public BigInt getDivisor() {
            return this.divisor;
        }

        public BigInt getConstantOrNull() throws DomainStateException {
            if (this.isConstantOnly()) {
                return this.linearTerm.getConstant();
            }
            return null;
        }

        public boolean isConstantOnly() {
            if (this.linearTerm.isConstantOnly() && !this.divisor.isOne()) {
                throw new DomainStateException.InvariantViolationException();
            }
            return this.linearTerm.isConstantOnly();
        }

        @Override
        public VarSet getVars() {
            return this.linearTerm.getVars();
        }

        public Rlin add(Rlin other) {
            Linear res = Linear.mulAdd(other.divisor, this.linearTerm, this.divisor, other.linearTerm);
            return new Rlin(res, Bound.ONE);
        }

        public Rlin sub(Rlin other) {
            return this.add(new Rlin(other.getLinearTerm().negate()));
        }

        public Rlin smul(BigInt c) {
            assert (this.divisor.isOne());
            return new Rlin(this.linearTerm.smul(c), this.divisor);
        }

        @Override
        public int compareTo(Rlin other) {
            int cmp = this.divisor.compareTo(other.divisor);
            if (cmp == 0) {
                return this.linearTerm.compareTo(other.linearTerm);
            }
            return cmp;
        }

        @Override
        public String toString() {
            boolean hasDivisor = !this.divisor.isOne();
            StringBuilder builder = new StringBuilder();
            if (hasDivisor) {
                builder.append("(");
            }
            builder.append(this.linearTerm);
            if (hasDivisor) {
                builder.append(")/" + this.divisor);
            }
            return builder.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Rlin)) {
                return false;
            }
            Rlin other = (Rlin)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + (this.linearTerm != null ? this.linearTerm.hashCode() : 0);
            hash = 67 * hash + (this.divisor != null ? this.divisor.hashCode() : 0);
            return hash;
        }
    }

    public static final class Test
    implements Comparable<Test>,
    XmlPrintable {
        private static final ZenoFactory zeno = ZenoFactory.getInstance();
        private final ZenoTestOp op;
        private final Linear expr;

        Test(Linear expr, ZenoTestOp op) {
            this.op = op;
            this.expr = expr;
        }

        public ZenoTestOp getOperator() {
            return this.op;
        }

        public Test withExpr(Linear lin) {
            return zeno.comparison(lin, this.op);
        }

        public Linear getExpr() {
            return this.expr;
        }

        public VarSet getVars() {
            return this.expr.getVars();
        }

        public Test applySubstitution(Substitution sigma) {
            if (this.expr.getVars().contains(sigma.getVar())) {
                return zeno.comparison(this.expr.applySubstitution(sigma), this.op);
            }
            return this;
        }

        public Test not() {
            Test test = null;
            switch (this.getOperator()) {
                case EqualToZero: {
                    test = zeno.comparison(this.getExpr(), ZenoTestOp.NotEqualToZero);
                    break;
                }
                case NotEqualToZero: {
                    test = zeno.comparison(this.getExpr(), ZenoTestOp.EqualToZero);
                    break;
                }
                case LessThanOrEqualToZero: {
                    Linear lin = Linear.ONE.sub(this.getExpr());
                    test = zeno.comparison(zeno.linear(lin), ZenoTestOp.LessThanOrEqualToZero);
                    break;
                }
            }
            return test;
        }

        public P2<Test, Test> splitEquality() {
            assert (this.op == ZenoTestOp.NotEqualToZero || this.op == ZenoTestOp.EqualToZero);
            Linear lin = this.expr;
            BigInt ofs = this.op == ZenoTestOp.NotEqualToZero ? Bound.ONE : Bound.ZERO;
            Test less = zeno.comparison(lin.add(ofs), ZenoTestOp.LessThanOrEqualToZero);
            Test greater = zeno.comparison(zeno.linear(lin.negate().add(ofs)), ZenoTestOp.LessThanOrEqualToZero);
            return P2.tuple2(less, greater);
        }

        @Override
        public int compareTo(Test other) {
            int cmp = this.op.compareTo(other.op);
            if (cmp == 0) {
                return this.expr.compareTo(other.expr);
            }
            return cmp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Test)) {
                return false;
            }
            Test other = (Test)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            return result;
        }

        @Override
        public XMLBuilder toXML(XMLBuilder builder) {
            Linear equation = this.expr;
            builder = builder.e("Equation");
            builder = equation.toXML(builder);
            builder = builder.up();
            builder = builder.e("Operator").t(this.op.toString()).up();
            return builder;
        }

        public String toString() {
            if (this.expr.isConstantOnly()) {
                return this.expr.toString() + " " + (Object)((Object)this.op);
            }
            Linear lhs = this.expr;
            NumVar keyVar = lhs.getKey();
            BigInt keyCoeff = lhs.getCoeff(keyVar);
            Linear rhs = lhs.dropTerm(keyVar).negate();
            lhs = Linear.linear(Linear.term(keyCoeff, keyVar));
            if (keyCoeff.isNegative()) {
                lhs = lhs.smul(Bound.MINUSONE);
                rhs = rhs.smul(Bound.MINUSONE);
                if (this.getOperator() == ZenoTestOp.LessThanOrEqualToZero) {
                    Linear swapTemp = rhs;
                    rhs = lhs;
                    lhs = swapTemp;
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append(lhs);
            builder.append(this.getOperator().getOpString());
            builder.append(rhs);
            return builder.toString();
        }

        public String toSimpleString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getExpr());
            builder.append(this.getOperator().getOpString());
            builder.append("0");
            return builder.toString();
        }
    }

    public static final class Bin
    extends Rhs {
        private final ZenoBinOp op;
        private final Rlin left;
        private final Rlin right;

        public Bin(Rlin left, ZenoBinOp op, Rlin right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        public ZenoBinOp getOp() {
            return this.op;
        }

        public Rlin getLeft() {
            return this.left;
        }

        public Rlin getRight() {
            return this.right;
        }

        @Override
        public VarSet getVars() {
            return this.left.getVars().union(this.right.getVars());
        }

        @Override
        public <R, T> R accept(ZenoVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String toString() {
            return this.left + " " + (Object)((Object)this.op) + " " + this.right;
        }
    }

    public static abstract class Rhs {
        public abstract <R, T> R accept(ZenoVisitor<R, T> var1, T var2);

        public abstract VarSet getVars();

        public abstract String toString();
    }

    public static final class Lhs {
        private final NumVar id;

        public Lhs(NumVar id) {
            this.id = id;
        }

        public NumVar getId() {
            return this.id;
        }

        public <R, T> R accept(ZenoVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public String toString() {
            return this.id.toString();
        }
    }

    public static final class Assign
    extends Zeno {
        private final Lhs lhs;
        private final Rhs rhs;

        public Assign(Lhs lhs, Rhs rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public Lhs getLhs() {
            return this.lhs;
        }

        public Rhs getRhs() {
            return this.rhs;
        }

        @Override
        public <R, T> R accept(ZenoVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public String toString() {
            return this.lhs + " = " + this.rhs;
        }
    }

    public static enum ZenoTestOp {
        EqualToZero("="),
        NotEqualToZero("\u2260"),
        LessThanOrEqualToZero("\u2264");

        private final String pretty;

        private ZenoTestOp(String pretty) {
            this.pretty = pretty;
        }

        public String toString() {
            return this.pretty + " 0";
        }

        public String getOpString() {
            return this.pretty;
        }
    }

    public static enum ZenoBinOp {
        Mul("*"),
        Div("/"),
        Shl("<<"),
        Shr(">>"),
        Mod("%");

        private final String infixSymbol;

        private ZenoBinOp(String infixSymbol) {
            this.infixSymbol = infixSymbol;
        }

        public String toString() {
            return this.infixSymbol;
        }
    }
}

