/*
 * Decompiled with CFR 0.152.
 */
package bindead.abstractsyntax.finite;

import bindead.abstractsyntax.finite.FiniteExprVisitor;
import bindead.abstractsyntax.finite.FiniteFactory;
import bindead.data.FoldMap;
import bindead.data.Linear;
import bindead.data.NumVar;
import bindead.data.VarSet;
import bindead.domains.affine.Substitution;
import com.jamesmurty.utils.XMLBuilder;
import javalx.exceptions.UnimplementedException;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;
import javalx.xml.XmlPrintable;
import rreil.lang.BinOp;
import rreil.lang.ComparisonOp;

public class Finite {

    public static class Test
    implements Comparable<Test>,
    XmlPrintable {
        private final int size;
        private final Linear leftExpr;
        private final TestOp operator;
        private final Linear rightExpr;

        Test(int size, Linear leftExpr, TestOp operator, Linear rightExpr) {
            assert (size >= 0);
            this.size = size;
            this.rightExpr = rightExpr;
            this.operator = operator;
            this.leftExpr = leftExpr;
        }

        public int getSize() {
            return this.size;
        }

        public Linear getLeftExpr() {
            return this.leftExpr;
        }

        public TestOp getOperator() {
            return this.operator;
        }

        public Linear getRightExpr() {
            return this.rightExpr;
        }

        public Linear toLinear() {
            return this.getLeftExpr().sub(this.getRightExpr());
        }

        public Rlin toRLin() {
            return new Rlin(this.getSize(), this.toLinear());
        }

        public Test not() {
            switch (this.operator) {
                case Equal: {
                    return new Test(this.size, this.leftExpr, TestOp.NotEqual, this.rightExpr);
                }
                case NotEqual: {
                    return new Test(this.size, this.leftExpr, TestOp.Equal, this.rightExpr);
                }
                case SignedLessThan: {
                    return new Test(this.size, this.rightExpr, TestOp.SignedLessThanOrEqual, this.leftExpr);
                }
                case SignedLessThanOrEqual: {
                    return new Test(this.size, this.rightExpr, TestOp.SignedLessThan, this.leftExpr);
                }
                case UnsignedLessThan: {
                    return new Test(this.size, this.rightExpr, TestOp.UnsignedLessThanOrEqual, this.leftExpr);
                }
                case UnsignedLessThanOrEqual: {
                    return new Test(this.size, this.rightExpr, TestOp.UnsignedLessThan, this.leftExpr);
                }
            }
            throw new IllegalStateException();
        }

        public final Test build(Linear left, Linear right) {
            return new Test(this.size, left, this.operator, right);
        }

        public final Test build(int size, Linear left, Linear right) {
            return new Test(size, left, this.operator, right);
        }

        public final Test build(Linear left) {
            return this.build(left, Linear.ZERO);
        }

        public Test applySubstitution(Substitution sigma) {
            Linear left = this.leftExpr.applySubstitution(sigma);
            Linear right = this.rightExpr.applySubstitution(sigma);
            return this.build(left, right);
        }

        public Test renameVars(FoldMap pairs) {
            Linear left = this.leftExpr.renameVar(pairs);
            Linear right = this.rightExpr.renameVar(pairs);
            return this.build(left, right);
        }

        public VarSet getVars() {
            return this.leftExpr.getVars().union(this.rightExpr.getVars());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Test)) {
                return false;
            }
            Test other = (Test)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.leftExpr == null ? 0 : this.leftExpr.hashCode());
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            result = 31 * result + (this.rightExpr == null ? 0 : this.rightExpr.hashCode());
            result = 31 * result + this.size;
            return result;
        }

        @Override
        public int compareTo(Test other) {
            int cmp = this.operator.compareTo(other.operator);
            if (cmp == 0) {
                cmp = new Integer(this.size).compareTo(other.size);
            }
            if (cmp == 0) {
                cmp = this.leftExpr.compareTo(other.leftExpr);
            }
            if (cmp == 0) {
                cmp = this.rightExpr.compareTo(other.rightExpr);
            }
            return cmp;
        }

        public String toString() {
            return this.toPrettyString();
        }

        public String toPrettyString() {
            if (this.getLeftExpr().isConstantOnly() && this.getRightExpr().isConstantOnly()) {
                return this.toSimpleString();
            }
            if (this.getLeftExpr().isConstantOnly()) {
                return new Test(this.size, this.rightExpr.negate(), this.operator, this.leftExpr.negate()).toPrettyString();
            }
            Linear lhs = this.getLeftExpr();
            NumVar keyVar = lhs.getKey();
            BigInt keyCoeff = lhs.getCoeff(keyVar);
            Linear rhs = this.getRightExpr();
            if (keyCoeff.isNegative()) {
                lhs = lhs.smul(Bound.MINUSONE);
                rhs = rhs.smul(Bound.MINUSONE);
                if (this.getOperator() != TestOp.Equal && this.getOperator() != TestOp.NotEqual) {
                    Linear swapTemp = rhs;
                    rhs = lhs;
                    lhs = swapTemp;
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append(lhs);
            builder.append((Object)this.getOperator());
            builder.append(rhs);
            return builder.toString();
        }

        public String toSimpleString() {
            return this.leftExpr.toTermsString() + " " + (Object)((Object)this.operator) + ":" + this.size + " " + this.rightExpr.toTermsString();
        }

        @Override
        public XMLBuilder toXML(XMLBuilder builder) {
            builder = builder.e("Equation").a("side", "left");
            builder = this.leftExpr.toXML(builder);
            builder = builder.up();
            builder = builder.e("Operator").t(this.operator.toString()).up();
            builder = builder.e("Size").t(String.valueOf(this.size)).up();
            builder = builder.e("Equation").a("side", "right");
            builder = this.rightExpr.toXML(builder);
            builder = builder.up();
            return builder;
        }
    }

    public static enum TestOp {
        Equal("="),
        NotEqual("\u2260"),
        UnsignedLessThanOrEqual("\u22b4"),
        SignedLessThanOrEqual("\u2264"),
        UnsignedLessThan("\u22b2"),
        SignedLessThan("<");

        private final String opString;

        private TestOp(String opString) {
            this.opString = opString;
        }

        public String toString() {
            return this.opString;
        }
    }

    public static final class FiniteRangeRhs
    extends Rhs {
        private final Interval range;
        private final int size;

        public FiniteRangeRhs(int size, Interval range) {
            assert (size >= 0);
            this.size = size;
            this.range = range;
        }

        public Interval getRange() {
            return this.range;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public <R, T> R accept(FiniteExprVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public StringBuilder asString(StringBuilder builder) {
            builder.append(this.range).append(':').append(this.size);
            return builder;
        }
    }

    public static final class Rlin
    extends Rhs {
        private final Linear linearTerm;
        private final int size;

        Rlin(int size, Linear lin) {
            assert (size >= 0);
            this.size = size;
            this.linearTerm = lin;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        public Rlin add(Rlin other) {
            assert (other.size == this.size);
            Linear res = this.linearTerm.add(other.linearTerm);
            return new Rlin(this.size, res);
        }

        public Rlin sub(Rlin other) {
            assert (other.size == this.size);
            Linear res = this.linearTerm.sub(other.linearTerm);
            return new Rlin(this.size, res);
        }

        public Rlin smul(BigInt scalar) {
            return new Rlin(this.getSize(), this.getLinearTerm().smul(scalar));
        }

        public Linear getLinearTerm() {
            return this.linearTerm;
        }

        public VarSet getVars() {
            return this.linearTerm.getVars();
        }

        @Override
        public String toString() {
            return "{" + this.linearTerm + "}:" + this.size;
        }

        @Override
        public <R, T> R accept(FiniteExprVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public StringBuilder asString(StringBuilder builder) {
            return builder.append(this.toString());
        }

        public boolean equals(Object o) {
            if (!(o instanceof Rlin)) {
                return false;
            }
            Rlin other = (Rlin)o;
            return this.size == other.size && this.linearTerm.equals(other.linearTerm);
        }

        public int hashCode() {
            throw new UnimplementedException();
        }
    }

    public static final class Cmp
    extends Rhs {
        private static final FiniteFactory finite = FiniteFactory.getInstance();
        private final ComparisonOp op;
        private final Rlin left;
        private final Rlin right;

        Cmp(Rlin left, ComparisonOp op, Rlin right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        public ComparisonOp getOp() {
            return this.op;
        }

        public Rlin getLeft() {
            return this.left;
        }

        public Rlin getRight() {
            return this.right;
        }

        public Test asTest() {
            assert (this.left.size == this.right.size);
            int size = this.getSize();
            Linear l = this.left.linearTerm;
            Linear r = this.right.linearTerm;
            Test test = null;
            switch (this.op) {
                case Cmpeq: {
                    test = finite.equalTo(size, l, r);
                    break;
                }
                case Cmpneq: {
                    test = finite.notEqualTo(size, l, r);
                    break;
                }
                case Cmples: {
                    test = finite.signedLessThanOrEqualTo(size, l, r);
                    break;
                }
                case Cmpleu: {
                    test = finite.unsignedLessThanOrEqualTo(size, l, r);
                    break;
                }
                case Cmplts: {
                    test = finite.signedLessThan(size, l, r);
                    break;
                }
                case Cmpltu: {
                    test = finite.unsignedLessThan(size, l, r);
                }
            }
            return test;
        }

        @Override
        public <R, T> R accept(FiniteExprVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public StringBuilder asString(StringBuilder builder) {
            this.left.asString(builder).append(' ');
            builder.append(this.op.asInfix()).append(' ');
            this.right.asString(builder);
            return builder;
        }

        @Override
        public int getSize() {
            assert (this.left.getSize() == this.right.getSize());
            return this.left.getSize();
        }
    }

    public static final class Bin
    extends Rhs {
        private final BinOp op;
        private final Rlin left;
        private final Rlin right;

        Bin(Rlin left, BinOp op, Rlin right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        @Override
        public <R, T> R accept(FiniteExprVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public BinOp getOp() {
            return this.op;
        }

        public Rlin getLeft() {
            return this.left;
        }

        public Rlin getRight() {
            return this.right;
        }

        @Override
        public StringBuilder asString(StringBuilder builder) {
            this.left.asString(builder).append(' ');
            builder.append(this.op.asInfix()).append(' ');
            this.right.asString(builder);
            return builder;
        }

        @Override
        public int getSize() {
            assert (this.left.getSize() == this.right.getSize());
            return this.left.getSize();
        }
    }

    public static final class Convert
    extends Rhs {
        private final Rlin expr;

        Convert(Rlin rval) {
            this.expr = rval;
        }

        @Override
        public <R, T> R accept(FiniteExprVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public Rlin getExpr() {
            return this.expr;
        }

        @Override
        public StringBuilder asString(StringBuilder builder) {
            builder.append("convert(");
            this.expr.asString(builder);
            builder.append(')');
            return builder;
        }

        @Override
        public int getSize() {
            return this.expr.getSize();
        }
    }

    public static final class SignExtend
    extends Rhs {
        private final Rlin expr;

        SignExtend(Rlin rval) {
            this.expr = rval;
        }

        @Override
        public <R, T> R accept(FiniteExprVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public Rlin getExpr() {
            return this.expr;
        }

        @Override
        public StringBuilder asString(StringBuilder builder) {
            builder.append("sign-extend(");
            this.expr.asString(builder);
            builder.append(')');
            return builder;
        }

        @Override
        public int getSize() {
            return this.expr.getSize();
        }
    }

    public static abstract class Rhs {
        public String toString() {
            return this.asString(new StringBuilder()).toString();
        }

        public abstract <R, T> R accept(FiniteExprVisitor<R, T> var1, T var2);

        public abstract StringBuilder asString(StringBuilder var1);

        public abstract int getSize();
    }

    public static final class Lhs {
        private final int size;
        private final NumVar id;

        Lhs(int size, NumVar id) {
            assert (size >= 0);
            this.size = size;
            this.id = id;
        }

        public NumVar getId() {
            return this.id;
        }

        public int getSize() {
            return this.size;
        }

        public StringBuilder asString(StringBuilder builder) {
            return builder.append(this.id.toString()).append(':').append(this.size);
        }

        public String toString() {
            return this.asString(new StringBuilder()).toString();
        }
    }

    public static final class Assign {
        private final Lhs lhs;
        private final Rhs rhs;

        Assign(Lhs lhs, Rhs rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public Lhs getLhs() {
            return this.lhs;
        }

        public Rhs getRhs() {
            return this.rhs;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.lhs.asString(builder);
            builder.append(" =").append(this.lhs.getSize()).append(' ');
            this.rhs.asString(builder);
            return builder.toString();
        }
    }
}

