/*
 * Decompiled with CFR 0.152.
 */
package apron;

import apron.Coeff;
import apron.Environment;
import apron.Linexpr0;
import apron.Linterm0;
import apron.Linterm1;
import java.io.Serializable;

public class Linexpr1
implements Cloneable,
Serializable {
    protected Linexpr0 expr;
    protected Environment env;

    private Linexpr1() {
    }

    public static Linexpr1 make(Environment environment, Linexpr0 linexpr0) {
        Linexpr1 linexpr1 = new Linexpr1();
        linexpr1.expr = linexpr0;
        linexpr1.env = environment;
        return linexpr1;
    }

    public Linexpr1(Environment environment, int n) {
        this.expr = new Linexpr0(true, n);
        this.env = environment;
    }

    public Linexpr1(Environment environment) {
        this.expr = new Linexpr0(false, environment.getSize());
        this.env = environment;
    }

    public Linexpr1(Linexpr1 linexpr1) {
        this.expr = new Linexpr0(linexpr1.expr);
        this.env = linexpr1.env;
    }

    public Linexpr1(Environment environment, Linterm1[] linterm1Array, Coeff coeff) {
        this.expr = new Linexpr0(true, linterm1Array.length);
        this.env = environment;
        this.setCoeff(linterm1Array);
        this.setCst(coeff);
    }

    public Linexpr1(Environment environment, Coeff[] coeffArray, Coeff coeff) {
        if (coeffArray.length != environment.getSize()) {
            throw new IllegalArgumentException("invalid array size");
        }
        this.expr = new Linexpr0(coeffArray, coeff);
        this.env = environment;
    }

    public Linexpr1(Environment environment, Linexpr0 linexpr0) {
        if (environment.getSize() < linexpr0.maxDim()) {
            throw new IllegalArgumentException("environment is too small");
        }
        this.expr = new Linexpr0(linexpr0);
        this.env = environment;
    }

    public void setCst(Coeff coeff) {
        this.expr.setCst(coeff);
    }

    public void setCoeff(String string, Coeff coeff) {
        this.expr.setCoeff(this.env.dimOfVar(string), coeff);
    }

    public void setCoeff(Linterm1[] linterm1Array) {
        for (int i = 0; i < linterm1Array.length; ++i) {
            this.setCoeff(linterm1Array[i].var, linterm1Array[i].coeff);
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public Linexpr0 getLinexpr0() {
        return new Linexpr0(this.expr);
    }

    public Linexpr0 getLinexpr0Ref() {
        return this.expr;
    }

    public Coeff getCst() {
        return this.expr.getCst();
    }

    public Coeff getCoeff(String string) {
        return this.expr.getCoeff(this.env.dimOfVar(string));
    }

    public Linterm1[] getLinterms() {
        Linterm0[] linterm0Array = this.expr.getLinterms();
        Linterm1[] linterm1Array = new Linterm1[linterm0Array.length];
        for (int i = 0; i < linterm0Array.length; ++i) {
            linterm1Array[i] = new Linterm1(this.env.varOfDim(linterm0Array[i].dim), linterm0Array[i].coeff);
        }
        return linterm1Array;
    }

    public Coeff[] getCoeffs() {
        return this.expr.getCoeffs();
    }

    public String toString() {
        return this.expr.toString(this.env.getVars());
    }

    public int hashCode() {
        return this.expr.hashCode() ^ this.env.hashCode();
    }

    public boolean isSparse() {
        return this.expr.isSparse();
    }

    public boolean isInteger() {
        return this.expr.isInteger(this.env.getDimension().intDim);
    }

    public boolean isReal() {
        return this.expr.isReal(this.env.getDimension().intDim);
    }

    public boolean isLinear() {
        return this.expr.isLinear();
    }

    public boolean isQuasilinear() {
        return this.expr.isQuasilinear();
    }

    public boolean isEqual(Linexpr1 linexpr1) {
        return this.env.isEqual(linexpr1.env) && this.expr.isEqual(linexpr1.expr);
    }

    public int cmp(Linexpr1 linexpr1) {
        int n = this.env.cmp(linexpr1.env);
        if (n == 0) {
            return this.expr.cmp(linexpr1.expr);
        }
        return n;
    }

    public void minimize() {
        this.expr.minimize();
    }

    public void extendEnvironment(Environment environment) {
        this.expr.addDimensions(this.env.dimchange(environment));
        this.env = environment;
    }

    public Linexpr1 extendEnvironmentCopy(Environment environment) {
        return Linexpr1.make(environment, this.expr.addDimensionsCopy(this.env.dimchange(environment)));
    }

    public Linexpr1 clone() throws CloneNotSupportedException {
        return new Linexpr1(this);
    }

    public boolean equals(Object object) {
        return object instanceof Linexpr1 && this.isEqual((Linexpr1)object);
    }
}

