/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nb.barmie.exceptions.BaRMIeIllegalArgumentException;
import nb.barmie.exceptions.BaRMIeInvalidPortException;
import nb.barmie.net.TCPEndpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProgramOptions {
    private final String DEFAULT_MODE = "-enum";
    private final int DEFAULT_THREADS = 10;
    private final int DEFAULT_SOCKTIMEOUT = 5000;
    private final int DEFAULT_RMIPORT = 1099;
    private String _mode;
    private ArrayList<TCPEndpoint> _targets;
    private int _threadCount;
    private int _socketTimeout;

    public ProgramOptions(String[] args) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        this.setDefaultOptions();
        this.parseCommandLineArgs(args);
    }

    private void setDefaultOptions() {
        this._mode = this.DEFAULT_MODE;
        this._targets = new ArrayList();
        this._threadCount = this.DEFAULT_THREADS;
        this._socketTimeout = this.DEFAULT_SOCKTIMEOUT;
    }

    private void parseCommandLineArgs(String[] args) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        String val;
        String opt;
        LinkedList<String> argQueue = new LinkedList<String>(Arrays.asList(args));
        if (argQueue.peekFirst().toLowerCase().equals("-enum") || argQueue.peekFirst().toLowerCase().equals("-attack")) {
            this._mode = argQueue.pop().toLowerCase();
        }
        block20: while (argQueue.size() > 0 && argQueue.peekFirst().startsWith("--")) {
            opt = argQueue.pop().toLowerCase();
            val = argQueue.pop();
            switch (opt) {
                case "--threads": {
                    if (this._mode.equals("-attack")) {
                        throw new BaRMIeIllegalArgumentException("--threads option is not supported in attack mode.");
                    }
                    try {
                        this._threadCount = Integer.parseInt(val);
                        continue block20;
                    }
                    catch (NumberFormatException nfe) {
                        throw new BaRMIeIllegalArgumentException("Thread count must be an integer.");
                    }
                }
                case "--timeout": {
                    try {
                        this._socketTimeout = Integer.parseInt(val);
                        continue block20;
                    }
                    catch (NumberFormatException nfe) {
                        throw new BaRMIeIllegalArgumentException("Timeout must be an integer.");
                    }
                }
                case "--targets": {
                    this.loadTargets(val);
                    continue block20;
                }
            }
            throw new BaRMIeIllegalArgumentException("Unsupported option specified (" + opt + ")");
        }
        if (argQueue.size() == 0) {
            if (this._targets.size() == 0) {
                throw new BaRMIeIllegalArgumentException("No scan targets were specified.");
            }
        } else {
            if (this._targets.size() > 0) {
                throw new BaRMIeIllegalArgumentException("Invalid command line, either specify a single target on the command line or load targets from a file using --targets.");
            }
            switch (argQueue.size()) {
                case 1: {
                    this._targets.add(new TCPEndpoint(argQueue.pop(), 1099));
                    break;
                }
                case 2: {
                    int targetPort;
                    opt = argQueue.pop();
                    val = argQueue.pop();
                    try {
                        targetPort = Integer.parseInt(val);
                    }
                    catch (NumberFormatException nfe) {
                        throw new BaRMIeIllegalArgumentException("Target port (" + val + ") must be a valid integer.");
                    }
                    this._targets.add(new TCPEndpoint(opt, targetPort));
                    break;
                }
                default: {
                    throw new BaRMIeIllegalArgumentException("Invalid command line, parameters following the target are not supported.");
                }
            }
        }
    }

    private void loadTargets(String targetFilename) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        switch (this.getNetworkTargetsFileFormat(targetFilename)) {
            case "basic": {
                this.loadNetworkTargetsBasic(targetFilename);
                break;
            }
            case "nmap": {
                this.loadNetworkTargetsNmap(targetFilename);
                break;
            }
            case "gnmap": {
                this.loadNetworkTargetsGnmap(targetFilename);
                break;
            }
            case "nmapxml": {
                this.loadNetworkTargetsNmapXml(targetFilename);
            }
        }
        if (this._targets.size() == 0) {
            throw new BaRMIeIllegalArgumentException("No targets were identified within the given targets file.");
        }
    }

    private String getNetworkTargetsFileFormat(String targetFilename) throws BaRMIeIllegalArgumentException {
        BufferedReader targetFileReader = null;
        try {
            targetFileReader = new BufferedReader(new FileReader(targetFilename));
            String fileLine = targetFileReader.readLine();
            if (fileLine.startsWith("# Nmap ")) {
                fileLine = targetFileReader.readLine();
                if (fileLine != null && fileLine.startsWith("Host: ")) {
                    String string = "gnmap";
                    return string;
                }
                String string = "nmap";
                return string;
            }
            if (fileLine.startsWith("<?xml ")) {
                String string = "nmapxml";
                return string;
            }
            String string = "basic";
            return string;
        }
        catch (FileNotFoundException fnfe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be found.", fnfe);
        }
        catch (IOException ioe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be read.", ioe);
        }
        finally {
            if (targetFileReader != null) {
                try {
                    targetFileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadNetworkTargetsBasic(String targetFilename) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        BufferedReader targetFileReader = null;
        try {
            String fileLine;
            targetFileReader = new BufferedReader(new FileReader(targetFilename));
            while ((fileLine = targetFileReader.readLine()) != null) {
                String[] lineParts = fileLine.split(" ");
                switch (lineParts.length) {
                    case 1: {
                        this._targets.add(new TCPEndpoint(lineParts[0], this.DEFAULT_RMIPORT));
                        break;
                    }
                    case 2: {
                        try {
                            this._targets.add(new TCPEndpoint(lineParts[0], Integer.parseInt(lineParts[1])));
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            throw new BaRMIeIllegalArgumentException("Error parsing targets file, '" + lineParts[1] + "' is not a valid port number.");
                        }
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be found.", fnfe);
        }
        catch (IOException ioe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be read.", ioe);
        }
        finally {
            if (targetFileReader != null) {
                try {
                    targetFileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadNetworkTargetsNmap(String targetFilename) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        BufferedReader targetFileReader = null;
        String currentHost = "";
        try {
            String fileLine;
            targetFileReader = new BufferedReader(new FileReader(targetFilename));
            while ((fileLine = targetFileReader.readLine()) != null) {
                if (fileLine.startsWith("Nmap scan report for ")) {
                    if (fileLine.contains("(")) {
                        currentHost = fileLine.split(" ")[5];
                        currentHost = currentHost.substring(1, currentHost.length() - 1);
                        continue;
                    }
                    currentHost = fileLine.split(" ")[4];
                    continue;
                }
                if (fileLine.startsWith("1099/tcp") && fileLine.split("\\w+")[1].equals("open")) {
                    this._targets.add(new TCPEndpoint(currentHost, this.DEFAULT_RMIPORT));
                    continue;
                }
                if (!fileLine.contains("rmiregistry") && !fileLine.contains("Java RMI") && !fileLine.contains("java-rmi")) continue;
                try {
                    this._targets.add(new TCPEndpoint(currentHost, Integer.parseInt(fileLine.split("/")[0])));
                }
                catch (NumberFormatException nfe) {
                    throw new BaRMIeIllegalArgumentException("Error extracting targets from nmap output - the host '" + currentHost + "' appears to have an 'rmiregistry' service running on a non-standard port number that cannot e converted into an integer '" + fileLine.split("/")[0] + "'.");
                    return;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be found.", fnfe);
        }
        catch (IOException ioe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be read.", ioe);
        }
        finally {
            if (targetFileReader != null) {
                try {
                    targetFileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadNetworkTargetsGnmap(String targetFilename) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        BufferedReader targetFileReader = null;
        try {
            String fileLine;
            targetFileReader = new BufferedReader(new FileReader(targetFilename));
            while ((fileLine = targetFileReader.readLine()) != null) {
                String[] allScannedPorts;
                if (!fileLine.startsWith("Host: ") || !fileLine.contains("Ports: ")) continue;
                for (String currentPortSection : allScannedPorts = fileLine.split("Ports: ")[1].split(", ")) {
                    String[] portDetails = currentPortSection.split("/");
                    if (currentPortSection.startsWith("1099/open/tcp")) {
                        try {
                            this._targets.add(new TCPEndpoint(fileLine.split(" ")[0], 1099));
                        }
                        catch (BaRMIeInvalidPortException baRMIeInvalidPortException) {}
                        continue;
                    }
                    if (!currentPortSection.contains("/open/") || !currentPortSection.contains("/rmiregistry/") && !currentPortSection.contains("/java-rmi/") && !currentPortSection.contains("/Java RMI/")) continue;
                    try {
                        this._targets.add(new TCPEndpoint(fileLine.split(" ")[0], Integer.parseInt(portDetails[0])));
                    }
                    catch (NumberFormatException nfe) {
                        throw new BaRMIeIllegalArgumentException("Error extracting targets from nmap output - the host '" + fileLine.split(" ")[0] + "' appears to have an 'rmiregistry' service running on a non-standard port number that cannot e converted into an integer '" + portDetails[0] + "'.");
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be found.", fnfe);
        }
        catch (IOException ioe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be read.", ioe);
        }
        finally {
            if (targetFileReader != null) {
                try {
                    targetFileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadNetworkTargetsNmapXml(String targetFilename) throws BaRMIeIllegalArgumentException, BaRMIeInvalidPortException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setExpandEntityReferences(false);
            dbf.setXIncludeAware(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(new File(targetFilename));
            NodeList hostNodes = xmlDoc.getElementsByTagName("host");
            for (int hostIndex = 0; hostIndex < hostNodes.getLength(); ++hostIndex) {
                Element hostElement = (Element)hostNodes.item(hostIndex);
                NodeList hostAddressNodes = hostElement.getElementsByTagName("address");
                NodeList portNodes = hostElement.getElementsByTagName("port");
                for (int portIndex = 0; portIndex < portNodes.getLength(); ++portIndex) {
                    Element portElement = (Element)portNodes.item(portIndex);
                    if (!portElement.getAttribute("protocol").equalsIgnoreCase("tcp") || portElement.getElementsByTagName("state").getLength() != 1 || !((Element)portElement.getElementsByTagName("state").item(0)).getAttribute("state").equalsIgnoreCase("open")) continue;
                    if (portElement.getAttribute("portid").equals("1099")) {
                        this._targets.add(new TCPEndpoint(((Element)hostAddressNodes.item(0)).getAttribute("addr"), 1099));
                        continue;
                    }
                    if (portElement.getElementsByTagName("service").getLength() != 1) continue;
                    if (((Element)portElement.getElementsByTagName("service").item(0)).getAttribute("name").equals("rmiregistry")) {
                        try {
                            this._targets.add(new TCPEndpoint(((Element)hostAddressNodes.item(0)).getAttribute("addr"), Integer.parseInt(portElement.getAttribute("portid"))));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new BaRMIeIllegalArgumentException("Invalid port number specified in nmap xml output ('" + portElement.getAttribute("portid") + ").", ex);
                        }
                    }
                    if (((Element)portElement.getElementsByTagName("service").item(0)).getAttribute("product").equals("Java RMI")) {
                        try {
                            this._targets.add(new TCPEndpoint(((Element)hostAddressNodes.item(0)).getAttribute("addr"), Integer.parseInt(portElement.getAttribute("portid"))));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new BaRMIeIllegalArgumentException("Invalid port number specified in nmap xml output ('" + portElement.getAttribute("portid") + ").", ex);
                        }
                    }
                    if (!((Element)portElement.getElementsByTagName("service").item(0)).getAttribute("name").equals("java-rmi")) continue;
                    try {
                        this._targets.add(new TCPEndpoint(((Element)hostAddressNodes.item(0)).getAttribute("addr"), Integer.parseInt(portElement.getAttribute("portid"))));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new BaRMIeIllegalArgumentException("Invalid port number specified in nmap xml output ('" + portElement.getAttribute("portid") + ").", ex);
                    }
                }
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("An exception occurred whilst configuring the XML parser.", pce);
        }
        catch (SAXException saxe) {
            throw new BaRMIeIllegalArgumentException("An error occurred whilst attempting to parse the targets file as xml.", saxe);
        }
        catch (IOException ioe) {
            throw new BaRMIeIllegalArgumentException("Targets file could not be read.", ioe);
        }
    }

    public String getExecutionMode() {
        return this._mode;
    }

    public ArrayList<TCPEndpoint> getTargets() {
        return this._targets;
    }

    public int getThreadCount() {
        return this._threadCount;
    }

    public int getSocketTimeout() {
        return this._socketTimeout;
    }
}

