/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.net.proxy;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.exceptions.BaRMIeProxyAlreadyStartedException;
import nb.barmie.exceptions.BaRMIeProxyStartupException;
import nb.barmie.net.proxy.ProxySession;
import nb.barmie.net.proxy.thread.PassThroughProxyThread;
import nb.barmie.util.ProgramOptions;

public class ProxyServer
extends Thread {
    private static final int SERVER_SOCK_TIMEOUT = 100;
    private static final int SERVER_THREAD_JOIN_TIMEOUT = 300;
    private volatile ServerSocket _serverSocket = null;
    private final InetAddress _targetHost;
    private final int _targetPort;
    private int _listenPort;
    protected final ProgramOptions _options;
    protected volatile ArrayList<ProxySession> _proxySessions;
    private volatile BaRMIeException _startupException;
    private volatile boolean _readyForConnections;
    private volatile boolean _shutdown;
    private volatile boolean _forceShutdown;

    public ProxyServer(InetAddress targetHost, int targetPort, ProgramOptions options) {
        this._targetHost = targetHost;
        this._targetPort = targetPort;
        this._listenPort = 0;
        this._options = options;
        this._proxySessions = new ArrayList();
        this._startupException = null;
        this._readyForConnections = false;
        this._shutdown = false;
        this._forceShutdown = false;
    }

    public final void startProxy() throws BaRMIeException {
        if (this._serverSocket != null) {
            throw new BaRMIeProxyAlreadyStartedException("The proxy server has already been started and must be shutdown before it can be started again.");
        }
        if (this._proxySessions.size() > 0) {
            throw new BaRMIeProxyAlreadyStartedException("There are existing proxy server sessions that must be terminated before starting the proxy again.");
        }
        this._startupException = null;
        this._readyForConnections = false;
        this._shutdown = false;
        this.start();
        while (!this._readyForConnections && this._startupException == null) {
        }
        if (this._startupException != null) {
            throw this._startupException;
        }
    }

    @Override
    public final void run() {
        if (this._serverSocket != null) {
            this._startupException = new BaRMIeProxyAlreadyStartedException("The proxy server has already been started and must be shutdown before it can be started again.");
            return;
        }
        if (this._proxySessions.size() > 0) {
            this._startupException = new BaRMIeProxyAlreadyStartedException("There are existing proxy server sessions that must be terminated before starting the proxy again.");
            return;
        }
        try {
            this._serverSocket = new ServerSocket(this._listenPort, 2, InetAddress.getLoopbackAddress());
            this._serverSocket.setSoTimeout(100);
        }
        catch (Exception ex) {
            if (this._serverSocket != null) {
                try {
                    this._serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._serverSocket = null;
            }
            this._startupException = new BaRMIeProxyStartupException("An exception occurred whilst attempting to start an RMI object proxy.", ex);
            return;
        }
        this._readyForConnections = true;
        while (!this._shutdown) {
            try {
                Socket clientSock = this._serverSocket.accept();
                clientSock.setSoTimeout(this._options.getSocketTimeout());
                Socket targetSock = new Socket(this._targetHost, this._targetPort);
                targetSock.setSoTimeout(this._options.getSocketTimeout());
                ProxySession ps = this.createProxySession(clientSock, targetSock);
                if (ps == null) continue;
                this._proxySessions.add(ps);
                ps.start();
            }
            catch (SocketTimeoutException ste) {
            }
            catch (SocketException se) {
            }
            catch (Exception ex) {
                System.out.println("[-] An exception occurred in the proxy main loop (" + this.getClass().getSimpleName() + ").\n\t" + ex.toString());
                ex.printStackTrace();
            }
        }
        this._readyForConnections = false;
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._serverSocket = null;
        }
    }

    public final void stopProxy() {
        this.stopProxy(false);
    }

    public final void stopProxy(boolean force) {
        if (!this._shutdown) {
            this._shutdown = true;
            this._forceShutdown = force;
            if (force) {
                if (this._serverSocket != null) {
                    try {
                        this._serverSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._serverSocket = null;
                }
                if (this.isAlive()) {
                    this.interrupt();
                }
            } else {
                try {
                    this.join(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isAlive()) {
                    this.interrupt();
                }
                if (this._serverSocket != null) {
                    try {
                        this._serverSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this._serverSocket = null;
                }
            }
            for (ProxySession ps : this._proxySessions) {
                ps.shutdown(force);
            }
            this._proxySessions.clear();
        }
    }

    public final InetAddress getServerListenAddress() {
        return this._serverSocket.getInetAddress();
    }

    public final int getServerListenPort() {
        return this._serverSocket.getLocalPort();
    }

    public final void setServerListenPort(int port) {
        this._listenPort = port;
    }

    protected ProxySession createProxySession(Socket clientSock, Socket targetSock) {
        return new ProxySession(new PassThroughProxyThread(clientSock, targetSock), new PassThroughProxyThread(targetSock, clientSock));
    }
}

