/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.enumeration;

import java.util.ArrayList;
import nb.barmie.modes.enumeration.RMIObject;
import nb.barmie.net.TCPEndpoint;

public class RMIEndpoint {
    private final TCPEndpoint _endpoint;
    private boolean _isRMIEndpoint;
    private boolean _isRegistry;
    private boolean _isRemotelyModifiable;
    private final ArrayList<RMIObject> _exposedObjects;
    private Exception _enumerationException;

    public RMIEndpoint(TCPEndpoint endpoint) {
        this._endpoint = endpoint;
        this._isRMIEndpoint = false;
        this._isRegistry = false;
        this._isRemotelyModifiable = false;
        this._exposedObjects = new ArrayList();
    }

    public void addRMIObject(RMIObject object) {
        this._exposedObjects.add(object);
    }

    public boolean hasClass(String className) {
        for (RMIObject obj : this._exposedObjects) {
            for (String c : obj.getObjectClasses().keySet()) {
                if (!c.equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    public String findObjectWithClass(String className) {
        for (RMIObject obj : this._exposedObjects) {
            for (String c : obj.getObjectClasses().keySet()) {
                if (!c.equals(className)) continue;
                return obj.getObjectName();
            }
        }
        return null;
    }

    public boolean hasJar(String jarName) {
        for (RMIObject obj : this._exposedObjects) {
            for (String a : obj.getStringAnnotations()) {
                for (String path : a.split("[ ;:]")) {
                    String[] pathParts = path.split("[\\\\/]");
                    if (pathParts.length <= 0 || !jarName.toLowerCase().equals(pathParts[pathParts.length - 1].toLowerCase())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setIsRMIEndpoint(boolean isRMIEndpoint) {
        this._isRMIEndpoint = isRMIEndpoint;
    }

    public void setIsRegistry(boolean isRegistry) {
        this._isRegistry = isRegistry;
    }

    public void setIsRemotelyModifiable(boolean isModifiable) {
        this._isRemotelyModifiable = isModifiable;
    }

    public void setEnumException(Exception ex) {
        this._enumerationException = ex;
    }

    public TCPEndpoint getEndpoint() {
        return this._endpoint;
    }

    public boolean isRMIEndpoint() {
        return this._isRMIEndpoint;
    }

    public boolean isRegistry() {
        return this._isRegistry && this._isRMIEndpoint;
    }

    public boolean isObjectEndpoint() {
        return !this._isRegistry && this._isRMIEndpoint;
    }

    public boolean isRemotelyModifiable() {
        return this._isRemotelyModifiable;
    }

    public Exception getEnumException() {
        return this._enumerationException;
    }

    public ArrayList<RMIObject> getExposedObjects() {
        return this._exposedObjects;
    }
}

