/*
 * Decompiled with CFR 0.152.
 */
package nb.barmie.modes.attack;

import java.util.ArrayList;
import java.util.Collections;
import nb.barmie.modes.attack.DeserPayload;
import nb.barmie.modes.attack.DeserPayloadFactory;
import nb.barmie.modes.attack.RMIAttack;
import nb.barmie.modes.attack.RMIAttackFactory;
import nb.barmie.modes.enumeration.RMIEndpoint;

public class RMITargetData {
    private RMIEndpoint _endpoint;
    private ArrayList<RMIAttack> _attacks;
    private ArrayList<DeserPayload> _payloads;

    public RMITargetData(RMIEndpoint endpoint) {
        this._endpoint = endpoint;
        this._attacks = RMIAttackFactory.findAttacksForEndpoint(this._endpoint);
        this._payloads = DeserPayloadFactory.findGadgetsForEndpoint(this._endpoint);
        Collections.sort(this._attacks);
    }

    public boolean hasSupportedAttacks() {
        return this._attacks.size() > 0;
    }

    public boolean hasDeserializationAttacks() {
        for (RMIAttack a : this._attacks) {
            if (!a.isDeserAttack()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAffectedLibs() {
        return this._payloads.size() > 0;
    }

    public String getDetailString() {
        String out = this._endpoint.getEndpoint().toString();
        if (this._attacks.size() > 0) {
            out = out + " Reliability " + this._attacks.get(0).getReliabilityIndicator();
            out = out + ", Deser attack ";
            if (this.hasDeserializationAttacks()) {
                out = out + "[Y], payload ";
                out = this.hasAffectedLibs() ? out + "[Y]" : out + "[?]";
            } else {
                out = out + "[N]";
            }
        } else {
            out = out + " No attacks available.";
        }
        return out;
    }

    public RMIEndpoint getEndpoint() {
        return this._endpoint;
    }

    public ArrayList<RMIAttack> getAttacks() {
        return this._attacks;
    }

    public ArrayList<DeserPayload> getDeserPayloads() {
        return this._payloads;
    }
}

